/*
 * Decompiled with CFR 0.152.
 */
package CIspace.graphToolKit;

import CIspace.graphToolKit.Edge;
import CIspace.graphToolKit.GraphCanvas;
import CIspace.graphToolKit.Node;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class EdgeDialog
extends Dialog
implements ActionListener {
    private Button ok;
    private Button cancel;
    private Choice colors;
    private Choice types;
    private GraphCanvas parent;
    private Node start;
    private Node end;
    private TextField label;
    private boolean creating;
    private Edge edge;

    public EdgeDialog(GraphCanvas parent) {
        super((Frame)parent.parent, "Edge Options", true);
        this.parent = parent;
        this.creating = true;
        ((Component)this).setSize(300, 300);
        this.ok = new Button("OK");
        this.cancel = new Button("Cancel");
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.colors = new Choice();
        this.colors.add("Black");
        this.colors.add("Red");
        this.colors.add("Blue");
        this.colors.add("Green");
        this.types = new Choice();
        this.types.add("Directional");
        this.types.add("Bi-directional");
        this.types.add("Non-directional");
        this.label = new TextField("", 10);
        this.label.addActionListener(this);
        this.setLayout(new GridLayout(3, 1));
        Panel p1 = new Panel();
        p1.add(new Label("Label"));
        p1.add(this.label);
        this.add(p1);
        Panel p2 = new Panel();
        p2.add(this.colors);
        p2.add(this.types);
        this.add(p2);
        Panel p4 = new Panel();
        p4.add(this.ok);
        p4.add(this.cancel);
        this.add(p4);
        this.pack();
        this.setResizable(false);
    }

    public void open(Node start, Node end) {
        this.creating = true;
        this.centerWindow();
        this.start = start;
        this.end = end;
        ((Component)this).setVisible(true);
    }

    public void open(Edge e) {
        this.creating = false;
        this.edge = e;
        this.start = e.start;
        this.end = e.end;
        this.label.setText(e.label[0]);
        if (e.color == Color.black) {
            this.colors.select("Black");
        } else if (e.color == Color.red) {
            this.colors.select("Red");
        } else if (e.color == Color.blue) {
            this.colors.select("Blue");
        } else {
            this.colors.select("Green");
        }
        if (e.type == 5551) {
            this.types.select("Directional");
        } else if (e.type == 5552) {
            this.types.select("Bi-directional");
        } else {
            this.types.select("Non-directional");
        }
        this.centerWindow();
        ((Component)this).setVisible(true);
    }

    private void centerWindow() {
        Container parent = this.getParent();
        int midX = parent.getLocationOnScreen().x + parent.getSize().width / 2;
        int midY = parent.getLocationOnScreen().y + parent.getSize().height / 2;
        ((Component)this).setLocation(midX - this.getSize().width / 2, midY - this.getSize().height / 2);
    }

    public void actionPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (!arg.equals("Cancel")) {
            this.parseDialog();
        }
        ((Component)this).setVisible(false);
    }

    private void parseDialog() {
        Color color = this.colors.getSelectedItem() == "Black" ? Color.black : (this.colors.getSelectedItem() == "Red" ? Color.red : (this.colors.getSelectedItem() == "Blue" ? Color.blue : Color.green));
        int type = this.types.getSelectedItem().equals("Directional") ? 5551 : (this.types.getSelectedItem().equals("Bi-directional") ? 5552 : 5550);
        if (this.creating) {
            Edge e = new Edge(this.parent.graph, this.label.getText(), this.start, this.end, color, type);
            this.parent.graph.addEdge(e);
        } else {
            this.parent.graph.modifyEdge(this.edge, this.label.getText(), this.start, this.end, color, type);
        }
    }
}

