/*
 * Decompiled with CFR 0.152.
 */
package CIspace.graphToolKit;

import CIspace.graphToolKit.Edge;
import CIspace.graphToolKit.EdgeLabel;
import CIspace.graphToolKit.Entity;
import CIspace.graphToolKit.GraphCanvas;
import CIspace.graphToolKit.Node;
import CIspace.graphToolKit.Point;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Vector;

public class Graph {
    protected Vector nodes;
    protected Vector edges;
    protected Vector selectedNodes;
    protected Vector selectedEdges;
    protected float scale;
    public GraphCanvas canvas;
    public int nameInt;
    protected float lineWidth;
    protected float arrowWidth;
    protected float arrowHeight;

    public Graph(GraphCanvas canvas) {
        this.canvas = canvas;
        this.nodes = new Vector(10, 10);
        this.edges = new Vector(10, 10);
        this.selectedNodes = new Vector(10, 10);
        this.selectedEdges = new Vector(10, 10);
        this.nameInt = 0;
        this.scale = 1.0f;
        this.lineWidth = 1.0f;
        this.calculateArrowSize();
    }

    public void setLineWidth(int width) {
        this.lineWidth = width;
        this.calculateArrowSize();
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public float getArrowWidth() {
        return this.arrowWidth;
    }

    public float getArrowHeight() {
        return this.arrowHeight;
    }

    private void calculateArrowSize() {
        this.arrowWidth = this.lineWidth * 2.0f;
        if (this.arrowWidth < 6.0f) {
            this.arrowWidth = 6.0f;
        }
        if (this.arrowWidth > 15.0f) {
            this.arrowWidth = 15.0f;
        }
        this.arrowHeight = this.arrowWidth * 2.5f;
    }

    public void showMessage(String title, String msg) {
        this.canvas.showMessage(title, msg);
    }

    public boolean isInSolveMode() {
        return this.canvas.getMode() == 2221;
    }

    public Point[] getBound() {
        if (this.numNodes() == 0) {
            Point[] tmp = new Point[]{new Point(0.0f, 0.0f), new Point(0.0f, 0.0f)};
            return tmp;
        }
        Node n = this.nodeAt(0);
        float minx = n.pos.x - (float)(n.width / 2);
        float miny = n.pos.y - (float)(n.height / 2);
        float maxx = n.pos.x + (float)(n.width / 2);
        float maxy = n.pos.y + (float)(n.height / 2);
        int i = 1;
        while (i < this.numNodes()) {
            n = this.nodeAt(i);
            if (n.pos.x - (float)(n.width / 2) < minx) {
                minx = n.pos.x - (float)(n.width / 2);
            }
            if (n.pos.x + (float)(n.width / 2) > maxx) {
                maxx = n.pos.x + (float)(n.width / 2);
            }
            if (n.pos.y - (float)(n.height / 2) < miny) {
                miny = n.pos.y - (float)(n.height / 2);
            }
            if (n.pos.y + (float)(n.height / 2) > maxy) {
                maxy = n.pos.y + (float)(n.height / 2);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.numEdges()) {
            Edge e = this.edgeAt(i2);
            Point[] b = e.eLabel.getBounds();
            if (b != null) {
                if (b[0].x < minx) {
                    minx = b[0].x;
                }
                if (b[0].y < miny) {
                    miny = b[0].y;
                }
                if (b[1].x > maxx) {
                    maxx = b[1].x;
                }
                if (b[1].y > maxy) {
                    maxy = b[1].y;
                }
            }
            ++i2;
        }
        float pad = 5.0f;
        Point[] tmp = new Point[]{new Point(minx - pad, miny - pad), new Point(maxx + pad, maxy + pad)};
        return tmp;
    }

    public void updateNodeSize() {
        int i = 0;
        while (i < this.numNodes()) {
            this.nodeAt(i).updateSize();
            ++i;
        }
        i = 0;
        while (i < this.numEdges()) {
            this.edgeAt(i).updateLength();
            ++i;
        }
    }

    public void updateNodeSize(Node n) {
        n.updateSize();
        Vector[] e = n.getAllEdges();
        int i = 0;
        while (i < e[0].size()) {
            ((Edge)e[0].elementAt(i)).updateLength();
            ++i;
        }
        i = 0;
        while (i < e[1].size()) {
            ((Edge)e[1].elementAt(i)).updateLength();
            ++i;
        }
    }

    public void resetLabels() {
        int i = 0;
        while (i < this.numEdges()) {
            this.edgeAt((int)i).eLabel.reset();
            ++i;
        }
    }

    public void resetLabel(Edge e) {
        e.eLabel.reset();
    }

    public void repaint() {
        this.canvas.repaint();
    }

    public void draw(Graphics offscreen, boolean moving) {
        int i = this.numEdges() - 1;
        while (i >= 0) {
            this.edgeAt(i).draw(offscreen, moving);
            --i;
        }
        i = this.numEdges() - 1;
        while (i >= 0) {
            this.edgeAt((int)i).eLabel.draw(offscreen, moving);
            --i;
        }
        i = this.numNodes() - 1;
        while (i >= 0) {
            this.nodeAt(i).draw(offscreen, moving);
            --i;
        }
    }

    public void deleteSelected() {
        int i = 0;
        while (i < this.selectedEdges.size()) {
            Edge e = (Edge)this.selectedEdges.elementAt(i);
            e.removeFromNodes();
            this.edges.removeElement(e);
            ++i;
        }
        this.selectedEdges.removeAllElements();
        i = 0;
        while (i < this.selectedNodes.size()) {
            Edge e;
            Node n = (Node)this.selectedNodes.elementAt(i);
            Vector[] connected = n.getAllEdges();
            while (connected[0].size() > 0) {
                e = (Edge)connected[0].firstElement();
                e.removeFromNodes();
                this.edges.removeElement(e);
            }
            while (connected[1].size() > 0) {
                e = (Edge)connected[1].firstElement();
                e.removeFromNodes();
                this.edges.removeElement(e);
            }
            this.nodes.removeElement(n);
            ++i;
        }
        this.selectedNodes.removeAllElements();
    }

    public void addNode(Node newNode) {
        newNode.setIndex(this.getNextIndex());
        this.nodes.insertElementAt(newNode, newNode.index);
    }

    public void modifyNode(Node n, String l, Point p, Color c, int s) {
        n.set(l, p, c, s);
    }

    public Node nodeAt(int index) {
        return (Node)this.nodes.elementAt(index);
    }

    public int numNodes() {
        return this.nodes.size();
    }

    public void addEdge(String l, Node s, Node e, Color c, int t) {
        Edge newEdge = new Edge(this, l, s, e, c, t);
        this.edges.addElement(newEdge);
    }

    public void addEdge(Edge newEdge) {
        this.edges.addElement(newEdge);
    }

    public void modifyEdge(Edge edge, String l, Node s, Node e, Color c, int t) {
        edge.set(l, s, e, c, t);
    }

    public Edge edgeAt(int index) {
        return (Edge)this.edges.elementAt(index);
    }

    public int numEdges() {
        return this.edges.size();
    }

    public Entity searchEntities(Point p) {
        int i = 0;
        while (i < this.numNodes()) {
            if (this.nodeAt(i).contains(p)) {
                return this.nodeAt(i);
            }
            ++i;
        }
        i = 0;
        while (i < this.numEdges()) {
            if (this.edgeAt((int)i).eLabel.contains(p)) {
                return this.edgeAt((int)i).eLabel;
            }
            ++i;
        }
        i = 0;
        while (i < this.numEdges()) {
            if (this.edgeAt(i).contains(p)) {
                return this.edgeAt(i);
            }
            ++i;
        }
        return null;
    }

    public Vector searchEntities(Point a, Point b) {
        Vector<Entity> selected = new Vector<Entity>(10, 10);
        int i = 0;
        while (i < this.numNodes()) {
            if (this.nodeAt(i).isInRect(a, b)) {
                selected.addElement(this.nodeAt(i));
            }
            ++i;
        }
        i = 0;
        while (i < this.numEdges()) {
            if (this.edgeAt(i).isInRect(a, b)) {
                selected.addElement(this.edgeAt(i));
            }
            ++i;
        }
        return selected;
    }

    public boolean select(Entity ent) {
        if (ent.type == 7772) {
            this.deselectAll();
            return true;
        }
        if (!ent.isSelected) {
            if (ent.type == 7770) {
                this.selectedNodes.addElement(ent);
            } else if (ent.type == 7771) {
                this.selectedEdges.addElement(ent);
            }
            ent.isSelected = true;
        }
        return true;
    }

    public boolean deselect(Entity ent) {
        if (ent.type == 7772) {
            return false;
        }
        if (ent.isSelected) {
            if (ent.type == 7770) {
                this.selectedNodes.removeElement(ent);
            } else if (ent.type == 7771) {
                this.selectedEdges.removeElement(ent);
            }
            ent.isSelected = false;
        }
        return this.selectedNodes.size() > 0 || this.selectedEdges.size() > 0;
    }

    public boolean deselectAll() {
        int i = 0;
        while (i < this.selectedNodes.size()) {
            ((Entity)this.selectedNodes.elementAt((int)i)).isSelected = false;
            ++i;
        }
        this.selectedNodes.removeAllElements();
        i = 0;
        while (i < this.selectedEdges.size()) {
            ((Entity)this.selectedEdges.elementAt((int)i)).isSelected = false;
            ++i;
        }
        this.selectedEdges.removeAllElements();
        return false;
    }

    public boolean deselectAllButThis(Entity ent) {
        this.deselectAll();
        this.select(ent);
        return true;
    }

    public void translateEntities(float dx, float dy) {
        int i = 0;
        while (i < this.selectedNodes.size()) {
            ((Entity)this.selectedNodes.elementAt(i)).translate(dx, dy);
            ++i;
        }
    }

    public void translateAll(float dx, float dy) {
        int i = 0;
        while (i < this.nodes.size()) {
            this.nodeAt(i).translate(dx, dy);
            ++i;
        }
    }

    public void moveEntities(Point to, Node n) {
        Point from = new Point(n.pos);
        n.move(to);
        float dx = to.x - from.x;
        float dy = to.y - from.y;
        int i = 0;
        while (i < this.selectedNodes.size()) {
            Entity ent = (Entity)this.selectedNodes.elementAt(i);
            if (ent.type == 7770 && (Node)ent != n) {
                ent.translate(dx, dy);
            }
            ++i;
        }
    }

    public void moveLabel(Point to, EdgeLabel label) {
        label.move(to);
    }

    public void setScale(float newScale) {
        if (newScale == 0.0f) {
            this.scale = 1.0f;
            return;
        }
        if (newScale < 0.0f) {
            return;
        }
        int i = 0;
        while (i < this.numNodes()) {
            this.nodeAt((int)i).pos.scale(newScale / this.scale);
            ++i;
        }
        i = 0;
        while (i < this.numEdges()) {
            this.edgeAt(i).updateLength();
            ++i;
        }
        this.scale = newScale;
    }

    public float getScale() {
        return this.scale;
    }

    public void resetEdgeLabels() {
        int i = 0;
        while (i < this.numEdges()) {
            this.edgeAt((int)i).eLabel.reset();
            ++i;
        }
    }

    public Enumeration getEdges() {
        return this.edges.elements();
    }

    public Enumeration getNodes() {
        return this.nodes.elements();
    }

    public Edge getEdge(int i, int j) {
        int k = 0;
        while (k < this.numEdges()) {
            Edge e = this.edgeAt(k);
            if (e.start.index == i && e.end.index == j) {
                return e;
            }
            ++k;
        }
        return null;
    }

    protected boolean validNodeIndex(int index) {
        int i = 0;
        while (i < this.numNodes()) {
            if (this.nodeAt((int)i).index == index) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getLastIndex() {
        if (this.numNodes() == 0) {
            return -1;
        }
        return this.nodeAt((int)(this.numNodes() - 1)).index;
    }

    public int getNextIndex() {
        int index = 0;
        int i = 0;
        while (i < this.numNodes()) {
            if (index != this.nodeAt((int)i).index) {
                return index;
            }
            index = this.nodeAt((int)i).index + 1;
            ++i;
        }
        return index;
    }

    public Node nodeFromIndex(int index) {
        if (index < this.numNodes() && index == this.nodeAt((int)index).index) {
            return this.nodeAt(index);
        }
        int i = 0;
        while (i < this.numNodes()) {
            if (index == this.nodeAt((int)i).index) {
                return this.nodeAt(i);
            }
            ++i;
        }
        return null;
    }

    public boolean nodeNameNotAllowed(String name, Node node) {
        int i = 0;
        while (i < this.numNodes()) {
            if (this.nodeAt(i) != node && this.nodeAt((int)i).label[0].equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        if (this.numNodes() > 0) {
            return this.nodeAt(0).toString();
        }
        return "empty graph";
    }
}

