/*
 * Decompiled with CFR 0.152.
 */
package CIspace.graphToolKit;

import CIspace.graphToolKit.Edge;
import CIspace.graphToolKit.EdgeDialog;
import CIspace.graphToolKit.EdgeLabel;
import CIspace.graphToolKit.Entity;
import CIspace.graphToolKit.FontDialog;
import CIspace.graphToolKit.Graph;
import CIspace.graphToolKit.GraphConsts;
import CIspace.graphToolKit.MessageDialog;
import CIspace.graphToolKit.MessageFrame;
import CIspace.graphToolKit.Node;
import CIspace.graphToolKit.NodeDialog;
import CIspace.graphToolKit.Point;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.Scrollbar;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class GraphCanvas
extends Canvas
implements MouseListener,
MouseMotionListener,
ComponentListener,
KeyListener,
ActionListener {
    public Container parent;
    private Scrollbar hbar;
    private Scrollbar vbar;
    public Graph graph;
    public Graphics offscreen;
    protected Image image;
    public int WIDTH;
    public int HEIGHT;
    public Point origin;
    public Point offset;
    protected Font font;
    protected Point mClickedPos;
    protected Point mDraggedPos;
    protected Point mMovedPos;
    protected Point mPressedPos;
    protected Point mReleasedPos;
    protected boolean dragging;
    protected boolean moving;
    protected boolean clicked;
    protected boolean selected;
    protected Entity hover;
    protected Node from;
    protected Node to;
    protected int makingEdge;
    protected static final int NO = 0;
    protected static final int YES = 1;
    protected static final int DONE = 2;
    protected boolean makingNode;
    protected int submode;
    protected int mode;
    protected int rmode;
    protected NodeDialog nDialog;
    protected EdgeDialog eDialog;
    protected boolean zooming;
    protected boolean panning;
    protected float[] pzRect;
    public boolean pause;
    public boolean inline;
    public boolean moveable;
    protected PopupMenu pop;
    private MessageDialog md;
    private MessageFrame mf;
    protected int tmpMode;
    protected Entity entClicked;
    public boolean solveMode;
    public boolean ready = false;
    protected int blinkCount;

    public GraphCanvas(Container parent, boolean inline) {
        this.parent = parent;
        this.inline = inline;
        this.graph = new Graph(this);
        this.init();
    }

    public void init() {
        this.font = new Font("SansSerif", 0, 12);
        this.mode = 2220;
        this.submode = 3332;
        this.rmode = 4441;
        this.addMouseListener(this);
        this.addComponentListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.setBackground(Color.white);
        this.pzRect = new float[4];
        this.clearMouse();
        this.pause = false;
        this.moveable = true;
        this.pop = new PopupMenu();
        this.add(this.pop);
        this.tmpMode = -1;
        this.solveMode = false;
        this.blinkCount = 0;
    }

    protected void popupCanvas(int x, int y) {
        MenuItem mItem;
        this.pop.setLabel("Canvas Options");
        this.pop.removeAll();
        if (this.mode == 2220) {
            mItem = new MenuItem("Create Node");
            mItem.setActionCommand(mItem.getLabel());
            mItem.addActionListener(this);
            this.pop.add(mItem);
            this.pop.addSeparator();
        }
        mItem = new MenuItem("Autoscale");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new MenuItem("Reset Edge Labels");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.pop.show(this, x, y);
    }

    protected void popupNode(int x, int y) {
        if (this.mode == 2221) {
            this.popupCanvas(x, y);
            return;
        }
        this.pop.setLabel("Node Options");
        this.pop.removeAll();
        MenuItem mItem = new MenuItem("Create Edge");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new MenuItem("Properties");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new MenuItem("Delete");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.pop.addSeparator();
        mItem = new MenuItem("Autoscale");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.pop.show(this, x, y);
    }

    protected void popupEdge(int x, int y) {
        if (this.mode == 2221) {
            this.popupCanvas(x, y);
            return;
        }
        this.pop.setLabel("Edge Options");
        this.pop.removeAll();
        MenuItem mItem = new MenuItem("Properties");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new MenuItem("Reset Edge Label");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new MenuItem("Delete");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.pop.addSeparator();
        mItem = new MenuItem("Autoscale");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.pop.show(this, x, y);
    }

    public void setGraphics() {
        this.WIDTH = this.getSize().width;
        this.HEIGHT = this.getSize().height;
        this.origin = new Point(this.WIDTH / 2, this.HEIGHT / 2);
        this.image = this.createImage(this.WIDTH, this.HEIGHT);
        this.offscreen = this.image.getGraphics();
        this.offscreen.setFont(this.font);
        this.offscreen.translate(this.WIDTH / 2, this.HEIGHT / 2);
        this.offset = new Point(0.0f, 0.0f);
        this.ready = true;
        this.repaint();
    }

    public void setScrollbars(Scrollbar hbar, Scrollbar vbar) {
        this.hbar = hbar;
        this.vbar = vbar;
        this.centerView();
    }

    public void offset(int x0, int y0) {
        if (this.offscreen == null) {
            return;
        }
        this.offscreen.translate((int)(-this.offset.x), (int)(-this.offset.y));
        this.offset.move(x0, y0);
        this.offscreen.translate(x0, y0);
        this.repaint();
    }

    public void reset() {
        this.graph = new Graph(this);
        this.clearMouse();
        this.repaint();
    }

    public void showMessage(String title, String msg) {
        this.pause();
        if (this.inline) {
            if (this.mf == null) {
                this.mf = new MessageFrame(this.parent);
                this.mf.addActionListener(this);
            }
            this.mf.open(title, msg);
        } else {
            if (this.md == null) {
                this.md = new MessageDialog((Frame)this.parent);
                this.md.addActionListener(this);
            }
            this.md.open(title, msg);
        }
    }

    public void clearMouse() {
        this.dragging = false;
        this.moving = false;
        this.clicked = false;
        this.selected = false;
        this.panning = false;
        this.zooming = false;
        this.mClickedPos = new Point();
        this.mDraggedPos = new Point();
        this.mMovedPos = new Point();
        this.mPressedPos = new Point();
        this.mReleasedPos = new Point();
        this.makingEdge = 0;
        this.makingNode = false;
        this.from = null;
        this.to = null;
        this.pzRect[0] = 0.0f;
        this.pzRect[1] = 0.0f;
        this.pzRect[2] = 0.0f;
        this.pzRect[3] = 0.0f;
        this.entClicked = null;
    }

    public void setGraph(Graph graph) {
        this.clearMouse();
        this.graph = graph;
        this.autoscale();
    }

    public void setMoveable(boolean movable) {
        this.moveable = movable;
    }

    public void changeFont(int size) {
        if (size == -1) {
            FontDialog fd = new FontDialog(this);
        } else {
            this.font = new Font("SansSerif", 0, size);
        }
        this.offscreen.setFont(this.font);
        this.graph.updateNodeSize();
        this.repaint();
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.font);
    }

    public void updateGraph() {
        this.graph.updateNodeSize();
        this.repaint();
    }

    public void changeLineWidth() {
        this.graph.updateNodeSize();
        this.repaint();
    }

    public void resetLabels() {
        this.graph.resetLabels();
        this.repaint();
    }

    public int getMode() {
        return this.mode;
    }

    public void centerView() {
        this.hbar.setValue(50);
        this.vbar.setValue(50);
        this.offset(0, 0);
        this.offset = new Point(0.0f, 0.0f);
    }

    public float maximizingScale() {
        Point[] bounds = this.graph.getBound();
        Point min = bounds[0];
        Point max = bounds[1];
        if (min.equals(0.0f, 0.0f) || max.equals(0.0f, 0.0f)) {
            return 0.0f;
        }
        if (min.equals(max)) {
            return -1.0f;
        }
        float visibleWidth = this.WIDTH;
        float visibleHeight = this.HEIGHT;
        float graphWidth = max.x - min.x;
        float graphHeight = max.y - min.y;
        float widthRatio = visibleWidth / graphWidth;
        float heightRatio = visibleHeight / graphHeight;
        float ratio = Math.min(widthRatio, heightRatio);
        return ratio *= this.graph.getScale();
    }

    public void zoom(float scale) {
        int visibleX = 0;
        int visibleY = 0;
        int visibleWidth = this.WIDTH;
        int visibleHeight = this.HEIGHT;
        float dx = (float)(visibleX + visibleWidth / 2) - this.origin.x;
        float dy = (float)(visibleY + visibleHeight / 2) - this.origin.y;
        this.graph.translateAll(-dx, -dy);
        this.graph.setScale(scale);
        this.graph.translateAll(dx, dy);
        this.repaint();
    }

    public void moveToMiddle() {
        Point[] bounds = this.graph.getBound();
        Point min = bounds[0];
        Point max = bounds[1];
        float currScale = this.graph.getScale();
        if (min.equals(0.0f, 0.0f) || max.equals(0.0f, 0.0f)) {
            return;
        }
        float midX = (min.x + max.x) / 2.0f;
        float midY = (min.y + max.y) / 2.0f;
        this.graph.translateAll(-midX, -midY);
    }

    public void autoscale() {
        this.moveToMiddle();
        this.zoom(this.maximizingScale());
        this.centerView();
        this.moveToMiddle();
        this.zoom(this.maximizingScale());
        this.centerView();
        this.moveToMiddle();
        this.zoom(this.maximizingScale());
        this.centerView();
    }

    public synchronized void blink() {
        if (this.blinkCount == 0) {
            this.blinkCount = 4;
            this.repaint();
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.offscreen == null) {
            this.setGraphics();
            return;
        }
        this.offscreen.clearRect(-((int)this.offset.x) - this.WIDTH / 2, -((int)this.offset.y) - this.HEIGHT / 2, this.WIDTH, this.HEIGHT);
        if (this.blinkCount != 0) {
            if (this.blinkCount % 2 == 0) {
                this.offscreen.setColor(Color.yellow);
                this.offscreen.fillRect(-((int)this.offset.x) - this.WIDTH / 2, -((int)this.offset.y) - this.HEIGHT / 2, this.WIDTH, this.HEIGHT);
            }
            --this.blinkCount;
            this.repaint();
        }
        if (this.panning || this.zooming) {
            this.offscreen.setColor(Color.black);
            this.offscreen.drawRect((int)this.pzRect[0], (int)this.pzRect[1], (int)this.pzRect[2], (int)this.pzRect[3]);
        } else {
            this.graph.draw(this.offscreen, this.moving);
            if (this.dragging && !this.moving) {
                this.offscreen.setColor(Color.black);
                int x1 = (int)Math.min(this.mPressedPos.x, this.mDraggedPos.x);
                int y1 = (int)Math.min(this.mPressedPos.y, this.mDraggedPos.y);
                int w = (int)Math.abs(this.mPressedPos.x - this.mDraggedPos.x);
                int h = (int)Math.abs(this.mPressedPos.y - this.mDraggedPos.y);
                this.offscreen.drawRect(x1, y1, w, h);
            }
            if (this.makingEdge == 1 || this.makingEdge == 2) {
                this.offscreen.setColor(Color.black);
                this.offscreen.drawLine((int)this.from.pos.x, (int)this.from.pos.y, (int)this.mMovedPos.x, (int)this.mMovedPos.y);
            }
            if (this.makingNode) {
                this.offscreen.setColor(Color.black);
                this.offscreen.drawOval((int)this.mPressedPos.x - 30, (int)this.mPressedPos.y - 40, 60, 80);
            }
        }
        g.drawImage(this.image, 0, 0, this);
    }

    public void setSubmode(int newMode) {
        this.submode = newMode;
        this.clearMouse();
        this.graph.deselectAll();
        this.repaint();
    }

    public void setMode(int newMode) {
        this.mode = newMode;
        this.solveMode = this.mode == 2221;
        this.clearMouse();
        this.graph.deselectAll();
        this.repaint();
    }

    public void setRMode(int newMode) {
        this.rmode = newMode;
    }

    public void pause() {
        this.pause = true;
        this.parent.setCursor(GraphConsts.WAIT_CURSOR);
    }

    public void unpause() {
        this.pause = false;
        this.parent.setCursor(GraphConsts.DEFAULT_CURSOR);
    }

    public void disposeWindows() {
        if (this.nDialog != null) {
            this.nDialog.dispose();
        }
        if (this.eDialog != null) {
            this.eDialog.dispose();
        }
        if (this.md != null) {
            this.md.dispose();
        }
        if (this.mf != null) {
            this.mf.dispose();
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this.pause) {
            return;
        }
        this.mClicked(e);
    }

    public void mouseEntered(MouseEvent e) {
        if (this.pause) {
            return;
        }
        this.mEntered(e);
    }

    public void mouseExited(MouseEvent e) {
        if (this.pause) {
            return;
        }
        this.mExited(e);
    }

    public void mousePressed(MouseEvent e) {
        if (this.pause) {
            return;
        }
        this.mPressed(e);
    }

    public void mouseReleased(MouseEvent e) {
        if (this.pause) {
            return;
        }
        this.mReleased(e);
    }

    public void mouseDragged(MouseEvent e) {
        if (this.pause) {
            return;
        }
        this.mDragged(e);
    }

    public void mouseMoved(MouseEvent e) {
        if (this.pause) {
            return;
        }
        this.mMoved(e);
    }

    protected void createNode(Entity ent, Point p) {
        if (ent == null || ent != null && ent.type != 7770) {
            this.makingNode = true;
            this.repaint();
            this.pause();
            if (this.nDialog == null) {
                this.nDialog = new NodeDialog(this);
            }
            this.nDialog.open(p);
            this.unpause();
            this.makingNode = false;
        }
    }

    protected void createEdge(Entity ent, Point p) {
        if (this.makingEdge == 1) {
            if (ent == null || ent.type != 7770) {
                this.makingEdge = 0;
            } else if (ent.type == 7770) {
                this.pause();
                this.makingEdge = 2;
                this.to = (Node)ent;
                if (this.eDialog == null) {
                    this.eDialog = new EdgeDialog(this);
                }
                this.eDialog.open(this.from, this.to);
                this.unpause();
                this.makingEdge = 0;
            }
            if (this.tmpMode != -1) {
                this.submode = this.tmpMode;
            }
            this.tmpMode = -1;
        } else if (ent != null && ent.type == 7770) {
            this.from = (Node)ent;
            this.makingEdge = 1;
            this.mMovedPos.move(p);
        }
    }

    protected void setEntProperties(Entity ent) {
        if (ent != null) {
            this.pause();
            if (ent.type == 7770) {
                if (this.nDialog == null) {
                    this.nDialog = new NodeDialog(this);
                }
                this.nDialog.open((Node)ent);
                this.graph.updateNodeSize((Node)ent);
            } else if (ent.type == 7771) {
                if (this.eDialog == null) {
                    this.eDialog = new EdgeDialog(this);
                }
                this.eDialog.open((Edge)ent);
            } else if (ent.type == 7772) {
                ent = ((EdgeLabel)ent).parent;
                if (this.eDialog == null) {
                    this.eDialog = new EdgeDialog(this);
                }
                this.eDialog.open((Edge)ent);
            }
            this.unpause();
        }
    }

    protected void deleteEnt(Entity ent) {
        if (ent != null) {
            if (ent.type == 7772) {
                this.graph.select(((EdgeLabel)ent).parent);
            } else {
                this.graph.select(ent);
            }
            this.graph.deleteSelected();
            this.selected = false;
            this.clicked = false;
        }
    }

    protected void mPressedSelect(Entity ent, boolean ctrlDown) {
        if (ent != null) {
            this.clicked = ent.isSelected;
            this.selected = this.graph.select(ent);
            if (this.clicked && ent.type != 7771) {
                this.moving = true;
            }
        } else if (ctrlDown) {
            this.selected = this.graph.deselectAll();
        }
    }

    protected void mReleasedSelect(Entity ent, boolean ctrlDown) {
        if (this.dragging) {
            if (this.moving) {
                this.selected = this.graph.deselectAll();
            } else {
                float x1 = Math.min(this.mPressedPos.x, this.mReleasedPos.x);
                float y1 = Math.min(this.mPressedPos.y, this.mReleasedPos.y);
                float w = Math.abs(this.mPressedPos.x - this.mReleasedPos.x);
                float h = Math.abs(this.mPressedPos.y - this.mReleasedPos.y);
                Point a = new Point(x1, y1);
                Point b = new Point(x1 + w, y1 + h);
                Vector selectedEntities = this.graph.searchEntities(a, b);
                this.selected = this.graph.deselectAll();
                int i = 0;
                while (i < selectedEntities.size()) {
                    this.selected = this.graph.select((Entity)selectedEntities.elementAt(i));
                    ++i;
                }
            }
        } else if (ent != null) {
            if (ctrlDown) {
                if (this.clicked) {
                    this.selected = this.graph.deselect(ent);
                }
            } else {
                this.selected = this.clicked ? this.graph.deselect(ent) : this.graph.deselectAllButThis(ent);
            }
        }
    }

    protected void mDraggedSelect() {
        if (!this.dragging) {
            if (Math.abs(this.mPressedPos.x - this.mDraggedPos.x) > 5.0f || Math.abs(this.mPressedPos.y - this.mDraggedPos.y) > 5.0f) {
                this.dragging = true;
            }
            return;
        }
        if (this.hover != null && this.hover.type != 7771) {
            if (this.moving) {
                if (this.moveable) {
                    if (this.hover.type == 7770) {
                        this.graph.moveEntities(this.mDraggedPos, (Node)this.hover);
                    } else if (this.hover.type == 7772) {
                        this.graph.moveLabel(this.mDraggedPos, (EdgeLabel)this.hover);
                    }
                }
            } else if (this.selected) {
                this.moving = true;
                this.dragging = true;
            }
        }
    }

    protected Entity mClicked(MouseEvent e) {
        if (this.entClicked != null) {
            this.entClicked.isBold = false;
        }
        this.entClicked = null;
        Point p = new Point((float)e.getX() - this.origin.x - this.offset.x, (float)e.getY() - this.origin.y - this.offset.y);
        this.mClickedPos = new Point(p);
        this.entClicked = this.graph.searchEntities(p);
        if (e.getModifiers() == 4) {
            this.selected = this.graph.deselectAll();
            if (this.hover != null) {
                this.hover.isBold = false;
            }
            if (this.makingEdge == 1) {
                this.makingEdge = 0;
                this.submode = this.tmpMode;
                return this.entClicked;
            }
            if (this.entClicked == null) {
                this.popupCanvas(e.getX(), e.getY());
            } else {
                this.entClicked.isBold = true;
                this.clicked = true;
                this.selected = this.graph.select(this.entClicked);
                if (this.entClicked.type == 7770) {
                    this.popupNode(e.getX(), e.getY());
                } else if (this.entClicked.type == 7771) {
                    this.popupEdge(e.getX(), e.getY());
                } else if (this.entClicked.type == 7772) {
                    this.entClicked.isBold = false;
                    this.entClicked = ((EdgeLabel)this.entClicked).parent;
                    this.clicked = true;
                    this.selected = this.graph.deselectAll();
                    this.selected = this.graph.select(this.entClicked);
                    this.popupEdge(e.getX(), e.getY());
                }
            }
        }
        return this.entClicked;
    }

    protected Entity mPressed(MouseEvent e) {
        this.requestFocus();
        Point p = new Point((float)e.getX() - this.origin.x - this.offset.x, (float)e.getY() - this.origin.y - this.offset.y);
        Entity ent = this.graph.searchEntities(p);
        this.mPressedPos.move(p);
        this.mDraggedPos.move(p);
        if (e.getModifiers() == 4) {
            return ent;
        }
        if (ent == null && !e.isControlDown()) {
            this.graph.deselectAll();
        }
        if (this.mode == 2220) {
            if (this.submode == 3330) {
                this.createNode(ent, p);
            } else if (this.submode == 3331) {
                this.createEdge(ent, p);
            } else if (this.submode == 3332) {
                this.mPressedSelect(ent, e.isControlDown());
            } else if (this.submode == 3333) {
                if (ent != null) {
                    this.deleteEnt(ent);
                }
            } else if (this.submode == 3334 && ent != null) {
                this.setEntProperties(ent);
            }
        } else if (this.mode == 2221) {
            this.mPressedSelect(ent, e.isControlDown());
        }
        this.repaint();
        return ent;
    }

    protected void mReleased(MouseEvent e) {
        Point p = new Point((float)e.getX() - this.origin.x - this.offset.x, (float)e.getY() - this.origin.y - this.offset.y);
        Entity ent = this.graph.searchEntities(p);
        this.mReleasedPos.move(p);
        if (e.getModifiers() == 4) {
            if (this.moveable) {
                if (this.hover == null && this.dragging) {
                    float dx = p.x - this.mPressedPos.x;
                    float dy = p.y - this.mPressedPos.y;
                    if (this.rmode == 4440) {
                        this.graph.translateAll(dx, dy);
                    } else if (this.rmode == 4441) {
                        float scale = this.graph.getScale();
                        if ((double)(scale *= 1.0f - dy / 100.0f) < 0.1) {
                            scale = 0.1f;
                        }
                        this.zoom(scale);
                    }
                }
                this.panning = false;
                this.zooming = false;
            }
        } else if (this.mode == 2220) {
            if (this.submode != 3330 && this.submode != 3331 && this.submode == 3332) {
                this.mReleasedSelect(ent, e.isControlDown());
            }
        } else if (this.mode == 2221) {
            this.mReleasedSelect(ent, e.isControlDown());
        }
        this.dragging = false;
        this.moving = false;
        this.mDraggedPos.move(0.0f, 0.0f);
        this.mPressedPos.move(0.0f, 0.0f);
        this.repaint();
    }

    protected void mEntered(MouseEvent e) {
        this.repaint();
    }

    protected void mExited(MouseEvent e) {
        this.repaint();
    }

    protected void mDragged(MouseEvent e) {
        Point p = new Point((float)e.getX() - this.origin.x - this.offset.x, (float)e.getY() - this.origin.y - this.offset.y);
        this.mDraggedPos.move(p);
        if (e.getModifiers() == 4 && this.moveable) {
            if (!this.dragging) {
                if (Math.abs(this.mPressedPos.x - p.x) > 5.0f || Math.abs(this.mPressedPos.y - p.y) > 5.0f) {
                    this.dragging = true;
                }
                if (this.hover != null) {
                    this.dragging = false;
                }
                return;
            }
            Point[] bounds = this.graph.getBound();
            float dx = p.x - this.mPressedPos.x;
            float dy = p.y - this.mPressedPos.y;
            if (this.rmode == 4440) {
                this.panning = true;
                this.pzRect[0] = bounds[0].x + dx;
                this.pzRect[1] = bounds[0].y + dy;
                this.pzRect[2] = bounds[1].x - bounds[0].x;
                this.pzRect[3] = bounds[1].y - bounds[0].y;
            } else if (this.rmode == 4441) {
                this.zooming = true;
                Point center = new Point((float)(this.WIDTH / 2) - this.origin.x, (float)(this.HEIGHT / 2) - this.origin.y);
                float maxDistX = Math.abs(bounds[0].x - center.x) < Math.abs(bounds[1].x - center.x) ? Math.abs(bounds[1].x - center.x) : Math.abs(bounds[0].x - center.x);
                float maxDistY = Math.abs(bounds[0].y - center.y) < Math.abs(bounds[1].y - center.y) ? Math.abs(bounds[1].y - center.y) : Math.abs(bounds[0].y - center.y);
                this.pzRect[2] = 2.0f * maxDistX * (1.0f - dy / 100.0f);
                this.pzRect[3] = 2.0f * maxDistY * (1.0f - dy / 100.0f);
                this.pzRect[0] = center.x - Math.abs(maxDistX) + (2.0f * maxDistX - this.pzRect[2]) / 2.0f;
                this.pzRect[1] = center.y - Math.abs(maxDistY) + (2.0f * maxDistY - this.pzRect[3]) / 2.0f;
            }
        } else if (this.mode == 2220) {
            if (this.submode != 3330 && this.submode != 3331 && this.submode == 3332) {
                this.mDraggedSelect();
            }
        } else if (this.mode == 2221) {
            this.mDraggedSelect();
        }
        this.repaint();
    }

    protected void mMoved(MouseEvent e) {
        if (!this.ready) {
            return;
        }
        Point p = new Point((float)e.getX() - this.origin.x - this.offset.x, (float)e.getY() - this.origin.y - this.offset.y);
        Entity ent = this.graph.searchEntities(p);
        if (ent == null || ent != this.hover && this.hover != null) {
            if (this.hover != null) {
                this.hover.isBold = false;
                this.hover = null;
                this.repaint();
            }
        } else if (this.hover != ent) {
            this.hover = ent;
            this.hover.isBold = true;
            this.repaint();
        }
        if (this.submode != 3330 && this.submode == 3331 && this.makingEdge != 0) {
            if (this.makingEdge == 1) {
                this.mMovedPos.move(p);
            }
            this.repaint();
        }
    }

    public void keyPressed(KeyEvent e) {
        if (this.pause) {
            return;
        }
        this.kPressed(e);
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    protected void kPressed(KeyEvent e) {
        if (this.mode == 2221) {
            return;
        }
        int arg = e.getKeyCode();
        if (arg == 127) {
            this.graph.deleteSelected();
            this.repaint();
        }
        if (arg == 27) {
            this.makingEdge = 0;
            this.submode = this.tmpMode;
            this.repaint();
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.aPerformed(e);
    }

    protected void aPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (arg.equals("msgBoxClosed")) {
            this.unpause();
        } else if (this.pause) {
            return;
        }
        if (arg.equals("Create Node")) {
            this.createNode(this.entClicked, this.mClickedPos);
        } else if (arg.equals("Create Edge")) {
            this.createEdge(this.entClicked, this.mClickedPos);
            this.tmpMode = this.submode;
            this.submode = 3331;
        } else if (arg.equals("Properties")) {
            this.setEntProperties(this.entClicked);
        } else if (arg.equals("Delete")) {
            this.deleteEnt(this.entClicked);
        } else if (arg.equals("Autoscale")) {
            this.autoscale();
        } else if (arg.equals("Reset Edge Labels")) {
            this.resetLabels();
        } else if (arg.equals("Reset Edge Label")) {
            this.graph.resetLabel((Edge)this.entClicked);
            this.repaint();
        }
        this.graph.deselectAll();
    }

    public void componentResized(ComponentEvent e) {
        if (!this.ready) {
            return;
        }
        this.setGraphics();
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void print(String title) {
        PrintJob pj = Toolkit.getDefaultToolkit().getPrintJob((Frame)this.parent, title, null);
        if (pj == null) {
            System.out.println("The print request was cancelled");
            return;
        }
        Graphics g = pj.getGraphics();
        this.pause();
        g.drawImage(this.image, 0, 0, this);
        this.unpause();
        g.dispose();
        pj.end();
    }
}

