/*
 * Decompiled with CFR 0.152.
 */
package CIspace.graphToolKit;

import CIspace.graphToolKit.AboutBox;
import CIspace.graphToolKit.CanvasTab;
import CIspace.graphToolKit.Edge;
import CIspace.graphToolKit.Graph;
import CIspace.graphToolKit.GraphCanvas;
import CIspace.graphToolKit.GraphConsts;
import CIspace.graphToolKit.GrooveCanvas;
import CIspace.graphToolKit.GroovePanel;
import CIspace.graphToolKit.LabelCanvas;
import CIspace.graphToolKit.Node;
import CIspace.graphToolKit.Point;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class GraphWindow
extends Frame
implements WindowListener,
ItemListener,
ActionListener,
AdjustmentListener,
MouseListener {
    private Graph graph;
    private GraphCanvas canvas;
    private CanvasTab tabs;
    private CheckboxGroup createModeGroup;
    private Checkbox[] createModes;
    private CheckboxGroup rightModeGroup;
    private Checkbox[] rightModes;
    public CardLayout cardManager;
    private Panel cards;
    private Panel left;
    private Panel right;
    private Scrollbar hbar;
    private Scrollbar vbar;
    private CheckboxMenuItem largeFont;
    private CheckboxMenuItem mediumFont;
    private CheckboxMenuItem smallFont;
    private CheckboxMenuItem otherFont;
    private CheckboxMenuItem wideLine;
    private CheckboxMenuItem mediumLine;
    private CheckboxMenuItem narrowLine;
    private CheckboxMenuItem showCP;
    private CheckboxMenuItem showMP;
    private GridBagConstraints gbc;
    private GridBagLayout gbl;
    private LabelCanvas lCanvas;
    private Color bg;
    private Canvas resizeBar;
    private int currX;
    private Applet applet;

    public GraphWindow(Applet parent) {
        this.applet = parent;
        Color bg = GraphConsts.bg;
        ((Component)this).setBackground(bg);
        this.setForeground(GraphConsts.fg);
        this.setTitle("Graph Drawing Kit");
        ((Component)this).setSize(600, 600);
        this.addWindowListener(this);
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        this.tabs = new CanvasTab();
        this.tabs.addActionListener(this);
        this.tabs.addTab("Create");
        this.tabs.addTab("Solve");
        this.tabs.selectTab("Create");
        Panel card1 = new Panel();
        card1.setLayout(this.gbl);
        this.createModeGroup = new CheckboxGroup();
        this.createModes = new Checkbox[6];
        this.createModes[0] = new Checkbox("Create Node", this.createModeGroup, false);
        this.createModes[0].addItemListener(this);
        this.createModes[1] = new Checkbox("Create Edge", this.createModeGroup, false);
        this.createModes[1].addItemListener(this);
        this.createModes[2] = new Checkbox("Select Entity", this.createModeGroup, true);
        this.createModes[2].addItemListener(this);
        this.createModes[3] = new Checkbox("Move Entity", this.createModeGroup, false);
        this.createModes[3].addItemListener(this);
        this.createModes[4] = new Checkbox("Delete Entity", this.createModeGroup, false);
        this.createModes[4].addItemListener(this);
        this.createModes[5] = new Checkbox("Set Properties", this.createModeGroup, false);
        this.createModes[5].addItemListener(this);
        this.gbc.fill = 0;
        this.addComponent(this.createModes[0], card1, 0, 0, 1, 1, 1.0, 0.0);
        this.addComponent(this.createModes[1], card1, 1, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.createModes[2], card1, 2, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.createModes[3], card1, 3, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.createModes[4], card1, 4, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.createModes[5], card1, 5, 0, 1, 1, 0.0, 0.0);
        this.gbc.fill = 1;
        Panel card2 = new Panel();
        card2.setLayout(this.gbl);
        Label test = new Label("Hello World");
        card2.add(test);
        this.cards = new Panel();
        this.cards.setBackground(bg);
        this.cardManager = new CardLayout();
        this.cards.setLayout(this.cardManager);
        this.cards.add("create", card1);
        this.cards.add("solve", card2);
        Panel leftCenter = new Panel();
        leftCenter.setLayout(this.gbl);
        GrooveCanvas west = new GrooveCanvas(4441, bg);
        GrooveCanvas south = new GrooveCanvas(4442, bg);
        GrooveCanvas east = new GrooveCanvas(4443, bg);
        this.addComponent(west, leftCenter, 0, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.cards, leftCenter, 0, 1, 1, 1, 1.0, 1.0);
        this.addComponent(east, leftCenter, 0, 2, 1, 1, 0.0, 0.0);
        this.addComponent(south, leftCenter, 1, 0, 3, 1, 0.0, 0.0);
        Panel leftBottom = new Panel();
        leftBottom.setBackground(bg);
        leftBottom.setLayout(this.gbl);
        Button resetLabel = new Button("Reset Labels");
        resetLabel.addActionListener(this);
        Button autoscale = new Button("Autoscale");
        autoscale.addActionListener(this);
        this.rightModeGroup = new CheckboxGroup();
        this.rightModes = new Checkbox[2];
        this.rightModes[0] = new Checkbox("Pan", this.rightModeGroup, false);
        this.rightModes[1] = new Checkbox("Zoom", this.rightModeGroup, true);
        this.rightModes[0].addItemListener(this);
        this.rightModes[1].addItemListener(this);
        this.addComponent(resetLabel, leftBottom, 0, 0, 2, 1, 0.0, 0.0);
        this.addComponent(autoscale, leftBottom, 1, 0, 2, 1, 0.0, 0.0);
        this.addComponent(this.rightModes[0], leftBottom, 2, 0, 1, 1, 1.0, 0.0);
        this.addComponent(this.rightModes[1], leftBottom, 2, 1, 1, 1, 1.0, 0.0);
        GroovePanel groovy = new GroovePanel(((Component)this).getBackground(), leftBottom);
        this.left = new Panel();
        this.left.setLayout(this.gbl);
        this.addComponent(this.tabs, this.left, 0, 0, 1, 1, 1.0, 0.0);
        this.addComponent(leftCenter, this.left, 1, 0, 1, 1, 0.0, 1.0);
        this.addComponent(groovy, this.left, 2, 0, 1, 1, 0.0, 0.0);
        this.right = new Panel();
        this.lCanvas = new LabelCanvas();
        this.canvas = new GraphCanvas(this, false);
        this.right.setLayout(this.gbl);
        this.hbar = new Scrollbar(0, 0, 10, 0, 110);
        this.hbar.setBackground(bg);
        this.hbar.setBlockIncrement(10);
        this.hbar.setValue(50);
        this.hbar.addAdjustmentListener(this);
        this.vbar = new Scrollbar(1, 0, 10, 0, 110);
        this.vbar.setBackground(bg);
        this.vbar.setBlockIncrement(10);
        this.vbar.setValue(50);
        this.vbar.addAdjustmentListener(this);
        Panel gray = new Panel();
        gray.setBackground(bg);
        this.addComponent(this.canvas, this.right, 0, 0, 1, 1, 1.0, 1.0);
        this.addComponent(this.vbar, this.right, 0, 1, 1, 2, 0.0, 0.0);
        this.addComponent(this.lCanvas, this.right, 1, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.hbar, this.right, 2, 0, 1, 1, 0.0, 0.0);
        this.addComponent(gray, this.right, 2, 1, 1, 1, 0.0, 0.0);
        Panel main = new Panel();
        main.setBackground(bg.darker());
        main.setLayout(this.gbl);
        this.addComponent(this.left, main, 0, 0, 1, 1, 100.0, 1.0);
        this.resizeBar = new Canvas();
        this.resizeBar.setBackground(Color.lightGray);
        this.resizeBar.setCursor(new Cursor(11));
        this.resizeBar.addMouseListener(this);
        this.addComponent(this.resizeBar, main, 0, 1, 1, 1, 1.0, 1.0);
        this.addComponent(this.right, main, 0, 2, 1, 1, 300.0, 1.0);
        this.setLayout(new BorderLayout());
        this.add("Center", main);
        this.menu();
        this.resizeBar.setSize(1, this.left.getSize().height);
        this.show();
        this.canvas.setGraphics();
        this.canvas.setScrollbars(this.hbar, this.vbar);
    }

    private void addComponent(Component c, Container p, int row, int column, int width, int height, double wx, double wy) {
        this.gbc.gridx = column;
        this.gbc.gridy = row;
        this.gbc.gridwidth = width;
        this.gbc.gridheight = height;
        this.gbc.weightx = wx;
        this.gbc.weighty = wy;
        this.gbl.setConstraints(c, this.gbc);
        p.add(c);
    }

    private void menu() {
        MenuBar mBar = new MenuBar();
        Menu m = new Menu("File");
        MenuItem mItem = new MenuItem("Create New Graph");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        MenuShortcut shortcut = new MenuShortcut(78);
        mItem.setShortcut(shortcut);
        m.add(mItem);
        mItem = new MenuItem("Create Random Graph");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        shortcut = new MenuShortcut(82);
        mItem.setShortcut(shortcut);
        m.add(mItem);
        if (this.applet == null) {
            mItem = new MenuItem("Print");
            mItem.setActionCommand(mItem.getLabel());
            mItem.addActionListener(this);
            shortcut = new MenuShortcut(80);
            mItem.setShortcut(shortcut);
            m.add(mItem);
        }
        mItem = new MenuItem("Quit");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        shortcut = new MenuShortcut(81);
        mItem.setShortcut(shortcut);
        m.add(mItem);
        mBar.add(m);
        m = new Menu("Options");
        Menu font = new Menu("Font Size");
        this.largeFont = new CheckboxMenuItem("Large (20 pt)", false);
        this.largeFont.addItemListener(this);
        font.add(this.largeFont);
        this.mediumFont = new CheckboxMenuItem("Medium (12 pt)", true);
        this.mediumFont.addItemListener(this);
        font.add(this.mediumFont);
        this.smallFont = new CheckboxMenuItem("Small (9 pt)", false);
        this.smallFont.addItemListener(this);
        font.add(this.smallFont);
        this.otherFont = new CheckboxMenuItem("others...", false);
        this.otherFont.addItemListener(this);
        font.add(this.otherFont);
        m.add(font);
        Menu line = new Menu("Line Width");
        this.wideLine = new CheckboxMenuItem("Wide (4 pixels)", false);
        this.wideLine.addItemListener(this);
        line.add(this.wideLine);
        this.mediumLine = new CheckboxMenuItem("Medium (2 pixels)", false);
        this.mediumLine.addItemListener(this);
        line.add(this.mediumLine);
        this.narrowLine = new CheckboxMenuItem("Narrow (1 pixel)", true);
        this.narrowLine.addItemListener(this);
        line.add(this.narrowLine);
        m.add(line);
        m.addSeparator();
        this.showCP = new CheckboxMenuItem("Show Control Panel", true);
        this.showCP.addItemListener(this);
        m.add(this.showCP);
        this.showMP = new CheckboxMenuItem("Show Message Panel", true);
        this.showMP.addItemListener(this);
        m.add(this.showMP);
        mBar.add(m);
        m = new Menu("Help");
        mItem = new MenuItem("About CIspace");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        m.add(mItem);
        mBar.setHelpMenu(m);
        this.setMenuBar(mBar);
    }

    private void randomGraph(int numNodes) {
        String label;
        this.graph = new Graph(this.canvas);
        int i = 0;
        while (i < numNodes) {
            label = Integer.toString((int)(200.0 * Math.random()));
            int x = 150 - (int)(300.0 * Math.random());
            int y = 150 - (int)(300.0 * Math.random());
            int shape = 1110;
            Point p = new Point(x, y);
            Color color = Color.black;
            if (i % 4 == 0) {
                color = Color.red;
                shape = 1111;
            } else if (i % 4 == 1) {
                color = Color.blue;
                shape = 1112;
            } else if (i % 4 == 2) {
                color = Color.green;
                shape = 1110;
            }
            if (i == numNodes - 1) {
                p = new Point(0.0f, 0.0f);
            }
            Node n = new Node(this.graph, label, p, color, shape);
            this.graph.addNode(n);
            ++i;
        }
        i = 0;
        while (i < numNodes - 1) {
            label = "Edge #" + i;
            Node start = this.graph.nodeAt(i);
            Node end = this.graph.nodeAt(numNodes - 1);
            Color color = Color.black;
            if (i % 4 == 0) {
                color = Color.red;
            } else if (i % 4 == 1) {
                color = Color.blue;
            } else if (i % 4 == 2) {
                color = Color.green;
            }
            Edge e = new Edge(this.graph, label, start, end, color, 5551);
            this.graph.addEdge(e);
            ++i;
        }
    }

    private void loadPreset() {
        this.graph = new Graph(this.canvas);
        String label1 = Integer.toString((int)(200.0 * Math.random()));
        int shape1 = 1110;
        Point p1 = new Point(0.0f, 0.0f);
        Color color1 = Color.blue;
        Node n1 = new Node(this.graph, label1, p1, color1, shape1);
        this.graph.addNode(n1);
        String label2 = Integer.toString((int)(200.0 * Math.random()));
        Point p2 = new Point(100.0f, 100.0f);
        Color color2 = Color.blue;
        int shape2 = shape1;
        Node n2 = new Node(this.graph, label2, p2, color2, shape2);
        this.graph.addNode(n2);
        String label3 = "Edge #1";
        Node start = this.graph.nodeAt(1);
        Node end = this.graph.nodeAt(0);
        Color color3 = Color.red;
        Edge e = new Edge(this.graph, label3, start, end, color2, 5551);
        this.graph.addEdge(e);
    }

    public void newTab(String str) {
        if (str == "Create") {
            this.cardManager.show(this.cards, "create");
            this.canvas.setMode(2220);
        } else if (str == "Solve") {
            this.cardManager.show(this.cards, "solve");
            this.canvas.setMode(2221);
        }
    }

    public void setPromptLabel(String str) {
        this.lCanvas.setText(str);
    }

    public String getPromptLabel() {
        return this.lCanvas.getText();
    }

    public void blinkLabel() {
        this.lCanvas.blink();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        if (this.applet == null) {
            System.exit(0);
        }
    }

    public void windowClosing(WindowEvent e) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void itemStateChanged(ItemEvent e) {
        String arg = e.getItem().toString();
        if (arg.equals("Create Node")) {
            this.canvas.setSubmode(3330);
            this.setPromptLabel("Click the canvas to create a node.");
        } else if (arg.equals("Create Edge")) {
            this.canvas.setSubmode(3331);
            this.setPromptLabel("Click on a node to start creating an edge.  Click on another node to finish.\nYou can cancel edge creation by clicking on the canvas.");
        } else if (arg.equals("Select Entity")) {
            this.canvas.setSubmode(3332);
            this.setPromptLabel("Click on an entity to select or drag the mouse to select multiple entities.");
        } else if (arg.equals("Move Entity")) {
            this.canvas.setSubmode(3332);
            this.setPromptLabel("Click and drag an entity to move it around.");
        } else if (arg.equals("Delete Entity")) {
            this.canvas.setSubmode(3333);
            this.setPromptLabel("Click on an entity to delete.");
        } else if (arg.equals("Set Properties")) {
            this.canvas.setSubmode(3334);
            this.setPromptLabel("Click on an entity to set its properties.");
        } else if (arg.equals("Pan")) {
            this.canvas.setRMode(4440);
            this.setPromptLabel("Drag the right mouse button to pan the graph.");
        } else if (arg.equals("Zoom")) {
            this.canvas.setRMode(4441);
            this.setPromptLabel("Drag the right mouse button up to zoom in and down to zoom out.");
        } else if (arg.equals("Large (20 pt)")) {
            this.canvas.changeFont(20);
            this.largeFont.setState(true);
            this.mediumFont.setState(false);
            this.smallFont.setState(false);
            this.otherFont.setState(false);
        } else if (arg.equals("Medium (12 pt)")) {
            this.canvas.changeFont(12);
            this.largeFont.setState(false);
            this.mediumFont.setState(true);
            this.smallFont.setState(false);
            this.otherFont.setState(false);
        } else if (arg.equals("Small (9 pt)")) {
            this.canvas.changeFont(9);
            this.largeFont.setState(false);
            this.mediumFont.setState(false);
            this.smallFont.setState(true);
            this.otherFont.setState(false);
        } else if (arg.equals("others...")) {
            this.canvas.changeFont(-1);
            this.largeFont.setState(false);
            this.mediumFont.setState(false);
            this.smallFont.setState(false);
            this.otherFont.setState(true);
        } else if (arg.equals("Wide (4 pixels)")) {
            this.canvas.graph.setLineWidth(4);
            this.canvas.changeLineWidth();
            this.wideLine.setState(true);
            this.mediumLine.setState(false);
            this.narrowLine.setState(false);
        } else if (arg.equals("Medium (2 pixels)")) {
            this.canvas.graph.setLineWidth(2);
            this.canvas.changeLineWidth();
            this.wideLine.setState(false);
            this.mediumLine.setState(true);
            this.narrowLine.setState(false);
        } else if (arg.equals("Narrow (1 pixel)")) {
            this.canvas.graph.setLineWidth(1);
            this.canvas.changeLineWidth();
            this.wideLine.setState(false);
            this.mediumLine.setState(false);
            this.narrowLine.setState(true);
        } else if (arg.equals("Show Control Panel")) {
            this.left.setVisible(this.showCP.getState());
            this.validate();
        } else if (arg.equals("Show Message Panel")) {
            this.lCanvas.setVisible(this.showMP.getState());
            this.validate();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (arg.equals("canvasTab")) {
            this.newTab(this.tabs.getSelectedTab());
        } else if (arg.equals("Autoscale")) {
            this.canvas.autoscale();
        } else if (arg.equals("Reset Labels")) {
            this.canvas.resetLabels();
        } else if (arg.equals("Create New Graph")) {
            this.canvas.reset();
            this.tabs.selectTab("Create");
            this.tabs.repaint();
            this.newTab("Create");
        } else if (arg.equals("Create Random Graph")) {
            this.randomGraph(10);
            this.canvas.setGraph(this.graph);
            this.canvas.repaint();
        } else if (arg.equals("Print")) {
            this.canvas.print("No Title");
        } else if (arg.equals("Quit")) {
            ((Component)this).setVisible(false);
            this.dispose();
        } else if (arg.equals("About CIspace")) {
            this.setCursor(GraphConsts.WAIT_CURSOR);
            if (this.applet != null) {
                AboutBox about = new AboutBox((Frame)this, "http://www.cs.ubc.ca/labs/lci/CIspace/project/CIspace/graphToolKit/about.txt");
            } else {
                AboutBox aboutBox = new AboutBox((Frame)this, "CIspace/graphToolKit/about.txt");
            }
            this.setCursor(GraphConsts.DEFAULT_CURSOR);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.canvas.offset(-this.hbar.getValue(), -this.vbar.getValue());
    }

    private void centerWindow() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        Point centerPosition = new Point(screenSize.width / 2, screenSize.height / 2);
        Dimension windowSize = this.getSize();
        int widthOffset = windowSize.width / 2;
        int heightOffset = windowSize.height / 2;
        ((Component)this).setLocation((int)centerPosition.x - widthOffset, (int)centerPosition.y - heightOffset);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.currX = 0;
    }

    public void mouseReleased(MouseEvent e) {
        int rightPrev = this.right.getSize().width;
        this.left.setBounds(this.left.getBounds().x, this.left.getBounds().y, this.left.getSize().width + e.getX(), this.left.getSize().height);
        this.resizeBar.setBounds(this.left.getBounds().x + this.left.getSize().width, this.left.getBounds().y, 1, this.left.getSize().height);
        this.right.setBounds(this.resizeBar.getBounds().x + this.resizeBar.getSize().width, this.resizeBar.getBounds().y, rightPrev - e.getX(), this.right.getSize().height);
        this.left.validate();
        this.right.validate();
        System.out.println(e.getX());
    }

    public static void main(String[] args) {
        GraphWindow window = new GraphWindow(null);
    }
}

