/*
 * Decompiled with CFR 0.152.
 */
package CIspace.graphToolKit;

import CIspace.graphToolKit.AboutBox;
import CIspace.graphToolKit.GraphConsts;
import CIspace.graphToolKit.MessageDialog;
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;

public class HelpMenu
extends Menu
implements ActionListener {
    private static final String helpURL = "http://www.cs.ubc.ca/labs/lci/CIspace/";
    private static final String localHelp = "help";
    private static final String aboutCIspaceURL = "http://www.cs.ubc.ca/labs/lci/CIspace/project/CIspace/graphToolKit/about.txt";
    private static final String notAppletMessage = "To access help, please open a browser to the following URL: ";
    private String appletName;
    private Applet applet;
    private Frame parent;

    public HelpMenu(Applet applet, String name, Frame parent) {
        super("Help");
        this.applet = applet;
        this.appletName = name;
        this.parent = parent;
        MenuItem mi = new MenuItem("Help");
        this.add(mi);
        mi.addActionListener(this);
        this.addSeparator();
        mi = new MenuItem("About CIspace");
        this.add(mi);
        mi.addActionListener(this);
        mi = new MenuItem("About this applet");
        this.add(mi);
        mi.addActionListener(this);
    }

    public void openBrowserHelp(String helptype) {
        String urlString = helpURL + this.appletName + "/help/" + helptype;
        if (this.applet != null) {
            AppletContext ac = this.applet.getAppletContext();
            try {
                URL url = new URL(urlString);
                ac.showDocument(url, "_blank");
            }
            catch (Exception e) {
                System.err.println("Error URL malformed: " + urlString);
            }
        } else {
            MessageDialog md = new MessageDialog(this.parent);
            md.open("Help", notAppletMessage + urlString);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Help") {
            this.openBrowserHelp("index.html");
        } else if (e.getActionCommand() == "About CIspace") {
            this.parent.setCursor(GraphConsts.WAIT_CURSOR);
            if (this.applet != null) {
                new AboutBox(this.parent, "http://www.cs.ubc.ca/labs/lci/CIspace/graphToolKit/about.txt");
            } else {
                new AboutBox(this.parent, "CIspace/graphToolKit/about.txt");
            }
            this.parent.setCursor(GraphConsts.DEFAULT_CURSOR);
        } else if (e.getActionCommand() == "About this applet") {
            this.parent.setCursor(GraphConsts.WAIT_CURSOR);
            if (this.applet != null) {
                new AboutBox(this.parent, helpURL + this.appletName + "/help/about.txt");
            } else {
                new AboutBox(this.parent, "CIspace/" + this.appletName + "/help/about.txt");
            }
            this.parent.setCursor(GraphConsts.DEFAULT_CURSOR);
        }
    }
}

