/*
 * Decompiled with CFR 0.152.
 */
package CIspace.graphToolKit;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class LabelCanvas
extends Canvas {
    private Font font = new Font("SansSerif", 0, 12);
    private FontMetrics fm = this.getFontMetrics(this.font);
    private String text1;
    private String text2;
    private int blinkCount;
    private boolean blue = true;
    private boolean flash = true;

    public LabelCanvas() {
        this.setSize(100, this.fm.getHeight() * 2 + 5);
        this.setBackground(Color.white);
        this.text1 = "";
        this.text2 = "";
        this.blinkCount = 0;
    }

    public synchronized void setText(String text) {
        if (text.indexOf(10) != -1) {
            this.text1 = text.substring(0, text.indexOf(10));
            this.text2 = text.substring(text.indexOf(10) + 1);
        } else {
            this.text1 = text;
            this.text2 = "";
        }
        this.blue = !this.blue;
        this.repaint();
    }

    public String getText() {
        if (this.text2.equals("")) {
            return this.text1;
        }
        return String.valueOf(this.text1) + '\n' + this.text2;
    }

    public synchronized void blink() {
        if (this.blinkCount == 0) {
            this.blinkCount = 4;
            this.repaint();
        }
    }

    public void setFlash(boolean bool) {
        this.flash = bool;
    }

    public synchronized void paint(Graphics g) {
        boolean paintAgain;
        int width = this.getSize().width;
        int height = this.getSize().height;
        if (this.blinkCount == 0) {
            g.setColor(Color.white);
            paintAgain = false;
        } else {
            if (this.blinkCount % 2 == 0) {
                g.setColor(Color.yellow);
            } else {
                g.setColor(Color.white);
            }
            --this.blinkCount;
            paintAgain = true;
        }
        g.fillRect(0, 0, width, height);
        g.setColor(Color.black);
        int x = 0;
        while (x < width) {
            g.drawLine(x, 0, x + 5, 0);
            x += 10;
        }
        g.setFont(this.font);
        if (this.flash) {
            if (this.blue) {
                g.setColor(Color.blue);
            } else {
                g.setColor(new Color(255, 0, 255));
            }
        } else {
            g.setColor(Color.blue);
        }
        int w1 = this.fm.stringWidth(this.text1);
        int w2 = this.fm.stringWidth(this.text2);
        int a = this.fm.getAscent();
        if (this.text2.equals("")) {
            g.drawString(this.text1, width / 2 - w1 / 2, height / 2 + a / 2);
        } else {
            g.drawString(this.text1, width / 2 - w1 / 2, height / 4 + a / 2);
            g.drawString(this.text2, width / 2 - w2 / 2, height * 3 / 4 + a / 2);
        }
        if (paintAgain) {
            this.repaint();
        }
    }
}

