/*
 * Decompiled with CFR 0.152.
 */
package CIspace.search;

import CIspace.search.SearchEdge;
import CIspace.search.SearchGraph;
import CIspace.search.SearchNode;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class EdgePropDialog
extends Dialog
implements ActionListener,
TextListener,
WindowListener {
    private Label labelEdgeCost;
    private TextField textEdgeCost;
    private Button buttonOk;
    private Button buttonCancel;
    private Label labelError;
    private Panel p;
    private SearchEdge edge;
    private SearchGraph graph;
    private Double cost;
    private SearchNode selected;
    public boolean cancelled;

    public EdgePropDialog(Frame parent, SearchGraph g) {
        super(parent, "Edge Properties", true);
        this.graph = g;
        this.labelEdgeCost = new Label("Edge cost:");
        this.textEdgeCost = new TextField("", 20);
        this.textEdgeCost.addTextListener(this);
        this.buttonOk = new Button("OK");
        this.buttonOk.addActionListener(this);
        this.buttonCancel = new Button("Cancel");
        this.buttonCancel.addActionListener(this);
        this.labelError = new Label("");
        this.p = new Panel();
        this.p.setLayout(new GridLayout(2, 2));
        this.p.add(this.labelEdgeCost);
        this.p.add(this.textEdgeCost);
        this.p.add(this.buttonOk);
        this.p.add(this.buttonCancel);
        this.add(this.p);
        this.add("South", this.labelError);
        this.pack();
    }

    public void open(SearchEdge e) {
        this.cancelled = false;
        this.edge = e;
        this.cost = new Double(this.edge.getCost());
        this.textEdgeCost.setText(this.cost.toString());
        this.centerWindow();
        ((Component)this).setVisible(true);
    }

    private void centerWindow() {
        Container parent = this.getParent();
        int midX = parent.getLocationOnScreen().x + parent.getSize().width / 2;
        int midY = parent.getLocationOnScreen().y + parent.getSize().height / 2;
        ((Component)this).setLocation(midX - this.getSize().width / 2, midY - this.getSize().height / 2);
    }

    public boolean setProperties() {
        try {
            this.cost = Double.valueOf(this.textEdgeCost.getText());
            this.edge.updateProperties(this.cost);
            return true;
        }
        catch (NumberFormatException e) {
            this.labelError.setText("Error: Invalid real number format!");
            return false;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "OK") {
            if (this.setProperties()) {
                ((Component)this).setVisible(false);
            }
        } else if (e.getActionCommand() == "Cancel") {
            this.cancelled = true;
            ((Component)this).setVisible(false);
        }
    }

    public void textValueChanged(TextEvent e) {
        if (e.getSource().equals(this.textEdgeCost)) {
            this.labelError.setText("");
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.cancelled = true;
        ((Component)this).setVisible(false);
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

