/*
 * Decompiled with CFR 0.152.
 */
package CIspace.search;

import CIspace.search.Search;
import CIspace.search.SearchGraph;
import CIspace.search.SearchNode;
import CIspace.search.SearchObject;
import java.awt.Button;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

class FrontierInfoFrame
extends Frame
implements ActionListener,
WindowListener {
    protected Button ok_button;
    protected TextArea display;
    protected SearchGraph graph;
    protected Search search;

    public FrontierInfoFrame(SearchGraph g) {
        super("Current Frontier Information");
        this.addWindowListener(this);
        this.graph = g;
        this.search = g.getSearchObject();
        Panel p = new Panel();
        this.ok_button = new Button("OK");
        this.ok_button.addActionListener(this);
        p.add(this.ok_button);
        this.display = new TextArea(20, 80);
        this.display.setFont(new Font("Monospaced", 0, 12));
        this.display.setEditable(false);
        this.add("Center", this.display);
        this.add("South", p);
        this.pack();
        this.setFrontier();
        this.show();
    }

    public void setGraph(SearchGraph g) {
        this.graph = g;
        if (this.isVisible()) {
            this.showMe();
        }
    }

    public void showMe() {
        this.setFrontier();
        this.validate();
    }

    public void setFrontier() {
        this.search = this.graph.getSearchObject();
        this.display.setText("");
        if (this.search == null) {
            this.display.append("Search not in progress");
            return;
        }
        this.display.append("Frontier Information:\n");
        Vector frontier = this.search.getFrontier();
        Vector children = this.search.getNeighbours();
        if (frontier.size() == 0 && children.size() == 0) {
            this.display.append("\tNo node on frontier.");
        }
        int i = 0;
        while (i < frontier.size()) {
            SearchObject currObject = (SearchObject)frontier.elementAt(i);
            int toNode = currObject.getToNode();
            Vector path = currObject.getPath();
            double pathCost = currObject.getPathCost();
            SearchNode currNode = (SearchNode)this.graph.nodeFromIndex(toNode);
            this.display.append("   Name: " + currNode.getJustLabel() + "     Path: " + this.getPathString(path) + "\n     Cost (g(n)): " + pathCost + "     Heuristics (h(n)): " + currNode.getHeuristics() + "     f(n): " + (pathCost + currNode.getHeuristics()) + "\n");
            ++i;
        }
    }

    protected String getPathString(Vector path) {
        String nodeName;
        int nodeIndex;
        if (path.size() == 0) {
            return "n/a";
        }
        String pathString = new String("");
        int i = 0;
        while (i < path.size()) {
            nodeIndex = ((Integer[])path.elementAt(i))[0];
            if (nodeIndex != -1) {
                nodeName = ((SearchNode)this.graph.nodeFromIndex(nodeIndex)).getJustLabel();
                pathString = String.valueOf(pathString) + nodeName + " --> ";
            }
            ++i;
        }
        nodeIndex = ((Integer[])path.lastElement())[1];
        nodeName = ((SearchNode)this.graph.nodeFromIndex(nodeIndex)).getJustLabel();
        pathString = String.valueOf(pathString) + nodeName;
        return pathString;
    }

    public void showInitFrontier(SearchNode currNode) {
        this.display.append("   Name: " + currNode.getJustLabel() + "     Path: " + currNode.getJustLabel() + "\n     Cost (g(n)): 0" + "     Heuristics (h(n)): " + currNode.getHeuristics() + "     f(n): " + currNode.getHeuristics() + "\n");
    }

    public void clear() {
        this.display.setText("Frontier Information:\n");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("OK")) {
            ((Component)this).setVisible(false);
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        ((Component)this).setVisible(false);
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

