/*
 * Decompiled with CFR 0.152.
 */
package CIspace.search;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;

class HelpCanvas
extends Canvas {
    public HelpCanvas() {
        this.setBackground(Color.white);
    }

    public void paint(Graphics graphics) {
        int x = 70;
        int y = 30;
        int w = 60;
        int h = 30;
        graphics.setColor(Color.black);
        graphics.drawString("Shape and Colour Code for the Nodes and Edges", x, y);
        this.drawRegularNode(graphics, x, y += 30, w, h);
        graphics.setColor(Color.black);
        graphics.drawString("Regular Node (Rectangle)", x + 100, y);
        this.drawStartNode(graphics, x, y += 60, w, h);
        graphics.setColor(Color.black);
        graphics.drawString("Start Node (Oval)", x + 100, y);
        this.drawGoalNode(graphics, x, y += 60, w, h);
        graphics.setColor(Color.black);
        graphics.drawString("Goal Node (Diamond)", x + 100, y);
        this.drawFrontierNode(graphics, x, y += 80, w, h);
        graphics.setColor(Color.black);
        graphics.drawString("Node Currently on the Frontier (Green)", x + 100, y);
        this.drawChildrenNode(graphics, x, y += 80, w, h);
        graphics.setColor(Color.black);
        graphics.drawString("Child Node of the Current Node (Blue)", x + 100, y);
        this.drawCurrentNode(graphics, x, y += 90, w, h);
        graphics.setColor(Color.black);
        graphics.drawString("Current Node (Red)", x + 100, y);
        this.drawRegularEdge(graphics, x, y += 80, w, h);
        graphics.setColor(Color.black);
        graphics.drawString("Regular Edge", x + 100, y);
        this.drawPathEdge(graphics, x, y += 60, w, h);
        graphics.setColor(Color.black);
        graphics.drawString("Edge on the Path to the Current Node", x + 100, y);
    }

    public void drawRegularNode(Graphics graphics, int x, int y, int w1, int h1) {
        int w = w1;
        int h = h1;
        graphics.setColor(Color.black);
        graphics.drawRect(x - w / 2, y - h / 2, w, h);
        graphics.drawRect(x - w / 2 - 1, y - h / 2 - 1, w + 2, h + 2);
        graphics.drawRect(x - w / 2 - 2, y - h / 2 - 2, w + 4, h + 4);
    }

    public void drawStartNode(Graphics graphics, int x, int y, int w1, int h1) {
        int w = w1;
        int h = h1;
        h = (int)((double)h * 1.42);
        w = (int)((double)w * 1.42);
        graphics.drawOval(x - w / 2, y - h / 2, w, h);
        graphics.drawOval(x - w / 2 - 1, y - h / 2 - 1, w + 2, h + 2);
        graphics.drawOval(x - w / 2 - 2, y - h / 2 - 2, w + 4, h + 4);
    }

    public void drawGoalNode(Graphics graphics, int x, int y, int w1, int h1) {
        int w = w1;
        int h = h1;
        int[] xPoints = new int[]{(int)((double)x - (double)w / 1.2), x, (int)((double)x + (double)w / 1.2), x};
        int[] yPoints = new int[]{y, (int)((double)y + (double)h / 1.2), y, (int)((double)y - (double)h / 1.2)};
        graphics.drawPolygon(xPoints, yPoints, 4);
        int i = 0;
        while (i < 4) {
            xPoints[i] = xPoints[i] - 1;
            ++i;
        }
        graphics.drawPolygon(xPoints, yPoints, 4);
        i = 0;
        while (i < 4) {
            xPoints[i] = xPoints[i] + 2;
            ++i;
        }
        graphics.drawPolygon(xPoints, yPoints, 4);
        i = 0;
        while (i < 4) {
            xPoints[i] = xPoints[i] - 1;
            yPoints[i] = yPoints[i] - 1;
            ++i;
        }
        graphics.drawPolygon(xPoints, yPoints, 4);
        i = 0;
        while (i < 4) {
            yPoints[i] = yPoints[i] + 2;
            ++i;
        }
        graphics.drawPolygon(xPoints, yPoints, 4);
    }

    public void drawFrontierNode(Graphics graphics, int x, int y, int w1, int h1) {
        int w = w1;
        int h = h1;
        graphics.setColor(Color.green);
        graphics.drawRect(x - w / 2, y - h / 2, w, h);
        graphics.drawRect(x - w / 2 - 1, y - h / 2 - 1, w + 2, h + 2);
        graphics.drawRect(x - w / 2 - 2, y - h / 2 - 2, w + 4, h + 4);
        graphics.drawRect(x - w / 2 - 3, y - h / 2 - 3, w + 6, h + 6);
        graphics.drawRect(x - w / 2 - 4, y - h / 2 - 4, w + 8, h + 8);
    }

    public void drawChildrenNode(Graphics graphics, int x, int y, int w1, int h1) {
        int w = w1;
        int h = h1;
        graphics.setColor(Color.blue);
        graphics.drawRect(x - w / 2, y - h / 2, w, h);
        graphics.drawRect(x - w / 2 - 1, y - h / 2 - 1, w + 2, h + 2);
        graphics.drawRect(x - w / 2 - 2, y - h / 2 - 2, w + 4, h + 4);
        graphics.drawRect(x - w / 2 - 3, y - h / 2 - 3, w + 6, h + 6);
        graphics.drawRect(x - w / 2 - 4, y - h / 2 - 4, w + 8, h + 8);
    }

    public void drawCurrentNode(Graphics graphics, int x, int y, int w1, int h1) {
        int w = w1;
        int h = h1;
        graphics.setColor(Color.red);
        graphics.drawRect(x - w / 2, y - h / 2, w, h);
        graphics.drawRect(x - w / 2 - 1, y - h / 2 - 1, w + 2, h + 2);
        graphics.drawRect(x - w / 2 - 2, y - h / 2 - 2, w + 4, h + 4);
        graphics.drawRect(x - w / 2 - 3, y - h / 2 - 3, w + 6, h + 6);
        graphics.drawRect(x - w / 2 - 4, y - h / 2 - 4, w + 8, h + 8);
    }

    public void drawRegularEdge(Graphics graphics, int x, int y, int w1, int h1) {
        int w = w1;
        int h = h1;
        graphics.setColor(Color.black);
        graphics.drawLine(x -= w / 2, y, x + w, y);
        graphics.drawLine(x - 1, y, x + w - 1, y);
        graphics.drawLine(x + 1, y, x + w + 1, y);
        graphics.drawLine(x, y - 1, x + w, y - 1);
        graphics.drawLine(x, y + 1, x + w, y + 1);
        double x2 = x + w;
        double y2 = y;
        double dx = -w;
        double dy = 0.0;
        double length = w;
        double arrow_size = 10.0;
        double x3 = x2 + arrow_size / length * dx;
        double y3 = y2 + arrow_size / length * dy;
        double x4 = x3 + arrow_size * 0.7 / length * dy;
        double y4 = y3 - arrow_size * 0.7 / length * dx;
        int[] xPoints = new int[]{(int)x2, (int)(x3 -= arrow_size * 0.7 / length * dy), (int)x4};
        int[] yPoints = new int[]{(int)y2, (int)(y3 += arrow_size * 0.7 / length * dx), (int)y4};
        graphics.fillPolygon(xPoints, yPoints, 3);
    }

    public void drawPathEdge(Graphics graphics, int x, int y, int w1, int h1) {
        int w = w1;
        int h = h1;
        graphics.setColor(Color.red);
        graphics.drawLine(x -= w / 2, y, x + w, y);
        graphics.drawLine(x - 1, y, x + w - 1, y);
        graphics.drawLine(x + 1, y, x + w + 1, y);
        graphics.drawLine(x, y - 1, x + w, y - 1);
        graphics.drawLine(x, y + 1, x + w, y + 1);
        graphics.drawLine(x - 2, y, x + w - 2, y);
        graphics.drawLine(x + 2, y, x + w + 2, y);
        graphics.drawLine(x, y - 2, x + w, y - 2);
        graphics.drawLine(x, y + 2, x + w, y + 2);
        graphics.drawLine(x - 1, y + 1, x + w - 1, y + 1);
        graphics.drawLine(x - 1, y - 1, x + w - 1, y - 1);
        graphics.drawLine(x + 1, y + 1, x + w + 1, y + 1);
        graphics.drawLine(x + 1, y - 1, x + w + 1, y - 1);
        double x2 = x + w;
        double y2 = y;
        double dx = -w;
        double dy = 0.0;
        double length = w;
        double arrow_size = 10.0;
        double x3 = x2 + arrow_size / length * dx;
        double y3 = y2 + arrow_size / length * dy;
        double x4 = x3 + arrow_size * 0.7 / length * dy;
        double y4 = y3 - arrow_size * 0.7 / length * dx;
        int[] xPoints = new int[]{(int)x2, (int)(x3 -= arrow_size * 0.7 / length * dy), (int)x4};
        int[] yPoints = new int[]{(int)y2, (int)(y3 += arrow_size * 0.7 / length * dx), (int)y4};
        graphics.fillPolygon(xPoints, yPoints, 3);
    }
}

