/*
 * Decompiled with CFR 0.152.
 */
package CIspace.search;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class HelpTextDialog
extends Frame
implements ActionListener,
WindowListener {
    protected Button buttonOk;
    protected TextArea display;

    public HelpTextDialog() {
        super("Search Applet Help");
        this.addWindowListener(this);
        this.setLayout(new BorderLayout());
        MenuBar menubar = new MenuBar();
        Menu menu = new Menu("File");
        menu.add(new MenuItem("Exit"));
        menu.addActionListener(this);
        menubar.add(menu);
        this.display = new TextArea(40, 100);
        this.display.setFont(new Font("SansSerif", 0, 12));
        this.display.setEditable(false);
        this.setDisplay();
        this.add("North", this.display);
        Panel p = new Panel();
        this.buttonOk = new Button("OK");
        this.buttonOk.addActionListener(this);
        p.add(this.buttonOk);
        this.add("South", p);
        this.pack();
        this.validate();
        this.show();
    }

    public void setDisplay() {
        String s = new String("");
        s = String.valueOf(s) + "SEARCH APPLET BASICS: \n";
        s = String.valueOf(s) + "\n\tThe purpose of the search applet is to visually demonstrate some of the";
        s = String.valueOf(s) + "\n\tsearch algorithms introduced in CPSC 322.";
        s = String.valueOf(s) + "\n\n\tA search graph is costructed by creating nodes and creating edges (arcs)";
        s = String.valueOf(s) + "\n\tto connect the nodes.";
        s = String.valueOf(s) + "\n\n\tThere are 3 types of nodes:";
        s = String.valueOf(s) + "\n\t\t1. Start Nodes (oval).  These are the nodes from which the search starts.";
        s = String.valueOf(s) + "\n\t\t      There must be at least one start node in the graph before the ";
        s = String.valueOf(s) + "\n\t\t      search algorithms can be applied.";
        s = String.valueOf(s) + "\n\t\t2. Goal Nodes (diamond).  These are the nodes on the graph that the algorithms";
        s = String.valueOf(s) + "\n\t\t      look for as solutions.  Goal nodes are optional for this applet.";
        s = String.valueOf(s) + "\n\t\t3. Regular Nodes (rectangle).  These are normal nodes that are neither start nodes";
        s = String.valueOf(s) + "\n\t\t      nor goal nodes.";
        s = String.valueOf(s) + "\n\n\tThere are also 3 types of nodes when the algorithm is running:";
        s = String.valueOf(s) + "\n\t\t1. Current Node (red).  This is the node being visited now.";
        s = String.valueOf(s) + "\n\t\t2. Frontier Nodes (green).  These are the nodes currently on the frontier.";
        s = String.valueOf(s) + "\n\t\t3. Child Nodes (blue).  These nodes are the direct neighbours of the current node.";
        s = String.valueOf(s) + "\n\n\tPlease read the sections on Problem Acquisition Mode, Problem Solution Mode, and ";
        s = String.valueOf(s) + "\n\tMenu Entries for specific details and instruction.";
        s = String.valueOf(s) + "\n\n\nPROBLEM ACQUISITION MODE: \n";
        s = String.valueOf(s) + "\n\n\tIn the Problem Acquisition mode, the user creates and/or edits a search graph to solve.";
        s = String.valueOf(s) + "\n\tNote that the functionality described in this section are valid only in the Problem Acquisition Mode.";
        s = String.valueOf(s) + "\n\tTo go to the Problem Acquisition mode, click on the \"Problem Acquisition Mode\" button at the top of";
        s = String.valueOf(s) + "\n\tthe control panel.\"";
        s = String.valueOf(s) + "\n\nCreating a Node:";
        s = String.valueOf(s) + "\n\tTo create a node, select the \"Create Nodes\" Action checkbox and click on the graph canvas.";
        s = String.valueOf(s) + "\n\nSetting the Properties of a Node:";
        s = String.valueOf(s) + "\n\tEach node has predicateme and a heuristic value.  The heuristic values can be";
        s = String.valueOf(s) + "\n\tmanually entered (with \"Automatic Node Heuristics\" turned off in the ";
        s = String.valueOf(s) + "\n\t\"Search Option\" menu) or calculated using the distance between the node and ";
        s = String.valueOf(s) + "\n\tthe closest goal node (with \"Automatic Node Heuristics\" turned on).";
        s = String.valueOf(s) + "\n\tThe node'predicateme and heuristic value (if manual) can be modified by ";
        s = String.valueOf(s) + "\n\tselecting the action \"Select Nodes/Edges\" and then double-clicking on the node.";
        s = String.valueOf(s) + "\n\tIf the \"Ask for Node/Edge Properties at Create New Node/Edge\" checkbox is checked";
        s = String.valueOf(s) + "\n\tin the \"Option\" menu, then the Node Property dialog box will appear every time a new node is created.";
        s = String.valueOf(s) + "\n\nCreating an Edge:";
        s = String.valueOf(s) + "\n\tTo create an edge, select the \"Create Edges\" Action checkbox and click on a node (from node).";
        s = String.valueOf(s) + "\n\tA line will appear when the mouse moves on the canvas.  Click on the next node to complete the";
        s = String.valueOf(s) + "\n\tedge creation.  To cancel creating an edge half way, click on an empty space on the graph canvas.";
        s = String.valueOf(s) + "\n\nDeleting a Node or an Edge:";
        s = String.valueOf(s) + "\n\tTo delete a node or an edge, select the \"Delete Nodes/Edges\" Action checkbox and";
        s = String.valueOf(s) + "\n\tclick on the node or the edge to be deleted.";
        s = String.valueOf(s) + "\n\nSetting the Properties of an Edge:";
        s = String.valueOf(s) + "\n\tEach edge has a cost value.  It can be manually entered (with \"Automatic Edge Costs\"";
        s = String.valueOf(s) + "\n\tturned off in the \"Search Option\" menu) or calculated using the distance between the";
        s = String.valueOf(s) + "\n\ttwo nodes (with \"Automatic Edge Costs\" turned on).  With manual, the edge cost can be";
        s = String.valueOf(s) + "\n\tmodified by selecting the action \"Select Nodes/Edges\" and then double-clicking on the edge.";
        s = String.valueOf(s) + "\n\tIf the \"Ask for Node/Edge Properties at Create New Node/Edge\" checkbox is checked";
        s = String.valueOf(s) + "\n\tin the \"Option\" menu, then the Node Property dialog box will appear every time a new edge is created.";
        s = String.valueOf(s) + "\n\nSetting the Node Type for a Node:";
        s = String.valueOf(s) + "\n\tSelect one of \"Set Node as Start Node\", \"Set Node as Goal Node\", and \"Set Node as Regular Node\",";
        s = String.valueOf(s) + "\n\tas appropriate, and click on the node.  Note that a node is a regular node by default.";
        s = String.valueOf(s) + "\n\nCreating a New Graph:";
        s = String.valueOf(s) + "\n\tSelect \"Create New Graph\" in the \"File\" menu.";
        s = String.valueOf(s) + "\n\nLoading Graphs (from web browser):";
        s = String.valueOf(s) + "\n\tIf the applet is run from a web broswer, then a set of sample search problem is";
        s = String.valueOf(s) + "\n\tavailable for loading (Select the \"Load Graph (URL)\" item in the \"File\" menu).";
        s = String.valueOf(s) + "\n\nLoading Graphs (as Java application):";
        s = String.valueOf(s) + "\n\tIf the applet is run as an application, then the graphs must be loaded from a";
        s = String.valueOf(s) + "\n\tsaved file in the local disk (Select the \"Load Graph (Text)\" item in the \"File\" menu).";
        s = String.valueOf(s) + "\n\t(Note that \"Load Graph (Text)\" and \"Save Graph (Text)\" do not appear in the";
        s = String.valueOf(s) + "\n\t\"File\" menu if the applet is run from a web browser.)";
        s = String.valueOf(s) + "\n\nSaving Graphs (as Java application):";
        s = String.valueOf(s) + "\n\tIf the applet is run as an application, then the current graph can be saved to a";
        s = String.valueOf(s) + "\n\tfile in the local disk (Select the \"Save Graph (Text)\" item in the \"File\" menu).";
        s = String.valueOf(s) + "\n\t(Note that \"Load Graph (Text)\" and \"Save Graph (Text)\" do not appear in the";
        s = String.valueOf(s) + "\n\t\"File\" menu if the applet is run from a web browser.)";
        s = String.valueOf(s) + "\n\nLoading and Saving Graphs by Cut-and-Paste:";
        s = String.valueOf(s) + "\n\tRegardless of how the applet is run, the user can save the text representation of the current graph by";
        s = String.valueOf(s) + "\n\tcut-and-paste from the Text Representation Frame (the frame is displayed by selecting";
        s = String.valueOf(s) + "\n\tthe \"Show Text Representation of Graph\" item in the \"Edit\" menu).  The graph can also";
        s = String.valueOf(s) + "\n\tbe textually modified by editing the Text Representation Frame, or pasting a previously";
        s = String.valueOf(s) + "\n\tsaved text representation into the frame, and clicking the \"Update Graph\" button.";
        s = String.valueOf(s) + "\n\n\nPROBLEM SOLUTION MODE: \n";
        s = String.valueOf(s) + "\nSelecting a Search Algorithm:";
        s = String.valueOf(s) + "\n\tThe search algorithm to use in the problem solution mode can be selected in the";
        s = String.valueOf(s) + "\n\t\"Search Algorithms\" menu.  The algorithm selected is displayed in the control panel.";
        s = String.valueOf(s) + "\n\tNote that the selected algorithm cannot be changed after the search has been started.";
        s = String.valueOf(s) + "\n\tThe search must be reset before changing the search algorithm.";
        s = String.valueOf(s) + "\n\nRunning the Search:";
        s = String.valueOf(s) + "\n\tTo run a search algorithm on the graph created or loaded, go to Problem Solution Mode";
        s = String.valueOf(s) + "\n\t(if not already there) by clicking on the \"Problem Solution Mode\" button at the top of";
        s = String.valueOf(s) + "\n\tthe control panel.";
        s = String.valueOf(s) + "\n\n\tThere are 4 modes to run a search algorithm:";
        s = String.valueOf(s) + "\n\t1. Step.  Each time the \"Step\" button is clicked, the search advances to visit one";
        s = String.valueOf(s) + "\n\t\tnode, which is the current node (selected from the first node on the frontier).";
        s = String.valueOf(s) + "\n\t\tThe nodes on the frontier at the time and the neighbouring nodes of the current node";
        s = String.valueOf(s) + "\n\t\tare displayed on the graph.";
        s = String.valueOf(s) + "\n\t2. Fine Step.  One click on the \"Fine Step\" button selects the first node on the current";
        s = String.valueOf(s) + "\n\t\tfrontier to make it the current node.  A second click displays all the neighbours of the";
        s = String.valueOf(s) + "\n\t\tcurrent node.  A third click adds the neighbours to the frontier and displays the updated";
        s = String.valueOf(s) + "\n\t\tfrontier.  Note that 1 click on the \"Step\" button is equivalent to 3 clicks on \"Fine Step\".";
        s = String.valueOf(s) + "\n\t3. Show Result.  When the \"Show Result\" button is clicked, a dialog box comes up and asks";
        s = String.valueOf(s) + "\n\t\tfor the maximum number of steps to run the search algorithm (number of nodes being visited)";
        s = String.valueOf(s) + "\n\t\tand whether to stop searching when a goal node is found.  After the selections are made, it";
        s = String.valueOf(s) + "\n\t\truns using the search algorithm selected and displays on the graph the order of each node being visited.";
        s = String.valueOf(s) + "\n\t4. Quiz.  This mode quizzes the user on the search algorithm selected.  When the \"Quiz\" button";
        s = String.valueOf(s) + "\n\t\tis clicked, the initial frontier is displayed on the graph.  The user must click on the correct node";
        s = String.valueOf(s) + "\n\t\tthat would be selected by the search algorithm on the graph.  If the correct node is selected, the";
        s = String.valueOf(s) + "\n\t\tnode is displayed as the current node, and its neighbours are added to the frontier.  The process";
        s = String.valueOf(s) + "\n\t\tis repeated until there is no more node on the frontier or the \"Reset Search\" button is clicked.";
        s = String.valueOf(s) + "\n\nResetting the Search:";
        s = String.valueOf(s) + "\n\tTo stop a search algorithm, click on the \"Reset Search\" button in the control panel";
        s = String.valueOf(s) + "\n\nKeyboard Equivalents for Search Actions:";
        s = String.valueOf(s) + "\n\tIf the control panel is hidden (by selecting \"Hide Control Panel\" in the \"Option\" menu),";
        s = String.valueOf(s) + "\n\tthe keyboard can be used to perform the search actions.";
        s = String.valueOf(s) + "\n\t\t's' or 'S' for \"Step\"";
        s = String.valueOf(s) + "\n\t\t'f' or 'F' for \"Fine Step\"";
        s = String.valueOf(s) + "\n\t\t'r' or 'R' for \"Show Result\"";
        s = String.valueOf(s) + "\n\t\t'q' or 'Q' for \"Quiz\"";
        s = String.valueOf(s) + "\n\t\t'Esc' for \"Reset Search\"";
        s = String.valueOf(s) + "\n\nOther Search Functions:";
        s = String.valueOf(s) + "\n\tThe user can select a pruning option for running the search algorithm in the \"Pruning\" menu.";
        s = String.valueOf(s) + "\n\tOne of \"Multiple Path Pruning,\" \"Loop Detection,\" and \"None\" can be selected.";
        s = String.valueOf(s) + "\n\n\tThe node heuristics and edge costs can be displayed on the graph by checking the \"Display Node Heuristics\"";
        s = String.valueOf(s) + "\n\tand \"Display Edge Costs\" checkboxes in the \"Search Options\" menu.";
        s = String.valueOf(s) + "\n\n\tDetailed frontier information can be displayed by selecting the \"Show Frontier Information\"";
        s = String.valueOf(s) + "\n\titem in the \"Search Options\" menu.";
        s = String.valueOf(s) + "\n\n\tNote: The order of the edges (used in Depth First Search and Breadth First Search) are determined";
        s = String.valueOf(s) + "\n\tby the order in which the edges are created.  The graph display does not show explicitly the order";
        s = String.valueOf(s) + "\n\tof edge creation.  To see the edge orders, the user can view the text representation or the prolog";
        s = String.valueOf(s) + "\n\tcode generated (both in the \"Option\" menu).";
        s = String.valueOf(s) + "\n\n\nMENU ENTRIES AND OTHER FUNCTIONALITY: \n";
        s = String.valueOf(s) + "\nFile Menu:";
        s = String.valueOf(s) + "\n\tCreate New Graph.  Discard the current graph and start creating from an empty graph.";
        s = String.valueOf(s) + "\n\tLoad Graph (URL).  [Available only from a web browser] Load a problem from a set of sample problems.";
        s = String.valueOf(s) + "\n\tLoad Graph (Text).  [Available only if running as an application] Load a problem from the local disk.";
        s = String.valueOf(s) + "\n\tSave Graph (Text).  [Available only if running as an application] Save the graph to the local disk.";
        s = String.valueOf(s) + "\n\tExit.  Exit the Search Applet window.";
        s = String.valueOf(s) + "\n\nEdit Menu:";
        s = String.valueOf(s) + "\n\tDelete Selected Items.  Remove the selected nodes and edges from the graph.";
        s = String.valueOf(s) + "\n\tSelect All.  Select all the nodes and edges in the graph.";
        s = String.valueOf(s) + "\n\tGenerate Prolog Code from Graph.  Opens a frame containing the prolog code representation of the graph.";
        s = String.valueOf(s) + "\n\t\tThe Prolog code text cannot be edited, but it can be copied to a text editor and saved.";
        s = String.valueOf(s) + "\n\tView/Edit Text Representation of Graph.  Opens a modal frame containing the text representation of the graph.";
        s = String.valueOf(s) + "\n\t\tThe text can be edited.  The graph can be updated from the text representation frame by clicking the";
        s = String.valueOf(s) + "\n\t\t\"Update Graph\" button.  With this feature, a graph can be indirectly loaded from a locally saved text file";
        s = String.valueOf(s) + "\n\t\tby pasting the text representation of a graph to the text representation frame.";
        s = String.valueOf(s) + "\n\nOption Menu:";
        s = String.valueOf(s) + "\n\tSet Font.  Set the font used in the graph display.";
        s = String.valueOf(s) + "\n\tAsk for Node/Edge Properties at Create New Node/Edge.  If this option is selected, the property dialog box will";
        s = String.valueOf(s) + "\n\t\twill be opened immediately after a node or an edge is created.";
        s = String.valueOf(s) + "\n\tHide Path Display at Bottom (or Show Path Display at Bottom).  Hide or show the text area, located at the bottom";
        s = String.valueOf(s) + "\n\t\tof the search applet window, that displays the path of the current node when searching";
        s = String.valueOf(s) + "\n\tHide Messages (or Show Messages).  Hide or show the message prompts at the bottom of the control panel.";
        s = String.valueOf(s) + "\n\tHide Control Panel (or Show Control Panel).  Hide of show the control panel on the left of the graph canvas.";
        s = String.valueOf(s) + "\n\tGo to Problem Solution Mode (or Go to Problem Acquisition Mode).  Go to the mode as stated.  This menu item has the same";
        s = String.valueOf(s) + "\n\t\tfunctionality as the \"Problem Solution Mode\" button and the \"Problem Acquisition Mode\" button in the control panel.";
        s = String.valueOf(s) + "\n\nSearch Algorithms Menu:";
        s = String.valueOf(s) + "\n\tSelect one of the search algorithm to run.";
        s = String.valueOf(s) + "\n\nSearch Options Menu:";
        s = String.valueOf(s) + "\n\tAutomatic Node Heuristics.  If this option is on, then each node's heuristic is automatically assigned to be the";
        s = String.valueOf(s) + "\n\t\tdistance between the node and the nearest goal node.  If no goal node exists, the heuristics are set to 0.0.";
        s = String.valueOf(s) + "\n\t\tIf this option is off, then the heuristics are assigned manually.";
        s = String.valueOf(s) + "\n\tAutomatic Edge Costs.  If this option is on, then each edge's cost is automatically assigned to be the distance";
        s = String.valueOf(s) + "\n\t\tbetween the two nodes that the edge is on.l node.  If this option is off, then the edge costs are assigned manually.";
        s = String.valueOf(s) + "\n\tDisplay Node Heuristics.  If this option is on, then the node heuristics are displayed on the graph.";
        s = String.valueOf(s) + "\n\tDisplay Edge Costs.  If this option is on, then the edge costs are displayed on the graph.";
        s = String.valueOf(s) + "\n\t\tNote that the graph will respond much more slowly with the edge costs displayed.";
        s = String.valueOf(s) + "\n\tReset Costs and Heuristics.  Reset all edges and nodes on the graph to have cost 1.0 and heuristics 0.0, respectively.";
        s = String.valueOf(s) + "\n\t\tIt also turns off the options \"Automatic Node Heuristics\" and \"Automatic Edge Costs\"";
        s = String.valueOf(s) + "\n\tShow Frontier Information.  Display a screen that shows the information of the frontier nodes during search.";
        s = String.valueOf(s) + "\n\nPruning Menu:";
        s = String.valueOf(s) + "\n\tSelect one of the pruning option to use in search.";
        s = String.valueOf(s) + "\n\nHelp Menu:";
        s = String.valueOf(s) + "\n\tHelp.  Display this screen";
        s = String.valueOf(s) + "\n\tKey for Node/Edge Type.  Display a screen that explains what the shapes and colours of the nodes/edges mean.";
        s = String.valueOf(s) + "\n\nOther Functions:";
        s = String.valueOf(s) + "\n\tViewing Offset:  Drag and drop the white rectangle at the centre of the control panel to move the viewing offset";
        s = String.valueOf(s) + "\n\t\taround the graph canvas.";
        s = String.valueOf(s) + "\n\t\"Center\" button:  Move the viewing offset to the centre of the graph canvas.";
        s = String.valueOf(s) + "\n\t\"Scale\" buttons:  Increase/Decrease the size of the items in the graph canvas.";
        s = String.valueOf(s) + "\n\n";
        this.display.setText(s);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "OK" || e.getActionCommand() == "Exit") {
            this.dispose();
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

