/*
 * Decompiled with CFR 0.152.
 */
package CIspace.search;

import CIspace.graphToolKit.GraphConsts;
import CIspace.search.InlineCanvas;
import CIspace.search.PrologFrame;
import CIspace.search.Search;
import CIspace.search.SearchGraph;
import CIspace.search.ShowResultFrame;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;

public class InlineApplet
extends Applet {
    public InlineCanvas canvas;
    private boolean isApplet;
    private int searchAlgorithm;
    private boolean showNH;
    private boolean showEC;
    private boolean showNum;
    private ShowResultFrame srf;

    public void init() {
        this.isApplet = true;
        this.setBackground(GraphConsts.bg);
        this.setForeground(GraphConsts.fg);
        this.canvas = new InlineCanvas(this, true);
        this.setLayout(new BorderLayout());
        this.add("Center", this.canvas);
        this.canvas.setGraphics();
        this.showNH = false;
        this.showEC = false;
        this.showNum = false;
        this.loadParams();
    }

    private void loadParams() {
        String param = this.getParameter("algorithm");
        if (param != null) {
            this.itemStateChanged(param);
        }
        if ((param = this.getParameter("filename")) != null) {
            this.load(param);
        }
        if ((param = this.getParameter("pruning")) != null) {
            this.itemStateChanged(param);
        }
        if ((param = this.getParameter("showNH")) != null) {
            if (param.equals("true")) {
                this.actionPerformed("Show Node Heuristics");
            } else {
                this.actionPerformed("Hide Node Heuristics");
            }
        }
        if ((param = this.getParameter("showEC")) != null) {
            if (param.equals("true")) {
                this.actionPerformed("Show Edge Costs");
            } else {
                this.actionPerformed("Hide Edge Costs");
            }
        }
    }

    public int getAlgorithm() {
        return this.searchAlgorithm;
    }

    public void load(String filename) {
        if (this.canvas.frameOpened) {
            return;
        }
        try {
            String all = "";
            URL url = new URL(filename);
            InputStream iStream = url.openStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(iStream));
            String line = in.readLine();
            while (line != null) {
                all = String.valueOf(all) + line + "\n";
                line = in.readLine();
            }
            in.close();
            this.canvas.resetSearch();
            this.canvas.parse(all);
            this.canvas.greenify();
            if (this.searchAlgorithm == 209) {
                this.canvas.doSearch(209, 102);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void itemStateChanged(String arg) {
        if (this.canvas.pause) {
            return;
        }
        if (arg.equals("Depth First")) {
            this.canvas.searchMethod = this.searchAlgorithm = 201;
        } else if (arg.equals("Breadth First")) {
            this.canvas.searchMethod = this.searchAlgorithm = 202;
        } else if (arg.equals("Lowest Cost First")) {
            this.canvas.searchMethod = this.searchAlgorithm = 203;
        } else if (arg.equals("Best First")) {
            this.canvas.searchMethod = this.searchAlgorithm = 204;
        } else if (arg.equals("Heuristic Depth First")) {
            this.canvas.searchMethod = this.searchAlgorithm = 205;
        } else if (arg.equals("A*")) {
            this.canvas.searchMethod = this.searchAlgorithm = 206;
        } else if (arg.equals("User Defined")) {
            this.canvas.searchMethod = this.searchAlgorithm = 209;
        } else if (arg.equals("Pan")) {
            this.canvas.setRMode(4440);
        } else if (arg.equals("Zoom")) {
            this.canvas.setRMode(4441);
        } else if (arg.equals("Very Fast (0 s)")) {
            Search.dt = 0;
        } else if (arg.equals("Fast (0.1 s)")) {
            Search.dt = 100;
        } else if (arg.equals("Medium (0.5 s)")) {
            Search.dt = 500;
        } else if (arg.equals("Slow (1 s)")) {
            Search.dt = 1000;
        } else if (arg.equals("Automatic Node Heuristics")) {
            this.canvas.repaint();
        } else if (arg.equals("Automatic Edge Costs")) {
            ((SearchGraph)this.canvas.graph).updateNodeSize();
            this.canvas.repaint();
        } else if (arg.equals("Multiple-Path Pruning")) {
            ((SearchGraph)this.canvas.graph).setPruning(301);
        } else if (arg.equals("Loop Detection")) {
            ((SearchGraph)this.canvas.graph).setPruning(302);
        } else if (arg.equals("None")) {
            ((SearchGraph)this.canvas.graph).setPruning(303);
        } else if (arg.equals("Show Node Heuristics")) {
            this.showNH = !this.showNH;
            ((SearchGraph)this.canvas.graph).setDisplayHeuristics(this.showNH);
            this.canvas.updateGraph();
        } else if (arg.equals("Show Edge Costs")) {
            this.showEC = !this.showEC;
            ((SearchGraph)this.canvas.graph).setDisplayCost(this.showEC);
            this.canvas.repaint();
        } else if (arg.equals("Show Node Numbers")) {
            this.showNum = !this.showNum;
            ((SearchGraph)this.canvas.graph).setShowNum(this.showNum);
            this.canvas.repaint();
        }
    }

    public void actionPerformed(String arg) {
        if (this.canvas.pause) {
            return;
        }
        if (arg.equals("Step")) {
            this.canvas.doSearch(this.getAlgorithm(), 102);
        } else if (arg.equals("Fine Step")) {
            this.canvas.doSearch(this.getAlgorithm(), 103);
        } else if (arg.equals("Auto Search")) {
            this.canvas.doSearch(this.getAlgorithm(), 101);
        } else if (arg.equals("Stop Search")) {
            ((SearchGraph)this.canvas.graph).stopAutoSearch();
        } else if (arg.equals("Quiz")) {
            this.canvas.doSearch(this.getAlgorithm(), 104);
        } else if (arg.equals("Reset Search")) {
            this.canvas.resetSearch();
            this.canvas.greenify();
            if (this.searchAlgorithm == 209) {
                this.canvas.doSearch(209, 102);
            }
        } else if (arg.equals("Autoscale")) {
            this.canvas.autoscale();
        } else if (arg.equals("Reset Labels")) {
            this.canvas.resetLabels();
        } else if (arg.equals("Create New Graph")) {
            this.canvas.reset();
        } else if (!arg.equals("Load Sample Graph")) {
            if (arg.equals("View Prolog Code")) {
                PrologFrame pf = new PrologFrame((SearchGraph)this.canvas.graph);
            } else if (arg.equals("View/Edit Text Representation")) {
                this.canvas.textRep();
            } else if (arg.equals("Show Frontier Info")) {
                ((SearchGraph)this.canvas.graph).showFrontierInfoFrame();
            } else if (arg.equals("Reset Costs and Heuristics")) {
                this.canvas.resetCosts();
            }
        }
    }
}

