/*
 * Decompiled with CFR 0.152.
 */
package CIspace.search;

import CIspace.search.SearchGraph;
import CIspace.search.SearchNode;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class NodePropDialog
extends Dialog
implements ActionListener,
TextListener,
WindowListener {
    private Label labelNodeName;
    private TextField textNodeName;
    private Label labelHeuristics;
    private TextField textHeuristics;
    private Button buttonOk;
    private Button buttonCancel;
    private Label labelError;
    private Panel p;
    private int nodeIndex;
    private SearchGraph graph;
    private String nodeName;
    private Double heuristics;
    private SearchNode selected;
    public boolean cancelled;

    public NodePropDialog(Frame parent, SearchGraph g) {
        super(parent, "Node Properties", true);
        this.graph = g;
        this.labelNodeName = new Label("Node predicate:");
        this.textNodeName = new TextField("", 20);
        this.textNodeName.addActionListener(this);
        this.labelHeuristics = new Label("Node heuristics:");
        this.textHeuristics = new TextField("", 20);
        this.textHeuristics.addTextListener(this);
        this.buttonOk = new Button("OK");
        this.buttonOk.addActionListener(this);
        this.buttonCancel = new Button("Cancel");
        this.buttonCancel.addActionListener(this);
        this.labelError = new Label("");
        this.p = new Panel();
        this.p.setLayout(new GridLayout(3, 2));
        this.p.add(this.labelNodeName);
        this.p.add(this.textNodeName);
        this.p.add(this.labelHeuristics);
        this.p.add(this.textHeuristics);
        this.p.add(this.buttonOk);
        this.p.add(this.buttonCancel);
        this.add(this.p);
        this.add("South", this.labelError);
    }

    public void open(SearchNode node) {
        this.cancelled = false;
        this.selected = node;
        this.heuristics = new Double(this.selected.getHeuristics());
        this.nodeName = this.selected.getJustLabel();
        if (this.nodeName.equals("")) {
            this.nodeName = new String("Node " + (1 + this.graph.getNextIndex()));
        }
        this.textNodeName.setText(this.nodeName);
        this.textHeuristics.setText(this.heuristics.toString());
        this.pack();
        this.centerWindow();
        ((Component)this).setVisible(true);
    }

    private void centerWindow() {
        Container parent = this.getParent();
        int midX = parent.getLocationOnScreen().x + parent.getSize().width / 2;
        int midY = parent.getLocationOnScreen().y + parent.getSize().height / 2;
        ((Component)this).setLocation(midX - this.getSize().width / 2, midY - this.getSize().height / 2);
    }

    public boolean setProperties() {
        try {
            this.heuristics = Double.valueOf(this.textHeuristics.getText());
            this.selected.updateProperties(this.textNodeName.getText(), this.heuristics);
            return true;
        }
        catch (NumberFormatException e) {
            this.labelError.setText("Error: Heuristics has invalid real number format!");
            return false;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "OK") {
            if (this.setProperties()) {
                ((Component)this).setVisible(false);
            }
        } else if (e.getActionCommand() == "Cancel") {
            this.cancelled = true;
            ((Component)this).setVisible(false);
        } else if (e.getSource().equals(this.textNodeName)) {
            this.textNodeName.transferFocus();
        } else if (e.getSource().equals(this.textHeuristics)) {
            this.textHeuristics.transferFocus();
        }
    }

    public void textValueChanged(TextEvent e) {
        if (e.getSource().equals(this.textHeuristics)) {
            this.labelError.setText("");
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.cancelled = true;
        ((Component)this).setVisible(false);
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

