/*
 * Decompiled with CFR 0.152.
 */
package CIspace.search;

import CIspace.search.SearchEdge;
import CIspace.search.SearchGraph;
import CIspace.search.SearchNode;
import java.awt.Button;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Calendar;

public class PrologFrame
extends Frame
implements ActionListener,
WindowListener {
    protected Button ok_button;
    protected TextArea display;
    protected SearchGraph graph;

    public PrologFrame(SearchGraph g) {
        super("Prolog code for the graph");
        this.graph = g;
        this.addWindowListener(this);
        Panel p = new Panel();
        this.ok_button = new Button("OK");
        this.ok_button.addActionListener(this);
        p.add(this.ok_button);
        this.display = new TextArea(40, 100);
        this.display.setFont(new Font("Monospaced", 0, 12));
        this.display.setEditable(false);
        this.add("Center", this.display);
        this.add("South", p);
        this.pack();
        this.setProlog();
        this.show();
    }

    public void setProlog() {
        String tmpString1;
        SearchNode tmpNode;
        Calendar now = Calendar.getInstance();
        this.display.setText("% Auto-generated on " + now.getTime() + "\n \n");
        this.display.append("% is_start(N) is true if N is a start node.\n");
        int i = 0;
        while (i < this.graph.numNodes()) {
            tmpNode = (SearchNode)this.graph.nodeAt(i);
            tmpString1 = tmpNode.getJustLabel();
            tmpString1 = tmpString1.equals("") ? new String("'Node " + tmpNode.index + "'") : "'" + tmpString1 + "'";
            if (tmpNode.getNodeType() == 1) {
                this.display.append("is_start(" + tmpString1 + ").\n");
            }
            ++i;
        }
        this.display.append("\n% is_goal(N) is true if N is a goal node.\n");
        i = 0;
        while (i < this.graph.numNodes()) {
            tmpNode = (SearchNode)this.graph.nodeAt(i);
            tmpString1 = tmpNode.getJustLabel();
            tmpString1 = tmpString1.equals("") ? new String("'Node " + tmpNode.getIndex() + "'") : "'" + tmpString1 + "'";
            if (tmpNode.getNodeType() == 2) {
                this.display.append("is_goal(" + tmpString1 + ").\n");
            }
            ++i;
        }
        this.display.append("\n% neighbors(N1, [arc(N2, C2), arc(N3, C3), ...]) is true if there \n% is a directed edge from N1 to N2, N3, ... with cost C2, C3, ..., respectively.\n");
        i = 0;
        while (i < this.graph.numNodes()) {
            tmpNode = (SearchNode)this.graph.nodeAt(i);
            tmpString1 = tmpNode.getJustLabel();
            tmpString1 = tmpString1.equals("") ? new String("'Node" + tmpNode.getIndex() + "'") : "'" + tmpString1 + "'";
            int count = 0;
            int nextNeigh = tmpNode.getFirstNeighbour();
            this.display.append("neighbors(" + tmpString1 + ", [");
            while (nextNeigh != -1) {
                SearchNode node = (SearchNode)this.graph.nodeFromIndex(nextNeigh);
                SearchEdge edge = (SearchEdge)this.graph.getEdge(tmpNode.getIndex(), node.getIndex());
                String tmpString2 = node.getJustLabel();
                tmpString2 = tmpString2.equals("") ? new String("'Node " + node.getIndex() + "'") : "'" + tmpString2 + "'";
                if (count > 0) {
                    this.display.append(", ");
                }
                this.display.append("arc(" + tmpString2 + ", " + edge.getCost() + ")");
                nextNeigh = tmpNode.getNextNeighbour();
                ++count;
            }
            this.display.append("]).\n");
            ++i;
        }
        this.display.append("\n% heuristics(N, H) is true is node N has heuristics value H.\n");
        i = 0;
        while (i < this.graph.numNodes()) {
            tmpNode = (SearchNode)this.graph.nodeAt(i);
            tmpString1 = tmpNode.getJustLabel();
            tmpString1 = tmpString1.equals("") ? new String("'Node " + tmpNode.getIndex() + "'") : "'" + tmpString1 + "'";
            this.display.append("heuristics(" + tmpString1 + ", " + tmpNode.getHeuristics() + ").\n");
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("OK")) {
            ((Component)this).setVisible(false);
            this.dispose();
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

