/*
 * Decompiled with CFR 0.152.
 */
package CIspace.search;

import CIspace.search.AutoSearch;
import CIspace.search.FrontierInfoFrame;
import CIspace.search.SearchEdge;
import CIspace.search.SearchGraph;
import CIspace.search.SearchNode;
import CIspace.search.SearchObject;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Search {
    public static final int SEARCH_ROUGH = 101;
    public static final int SEARCH_STEP = 102;
    public static final int SEARCH_FINE = 103;
    public static final int SEARCH_TEST = 104;
    public static final int DEPTH_FIRST = 201;
    public static final int BREADTH_FIRST = 202;
    public static final int LOWEST_COST_FIRST = 203;
    public static final int BEST_FIRST = 204;
    public static final int HEURISTIC_DEPTH_FIRST = 205;
    public static final int A_STAR = 206;
    public static final int USER_DEFINED = 209;
    public static final int MULT_PATH_PRUNING = 301;
    public static final int LOOP_DETECTION = 302;
    public static final int NO_PRUNING = 303;
    protected SearchGraph graph;
    protected Vector frontier;
    protected Vector shorterFrontier;
    protected Vector neighbours;
    protected Vector startNodeIndex;
    protected Vector goalNodeIndex;
    protected int searchRate;
    protected SearchObject currObject;
    protected SearchObject previousObject;
    protected int current;
    protected int nodeCount;
    protected boolean resultsShown;
    protected boolean quizzed;
    protected boolean answerCorrect;
    protected String pathString;
    protected int pruning;
    protected Vector nodesVisited;
    protected int previousIndex;
    protected boolean testDone;
    protected SearchNode selectedNode;
    protected boolean goalReached;
    protected AutoSearch auto;
    public static int dt = 100;
    protected Vector backup;

    public Search() {
        this.graph = null;
        this.frontier = new Vector(5, 2);
        this.shorterFrontier = new Vector(5, 2);
        this.neighbours = new Vector(5, 2);
        this.startNodeIndex = new Vector(5, 2);
        this.goalNodeIndex = new Vector(5, 2);
        this.currObject = null;
        this.current = 0;
        this.resultsShown = false;
        this.quizzed = false;
        this.answerCorrect = false;
        this.previousObject = null;
        this.nodeCount = 1;
        this.pathString = new String("");
        this.nodesVisited = new Vector(5, 2);
        this.previousIndex = -1;
        this.testDone = false;
        this.goalReached = false;
    }

    public Search(SearchGraph sg) {
        this.graph = sg;
        this.frontier = new Vector(5, 2);
        this.shorterFrontier = new Vector(5, 2);
        this.neighbours = new Vector(5, 2);
        this.currObject = null;
        this.startNodeIndex = (Vector)sg.getStartNodeIndex().clone();
        this.goalNodeIndex = (Vector)sg.getGoalNodeIndex().clone();
        this.searchRate = sg.getSearchRate();
        this.pruning = sg.getPruning();
        this.current = 0;
        this.resultsShown = false;
        this.quizzed = false;
        this.answerCorrect = false;
        this.previousObject = null;
        this.nodeCount = 1;
        this.pathString = new String("");
        this.nodesVisited = new Vector(5, 2);
        this.previousIndex = -1;
        this.testDone = false;
        this.goalReached = false;
        this.stepInit();
        this.step();
    }

    public void setSelectedNode(SearchNode node) {
        this.selectedNode = node;
    }

    public void repaint() {
        this.graph.repaint();
    }

    protected void stepInit() {
        if (this.startNodeIndex.size() > 0) {
            String tmpLabel;
            int currIndex = (Integer)this.startNodeIndex.firstElement();
            SearchNode currNode = (SearchNode)this.graph.nodeFromIndex(currIndex);
            currNode.setSearchOrder(1);
            currNode.setDrawOrdering(true);
            currNode.setPathFound(true);
            this.nodesVisited.addElement(new Integer(currIndex));
            if (this.searchRate == 102 || this.searchRate == 103) {
                currNode.setNodeAppearance(3);
            } else if (this.searchRate == 104) {
                currNode.setNodeAppearance(4);
            }
            if (this.startNodeIndex.size() > 1) {
                Vector<SearchObject> startNodes = new Vector<SearchObject>(5, 2);
                int i = 1;
                while (i < this.startNodeIndex.size()) {
                    int nextStart = (Integer)this.startNodeIndex.elementAt(i);
                    this.shorterFrontier.addElement(new Integer(nextStart));
                    SearchNode tmpNode = (SearchNode)this.graph.nodeFromIndex(nextStart);
                    boolean condition = false;
                    if (this.pruning == 303) {
                        condition = true;
                    } else if (this.pruning == 301) {
                        condition = true;
                    } else if (!(this.pruning != 302 || this.currObject != null && this.currObject.checkNodeOnPath(nextStart))) {
                        condition = true;
                    }
                    if (condition) {
                        startNodes.addElement(new SearchObject(-1, nextStart, null, this.graph));
                    }
                    ++i;
                }
                this.mergeWithFrontier(startNodes);
            }
            this.paintNodes(this.frontier, 4);
            Vector children = (Vector)((SearchNode)this.graph.nodeFromIndex(currIndex)).getNeighbours().clone();
            int numNeigh = children.size();
            int i = 0;
            while (i < numNeigh) {
                int nextNeigh = (Integer)children.firstElement();
                SearchNode tmpNode = (SearchNode)this.graph.nodeFromIndex(nextNeigh);
                boolean condition = false;
                if (this.pruning == 303) {
                    condition = true;
                } else if (this.pruning == 301) {
                    condition = true;
                } else if (!(this.pruning != 302 || this.currObject != null && this.currObject.checkNodeOnPath(nextNeigh))) {
                    condition = true;
                }
                if (condition) {
                    this.neighbours.addElement(new SearchObject(currNode.getIndex(), nextNeigh, null, this.graph));
                }
                children.removeElementAt(0);
                ++i;
            }
            if (this.searchRate == 104) {
                this.graph.setPromptLabel(" Click on the first node on the frontier");
            }
            if ((tmpLabel = currNode.getJustLabel()).equals("")) {
                tmpLabel = new String("Node " + currNode.getIndex());
            }
            this.graph.setPathArea(tmpLabel);
        }
    }

    public void step() {
        switch (this.searchRate) {
            case 102: {
                this.doSearchStep();
                break;
            }
            case 103: {
                this.doSearchFine();
                break;
            }
            case 101: {
                this.startAutoSearch();
                break;
            }
            case 104: {
                this.doSearchTest();
                break;
            }
            default: {
                System.out.println("Error in Search " + this.searchRate);
            }
        }
    }

    public void showPath(SearchObject currObj) {
        if (currObj != null) {
            String tmpLabel;
            SearchNode tmpNode;
            Vector path = currObj.getPath();
            this.pathString = "";
            int i = 0;
            while (i < path.size()) {
                if (((Integer[])path.elementAt(i))[0] != -1) {
                    tmpNode = (SearchNode)this.graph.nodeFromIndex(((Integer[])path.elementAt(i))[0]);
                    tmpLabel = tmpNode.getJustLabel();
                    if (tmpLabel.equals("")) {
                        tmpLabel = new String("Node " + tmpNode.index);
                    }
                    this.pathString = String.valueOf(this.pathString) + tmpLabel + " --> ";
                }
                ++i;
            }
            tmpNode = (SearchNode)this.graph.nodeFromIndex(((Integer[])path.lastElement())[1]);
            tmpLabel = tmpNode.getJustLabel();
            if (tmpLabel.equals("")) {
                tmpLabel = new String("Node " + tmpNode.getIndex());
            }
            if (this.goalNodeIndex.contains(new Integer(tmpNode.index))) {
                tmpLabel = String.valueOf(tmpLabel) + " (Goal)";
            }
            this.pathString = String.valueOf(this.pathString) + tmpLabel;
            this.graph.setPathArea(this.pathString);
        }
    }

    protected void doSearchStep() {
        if (this.previousObject != null) {
            this.currObject = (SearchObject)this.previousObject.clone();
        }
        this.doSearchFine();
        while (this.current != 1) {
            this.doSearchFine();
        }
    }

    protected void doSearchFine() {
        switch (this.current) {
            case 0: {
                if (this.neighbours.size() > 0) {
                    this.paintNodes(this.neighbours, 5);
                }
                this.current = 1;
                this.backup = (Vector)this.frontier.clone();
                this.mergeWithFrontier(this.neighbours);
                break;
            }
            case 1: {
                this.resetPrevious(this.currObject);
                this.resetEdges();
                this.stepOne();
                this.current = 2;
                break;
            }
            case 2: {
                this.stepTwo();
                this.current = 3;
                break;
            }
            case 3: {
                this.stepThree();
                this.current = 1;
                break;
            }
            default: {
                System.out.println("error");
            }
        }
    }

    public void resetAutoSearch() {
        this.stopAutoSearch();
        this.auto = null;
    }

    public void startAutoSearch() {
        this.auto = new AutoSearch(this, dt);
        this.auto.start();
    }

    public void stopAutoSearch() {
        if (this.auto == null) {
            return;
        }
        if (this.auto.isAlive()) {
            this.auto.quit();
        }
    }

    public void pauseAuto(boolean pause) {
        if (this.auto == null) {
            return;
        }
        this.auto.pause = pause;
    }

    public boolean autoSearchContinue(int count) {
        if (count == 0) {
            return true;
        }
        if (this.frontier.size() <= 0 && this.currObject == null) {
            this.graph.showMessage("Search Done", "No more paths to search");
            return false;
        }
        if (count >= this.graph.getMaxNumSteps()) {
            this.graph.showMessage("Search Incomplete", "Auto Search incomplete after " + this.graph.getMaxNumSteps() + " steps.");
            return false;
        }
        return !this.graph.getStopAtGoal() || !this.goalReached;
    }

    public void autoSearchStep() {
        if (this.previousObject != null) {
            this.currObject = (SearchObject)this.previousObject.clone();
        }
        this.doSearchFine();
        while (this.current != 3) {
            this.doSearchFine();
        }
        FrontierInfoFrame frontierInfoFrame = this.graph.getFrontierInfoFrame();
        if (frontierInfoFrame != null && frontierInfoFrame.isVisible()) {
            frontierInfoFrame.showMe();
        }
    }

    public void autoSearchEnd() {
        if (this.goalReached) {
            this.goalReached = false;
        }
        this.stopAutoSearch();
        this.graph.disableStopButton();
    }

    protected void doSearchTest() {
        if (this.testDone) {
            return;
        }
        if (this.frontier.size() == 0 && this.currObject != null && this.answerCorrect) {
            this.testDone = true;
            this.resetPrevious(this.currObject);
            this.resetEdges();
            this.graph.setPromptLabel(" Search completed.  Click the Reset Search button to reset the graph.");
            return;
        }
        this.quizzed = true;
        this.current = 2;
        Vector oldFrontier = (Vector)this.frontier.clone();
        Vector oldNeighbours = (Vector)this.neighbours.clone();
        SearchObject oldCurrObject = null;
        if (this.currObject != null) {
            oldCurrObject = (SearchObject)this.currObject.clone();
        }
        if (this.selectedNode != null) {
            int testIndex = this.selectedNode.getIndex();
            if (this.answerCorrect) {
                if (this.currObject != null) {
                    this.previousObject = (SearchObject)this.currObject.clone();
                }
                this.stepTwo();
                oldFrontier = (Vector)this.frontier.clone();
                oldNeighbours = (Vector)this.neighbours.clone();
                oldCurrObject = null;
                if (this.currObject != null) {
                    oldCurrObject = (SearchObject)this.currObject.clone();
                }
            }
            if (this.currObject == null) {
                if (testIndex == (Integer)this.startNodeIndex.firstElement()) {
                    this.graph.setPromptLabel(" Click on the next node on the frontier");
                    SearchNode node = (SearchNode)this.graph.nodeFromIndex(testIndex);
                    node.setNodeAppearance(3);
                    if (!this.resultsShown) {
                        node.setSearchOrder(this.nodeCount);
                        node.setDrawOrdering(true);
                    }
                    ++this.nodeCount;
                    this.answerCorrect = true;
                    this.stepOne();
                    this.paintNodes(this.neighbours, 5);
                } else {
                    this.graph.setPromptLabel(" Click on the first node on the frontier.");
                }
                return;
            }
            if (this.currObject.getToNode() == testIndex) {
                this.graph.setPromptLabel(" Correct.  Click on the next node on the frontier");
                this.answerCorrect = true;
                if (this.previousObject != null) {
                    this.resetPrevious(this.previousObject);
                }
                if (!this.resultsShown) {
                    this.selectedNode.setSearchOrder(this.nodeCount);
                    this.selectedNode.setDrawOrdering(true);
                }
                ++this.nodeCount;
                this.resetNodes();
                this.resetEdges();
                this.paintPath(this.currObject, true);
                this.checkGoal(testIndex);
                this.showPath(this.currObject);
                this.stepThree();
                this.stepOne();
                this.selectedNode.setNodeAppearance(3);
                this.paintNodes(this.neighbours, 5);
            } else {
                this.graph.setPromptLabel(" Incorrect.  Try another node on the frontier");
                this.answerCorrect = false;
                if (this.previousObject != null) {
                    ((SearchNode)this.graph.nodeFromIndex(this.previousObject.getToNode())).setNodeAppearance(3);
                    this.paintPath(this.previousObject, true);
                }
                this.frontier = (Vector)oldFrontier.clone();
                this.neighbours = (Vector)oldNeighbours.clone();
                this.currObject = null;
                if (oldCurrObject != null) {
                    this.currObject = (SearchObject)oldCurrObject.clone();
                }
            }
        }
        this.selectedNode = null;
    }

    public void setSearchRate(int rate) {
        this.searchRate = rate;
    }

    public int getSearchRate() {
        return this.searchRate;
    }

    public int getPruning() {
        return this.pruning;
    }

    public void setPruning(int p) {
        this.pruning = p;
    }

    protected void stepOne() {
        if (this.backup != null) {
            this.frontier = this.backup;
        }
        if (this.neighbours != null && this.neighbours.size() > 0) {
            int i = 0;
            while (i < this.neighbours.size()) {
                this.shorterFrontier.addElement(new Integer(((SearchObject)this.neighbours.elementAt(i)).getToNode()));
                ++i;
            }
            this.mergeWithFrontier(this.neighbours);
            this.neighbours.removeAllElements();
            this.pruneNodes();
            this.paintNodes(this.frontier, 4);
        } else {
            this.pruneNodes();
        }
    }

    protected void stepTwo() {
        this.resetPrevious(this.currObject);
        if (this.frontier.size() > 0) {
            this.currObject = (SearchObject)((SearchObject)this.frontier.firstElement()).clone();
            int currIndex = this.currObject.getToNode();
            if (this.searchRate != 104) {
                SearchNode node = (SearchNode)this.graph.nodeFromIndex(currIndex);
                node.setNodeAppearance(3);
                node.setSearchOrder(this.nodeCount++ + 1);
                node.setDrawOrdering(true);
                this.paintPath(this.currObject, true);
                this.checkGoal(currIndex);
                this.showPath(this.currObject);
            }
            SearchNode tmpNode = (SearchNode)this.graph.nodeFromIndex(currIndex);
            tmpNode.setPathFound(true);
            this.nodesVisited.addElement(new Integer(currIndex));
            this.frontier.removeElementAt(0);
            this.shorterFrontier.removeElement(new Integer(currIndex));
        } else {
            this.completed();
        }
    }

    protected void stepThree() {
        this.neighbours = new Vector(5, 2);
        if (this.currObject != null) {
            int currIndex = this.currObject.getToNode();
            Vector children = (Vector)((SearchNode)this.graph.nodeFromIndex(currIndex)).getNeighbours().clone();
            int numNeigh = children != null ? children.size() : 0;
            int i = 0;
            while (i < numNeigh) {
                int nextNeigh = (Integer)children.firstElement();
                SearchNode tmpNode = (SearchNode)this.graph.nodeFromIndex(nextNeigh);
                boolean condition = false;
                if (this.pruning == 303) {
                    condition = true;
                } else if (this.pruning == 301) {
                    condition = true;
                } else if (!(this.pruning != 302 || this.currObject != null && this.currObject.checkNodeOnPath(nextNeigh))) {
                    condition = true;
                }
                if (condition) {
                    this.neighbours.addElement(new SearchObject(currIndex, nextNeigh, this.currObject.getPath(), this.graph));
                }
                children.removeElementAt(0);
                ++i;
            }
            if (this.neighbours.size() > 0) {
                this.paintNodes(this.neighbours, 5);
            }
        }
        this.backup = (Vector)this.frontier.clone();
        this.mergeWithFrontier(this.neighbours);
    }

    protected void checkGoal(int currIndex) {
        if (this.goalNodeIndex.contains(new Integer(currIndex))) {
            this.goalReached = true;
            this.showPath(this.currObject);
            this.graph.repaint();
            String saveLabel = this.graph.getPromptLabel();
            this.graph.setPromptLabel(" Goal Node reached! (" + this.pathString + ")");
            this.graph.showMessage("Goal Node Reached", "Path found: " + this.pathString);
            this.graph.setPromptLabel(saveLabel);
        }
    }

    protected void completed() {
        if (this.currObject != null) {
            this.paintPath(this.currObject, false);
            this.currObject = null;
        }
        int i = 0;
        while (i < this.graph.numNodes()) {
            SearchNode tmpNode = (SearchNode)this.graph.nodeAt(i);
            int currIndex = tmpNode.index;
            tmpNode.setNodeAppearance(6);
            this.graph.setPromptLabel(" Search Completed.\nClick on the Reset Search button to reset the graph.");
            ++i;
        }
    }

    public void paintNodes(Vector f, int what) {
        int i = 0;
        while (i < f.size()) {
            int index = ((SearchObject)f.elementAt(i)).getToNode();
            ((SearchNode)this.graph.nodeFromIndex(index)).setNodeAppearance(what);
            ++i;
        }
    }

    protected void paintPath(SearchObject so, boolean currPath) {
        if (so == null) {
            return;
        }
        Vector path = (Vector)so.getPath().clone();
        int max = path.size();
        int i = 0;
        while (i < max) {
            SearchEdge edge;
            Integer[] edgeNode = (Integer[])path.firstElement();
            path.removeElementAt(0);
            if (edgeNode[0] != -1 && (edge = (SearchEdge)this.graph.getEdge(edgeNode[0], edgeNode[1])) != null) {
                if (currPath) {
                    edge.xw = 2;
                    edge.color = Color.red;
                } else {
                    edge.xw = 0;
                    edge.color = Color.black;
                }
            }
            ++i;
        }
    }

    protected void resetPrevious(SearchObject tmpcurrObject) {
        if (tmpcurrObject != null) {
            int currIndex = tmpcurrObject.getToNode();
            if (this.shorterFrontier.contains(new Integer(currIndex))) {
                ((SearchNode)this.graph.nodeFromIndex(currIndex)).setNodeAppearance(4);
                return;
            }
            ((SearchNode)this.graph.nodeFromIndex(currIndex)).setNodeAppearance(6);
        } else {
            int index = (Integer)this.startNodeIndex.firstElement();
            if (this.shorterFrontier.contains(new Integer(index))) {
                return;
            }
            ((SearchNode)this.graph.nodeFromIndex(index)).setNodeAppearance(6);
        }
    }

    protected void resetEdges() {
        Enumeration edges = this.graph.getEdges();
        while (edges.hasMoreElements()) {
            SearchEdge edge = (SearchEdge)edges.nextElement();
            edge.xw = 0;
            edge.color = Color.black;
        }
    }

    protected void resetNodes() {
        int i = 0;
        while (i < this.graph.numNodes()) {
            SearchNode tmpNode = (SearchNode)this.graph.nodeAt(i);
            if (tmpNode.getDrawOrdering()) {
                tmpNode.setNodeAppearance(6);
            }
            ++i;
        }
    }

    protected void clearOrdering() {
        int i = 0;
        while (i < this.graph.numNodes()) {
            SearchNode tmpNode = (SearchNode)this.graph.nodeAt(i);
            if (tmpNode.getDrawOrdering()) {
                tmpNode.resetSearchOrder();
            }
            ++i;
        }
    }

    protected void pruneNodes() {
        if (this.pruning == 301) {
            SearchNode node;
            int i = 0;
            while (i < this.frontier.size()) {
                SearchObject so = (SearchObject)this.frontier.elementAt(i);
                if (this.nodesVisited.contains(new Integer(so.getToNode()))) {
                    SearchNode tmpNode = (SearchNode)this.graph.nodeFromIndex(so.getToNode());
                    tmpNode.setNodeAppearance(6);
                    this.frontier.removeElementAt(i);
                    this.shorterFrontier.removeElement(new Integer(so.getToNode()));
                    continue;
                }
                ++i;
            }
            if (this.previousIndex != -1 && (node = (SearchNode)this.graph.nodeFromIndex(this.previousIndex)) != null) {
                node.setNodeAppearance(6);
            }
        }
    }

    public Vector getFrontier() {
        return this.frontier;
    }

    public Vector getNeighbours() {
        return this.neighbours;
    }

    public boolean getAnswerCorrect() {
        return this.answerCorrect;
    }

    protected abstract void mergeWithFrontier(Vector var1);
}

