/*
 * Decompiled with CFR 0.152.
 */
package CIspace.search;

import CIspace.graphToolKit.EdgeLabel;
import CIspace.graphToolKit.Entity;
import CIspace.graphToolKit.GraphCanvas;
import CIspace.graphToolKit.Point;
import CIspace.search.EdgePropDialog;
import CIspace.search.FrontierInfoFrame;
import CIspace.search.NodePropDialog;
import CIspace.search.Search;
import CIspace.search.SearchEdge;
import CIspace.search.SearchGraph;
import CIspace.search.SearchNode;
import CIspace.search.SearchWindow;
import CIspace.search.TextFrame;
import java.awt.Container;
import java.awt.Frame;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;

public class SearchCanvas
extends GraphCanvas {
    private NodePropDialog nDialog;
    private EdgePropDialog eDialog;
    private SearchNode selectedNode;
    public int searchMethod;
    private int lastStepSize;
    public boolean autoNH;
    public boolean autoEC;

    public SearchCanvas(Container parent, boolean inline) {
        super(parent, inline);
        this.graph = new SearchGraph(this);
        this.autoNH = true;
        this.autoEC = true;
        this.lastStepSize = 102;
    }

    protected void popupCanvas(int x, int y) {
        MenuItem mItem;
        this.pop.setLabel("Canvas Options");
        this.pop.removeAll();
        if (this.mode == 2220) {
            mItem = new MenuItem("Create Node");
            mItem.setActionCommand(mItem.getLabel());
            mItem.addActionListener(this);
            this.pop.add(mItem);
        } else {
            mItem = new MenuItem("Step");
            mItem.setActionCommand(mItem.getLabel());
            mItem.addActionListener(this);
            this.pop.add(mItem);
            mItem = new MenuItem("Fine Step");
            mItem.setActionCommand(mItem.getLabel());
            mItem.addActionListener(this);
            this.pop.add(mItem);
            mItem = new MenuItem("Auto Search");
            mItem.setActionCommand(mItem.getLabel());
            mItem.addActionListener(this);
            this.pop.add(mItem);
            mItem = new MenuItem("Stop Search");
            mItem.setActionCommand(mItem.getLabel());
            mItem.addActionListener(this);
            this.pop.add(mItem);
            mItem = new MenuItem("Reset Search");
            mItem.setActionCommand(mItem.getLabel());
            mItem.addActionListener(this);
            this.pop.add(mItem);
        }
        this.pop.addSeparator();
        mItem = new MenuItem("Autoscale");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        if (((SearchGraph)this.graph).getDisplayCost()) {
            mItem = new MenuItem("Reset Edge Labels");
            mItem.setActionCommand(mItem.getLabel());
            mItem.addActionListener(this);
            this.pop.add(mItem);
        }
        this.pop.show(this, x, y);
    }

    protected void popupNode(int x, int y) {
        MenuItem mItem;
        this.pop.setLabel("Node Options");
        this.pop.removeAll();
        if (this.mode == 2220) {
            mItem = new MenuItem("Create Edge");
            mItem.setActionCommand(mItem.getLabel());
            mItem.addActionListener(this);
            this.pop.add(mItem);
            mItem = new MenuItem("Properties");
            mItem.setActionCommand(mItem.getLabel());
            mItem.addActionListener(this);
            this.pop.add(mItem);
            mItem = new MenuItem("Delete");
            mItem.setActionCommand(mItem.getLabel());
            mItem.addActionListener(this);
            this.pop.add(mItem);
            this.pop.addSeparator();
            mItem = new MenuItem("Set as Start Node");
            mItem.setActionCommand(mItem.getLabel());
            mItem.addActionListener(this);
            this.pop.add(mItem);
            mItem = new MenuItem("Set as Goal Node");
            mItem.setActionCommand(mItem.getLabel());
            mItem.addActionListener(this);
            this.pop.add(mItem);
            mItem = new MenuItem("Set as Regular Node");
            mItem.setActionCommand(mItem.getLabel());
            mItem.addActionListener(this);
            this.pop.add(mItem);
            this.pop.addSeparator();
        }
        mItem = new MenuItem("Autoscale");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.pop.show(this, x, y);
    }

    protected void popupEdge(int x, int y) {
        MenuItem mItem;
        this.pop.setLabel("Edge Options");
        this.pop.removeAll();
        if (this.mode == 2220) {
            mItem = new MenuItem("Properties");
            mItem.setActionCommand(mItem.getLabel());
            mItem.addActionListener(this);
            this.pop.add(mItem);
            if (((SearchGraph)this.graph).getDisplayCost()) {
                mItem = new MenuItem("Reset Edge Label");
                mItem.setActionCommand(mItem.getLabel());
                mItem.addActionListener(this);
                this.pop.add(mItem);
            }
            mItem = new MenuItem("Delete");
            mItem.setActionCommand(mItem.getLabel());
            mItem.addActionListener(this);
            this.pop.add(mItem);
            this.pop.addSeparator();
        } else if (((SearchGraph)this.graph).getDisplayCost()) {
            mItem = new MenuItem("Reset Edge Label");
            mItem.setActionCommand(mItem.getLabel());
            mItem.addActionListener(this);
            this.pop.add(mItem);
        }
        mItem = new MenuItem("Autoscale");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.pop.show(this, x, y);
    }

    public void reset() {
        super.reset();
        this.graph = new SearchGraph(this);
        this.resetSearch();
    }

    public String parse(String str) {
        this.resetSearch();
        String errMsg = ((SearchGraph)this.graph).parse(str);
        if (errMsg.equals("OK")) {
            this.repaint();
            this.autoscale();
        }
        return errMsg;
    }

    public String parseXML(String str) {
        this.resetSearch();
        String errMsg = ((SearchGraph)this.graph).updateGraphFromXML(str);
        if (errMsg.equals("OK")) {
            this.repaint();
            this.autoscale();
        }
        return errMsg;
    }

    public void pause() {
        super.pause();
        Search search = ((SearchGraph)this.graph).getSearchObject();
        if (search != null) {
            search.pauseAuto(true);
        }
    }

    public void unpause() {
        super.unpause();
        Search search = ((SearchGraph)this.graph).getSearchObject();
        if (search != null) {
            search.pauseAuto(false);
        }
    }

    public void doSearch(int searchAlgorithm, int rate) {
        this.lastStepSize = rate;
        this.searchMethod = searchAlgorithm;
        ((SearchGraph)this.graph).doSearch(searchAlgorithm, rate);
        this.repaint();
    }

    public void resetSearch() {
        ((SearchGraph)this.graph).resetSearch();
        this.repaint();
    }

    public void resetCosts() {
        int i = 0;
        while (i < this.graph.numNodes()) {
            SearchNode curr = (SearchNode)this.graph.nodeAt(i);
            if (curr != null) {
                curr.setHeuristics(0.0);
                curr.updateSize();
            }
            ++i;
        }
        Enumeration edges = this.graph.getEdges();
        while (edges.hasMoreElements()) {
            SearchEdge tmpEdge = (SearchEdge)edges.nextElement();
            tmpEdge.setCost(1.0);
        }
    }

    public void greenify() {
        Vector startNodes = ((SearchGraph)this.graph).getStartNodeIndex();
        FrontierInfoFrame fif = ((SearchGraph)this.graph).getFrontierInfoFrame();
        if (fif != null) {
            fif.clear();
        }
        int i = 0;
        while (i < startNodes.size()) {
            SearchNode node = (SearchNode)this.graph.nodeFromIndex((Integer)startNodes.elementAt(i));
            node.setNodeAppearance(4);
            node.setNodeSearchType(4);
            if (fif != null) {
                fif.showInitFrontier(node);
            }
            ++i;
        }
        ((SearchGraph)this.graph).stepInit = true;
    }

    public void disableStopButton() {
        if (this.inline) {
            return;
        }
        ((SearchWindow)this.parent).stopSearch.setEnabled(false);
    }

    public void disposeWindows() {
        FrontierInfoFrame fif;
        super.disposeWindows();
        if (this.nDialog != null) {
            this.nDialog.dispose();
        }
        if (this.eDialog != null) {
            this.eDialog.dispose();
        }
        if ((fif = ((SearchGraph)this.graph).getFrontierInfoFrame()) != null) {
            fif.dispose();
        }
    }

    public void setMode(int newMode) {
        this.mode = newMode;
        this.clearMouse();
        this.graph.deselectAll();
        this.resetSearch();
        this.repaint();
    }

    protected void createNode(Entity ent, Point p) {
        if (ent == null || ent.type != 7770) {
            SearchNode node = new SearchNode((SearchGraph)this.graph);
            node.pos = p;
            node.setNodeAppearance(0);
            String nodeName = "Node " + this.graph.getNextIndex();
            if (this.autoNH) {
                node.updateProperties(nodeName, 0.0);
                this.graph.addNode(node);
                this.repaint();
            } else {
                this.pause();
                if (this.nDialog == null) {
                    this.nDialog = new NodePropDialog((Frame)this.parent, (SearchGraph)this.graph);
                }
                this.nDialog.open(node);
                if (!this.nDialog.cancelled) {
                    this.graph.addNode(node);
                }
                this.unpause();
            }
        }
    }

    protected void createEdge(Entity ent, Point p) {
        if (this.makingEdge == 1) {
            if (ent == null || ent.type != 7770) {
                this.makingEdge = 0;
            } else if (ent.type == 7770) {
                this.to = (SearchNode)ent;
                SearchEdge edge = new SearchEdge((SearchGraph)this.graph, this.from, this.to);
                edge.updateLength();
                this.makingEdge = 2;
                if (this.autoEC) {
                    this.graph.addEdge(edge);
                    this.repaint();
                } else {
                    this.pause();
                    if (this.eDialog == null) {
                        this.eDialog = new EdgePropDialog((Frame)this.parent, (SearchGraph)this.graph);
                    }
                    this.eDialog.open(edge);
                    if (!this.eDialog.cancelled) {
                        this.graph.addEdge(edge);
                    }
                    this.unpause();
                }
                this.makingEdge = 0;
            }
            if (this.tmpMode != -1) {
                this.submode = this.tmpMode;
            }
            this.tmpMode = -1;
        } else if (ent != null && ent.type == 7770) {
            this.from = (SearchNode)ent;
            this.makingEdge = 1;
            this.mMovedPos.move(p);
        }
    }

    protected void setEntProperties(Entity ent) {
        this.pause();
        if (ent.type == 7770) {
            if (this.nDialog == null) {
                this.nDialog = new NodePropDialog((Frame)this.parent, (SearchGraph)this.graph);
            }
            this.nDialog.open((SearchNode)ent);
        } else if (ent.type == 7771) {
            if (this.eDialog == null) {
                this.eDialog = new EdgePropDialog((Frame)this.parent, (SearchGraph)this.graph);
            }
            this.eDialog.open((SearchEdge)ent);
        } else if (ent.type == 7772) {
            ent = ((EdgeLabel)ent).parent;
            if (this.eDialog == null) {
                this.eDialog = new EdgePropDialog((Frame)this.parent, (SearchGraph)this.graph);
            }
            this.eDialog.open((SearchEdge)ent);
        }
        this.unpause();
    }

    protected void setStartNode(SearchNode node) {
        ((SearchGraph)this.graph).setAsStartNode(node);
        this.graph.updateNodeSize(node);
        ((SearchGraph)this.graph).setHeuristicsFromDistance(this.autoNH);
    }

    protected void setGoalNode(SearchNode node) {
        ((SearchGraph)this.graph).setAsGoalNode(node);
        this.graph.updateNodeSize(node);
        ((SearchGraph)this.graph).setHeuristicsFromDistance(this.autoNH);
    }

    protected void setRegularNode(SearchNode node) {
        ((SearchGraph)this.graph).setAsRegularNode(node);
        this.graph.updateNodeSize(node);
        ((SearchGraph)this.graph).setHeuristicsFromDistance(this.autoNH);
    }

    protected Entity mPressed(MouseEvent e) {
        Search tmpSearch;
        Entity ent = super.mPressed(e);
        if (this.mode == 2220) {
            if (ent == null) {
                return null;
            }
            if (ent.type != 7770) {
                return ent;
            }
        } else if (this.mode == 2221 && (tmpSearch = ((SearchGraph)this.graph).getSearchObject()) != null && (this.searchMethod == 209 || ((SearchGraph)this.graph).getSearchRate() == 104)) {
            if (ent == null || ent.type != 7770) {
                return ent;
            }
            this.repaint();
            tmpSearch.setSelectedNode((SearchNode)ent);
            tmpSearch.step();
            if (tmpSearch.getAnswerCorrect() || this.searchMethod == 209) {
                FrontierInfoFrame frontierInfoFrame;
                if (!this.inline) {
                    ((SearchWindow)this.parent).userDefinedStep();
                }
                if ((frontierInfoFrame = ((SearchGraph)this.graph).getFrontierInfoFrame()) != null && frontierInfoFrame.isVisible()) {
                    frontierInfoFrame.showMe();
                }
            }
        }
        return ent;
    }

    protected void mReleased(MouseEvent e) {
        super.mReleased(e);
        if (e.getModifiers() == 4) {
            return;
        }
        if (this.mode == 2220) {
            this.graph.updateNodeSize();
            if (((SearchGraph)this.graph).getUseNodeDistance()) {
                ((SearchGraph)this.graph).setHeuristicsFromDistance(true);
                if (((SearchGraph)this.graph).getDisplayHeuristics()) {
                    this.repaint();
                }
            }
        } else if (this.mode == 2221) {
            Search tmpSearch = ((SearchGraph)this.graph).getSearchObject();
            if (tmpSearch != null) {
                ((SearchGraph)this.graph).getSearchRate();
                this.repaint();
            }
            this.graph.deselectAll();
        }
    }

    protected void mDragged(MouseEvent e) {
        if (this.mode == 2220) {
            super.mDragged(e);
            return;
        }
        if (this.mode == 2221 && e.getModifiers() == 4) {
            super.mDragged(e);
            return;
        }
    }

    public void textRep() {
        String textRep = ((SearchGraph)this.graph).generateTextRep();
        TextFrame tf = new TextFrame(this, textRep, false);
    }

    public void XMLRep() {
        String textRep = ((SearchGraph)this.graph).generateXMLTextRep();
        TextFrame tf = new TextFrame(this, textRep, true);
    }

    public boolean updateGraphFromText(String allText) {
        SearchGraph old = (SearchGraph)this.graph;
        this.graph = new SearchGraph(this);
        String tmp = ((SearchGraph)this.graph).updateGraphFromText(allText);
        if (tmp.equals("OK")) {
            this.repaint();
            return true;
        }
        this.showMessage("Error", tmp);
        this.graph = old;
        return false;
    }

    public boolean updateGraphFromXML(String allText) {
        SearchGraph old = (SearchGraph)this.graph;
        this.graph = new SearchGraph(this);
        String tmp = ((SearchGraph)this.graph).updateGraphFromXML(allText);
        if (tmp.equals("OK")) {
            this.repaint();
            return true;
        }
        this.showMessage("Error", tmp);
        this.graph = old;
        return false;
    }

    public void setPathArea(String s) {
        if (!this.inline) {
            ((SearchWindow)this.parent).setPathArea(s);
        }
    }

    public void setPromptLabel(String s) {
        if (!this.inline) {
            ((SearchWindow)this.parent).setPromptLabel(s);
        }
    }

    public String getPromptLabel() {
        if (!this.inline) {
            return ((SearchWindow)this.parent).getPromptLabel();
        }
        return null;
    }

    public void autoNH(boolean on) {
        if (!this.inline) {
            ((SearchWindow)this.parent).autoNH(on);
        }
        this.autoNH = on;
    }

    public void autoEC(boolean on) {
        if (!this.inline) {
            ((SearchWindow)this.parent).autoEC(on);
        }
        this.autoEC = on;
    }

    public void kPressed(KeyEvent e) {
        super.kPressed(e);
        int arg = e.getKeyCode();
        if (arg == 32 || arg == 10 || arg == 83) {
            this.doSearch(this.searchMethod, this.lastStepSize);
        }
    }

    public void aPerformed(ActionEvent e) {
        super.aPerformed(e);
        String arg = e.getActionCommand();
        if (arg.equals("Set as Start Node")) {
            this.setStartNode((SearchNode)this.entClicked);
        } else if (arg.equals("Set as Goal Node")) {
            this.setGoalNode((SearchNode)this.entClicked);
        } else if (arg.equals("Set as Regular Node")) {
            this.setRegularNode((SearchNode)this.entClicked);
        } else if (arg.equals("Step")) {
            this.doSearch(this.searchMethod, 102);
        } else if (arg.equals("Fine Step")) {
            this.doSearch(this.searchMethod, 103);
        } else if (arg.equals("Auto Search")) {
            this.doSearch(this.searchMethod, 101);
        } else if (arg.equals("Stop Search")) {
            ((SearchGraph)this.graph).stopAutoSearch();
        } else if (arg.equals("Reset Search")) {
            if (!this.inline) {
                ((SearchWindow)this.parent).resetSearch();
            } else {
                this.resetSearch();
                this.greenify();
            }
        }
    }
}

