/*
 * Decompiled with CFR 0.152.
 */
package CIspace.search;

import CIspace.graphToolKit.Edge;
import CIspace.graphToolKit.Node;
import CIspace.search.SearchGraph;
import CIspace.search.SearchNode;
import java.awt.Graphics;

public class SearchEdge
extends Edge {
    protected double cost = 1.0;
    protected double edgeLength = 1.0;
    protected boolean costShown = false;

    public SearchEdge(SearchGraph graph, Node tail, Node head) {
        super(graph, tail, head);
        this.edgeType = 5551;
        ((SearchNode)this.start).setChild(this.end.index);
    }

    public double getCost() {
        return this.cost;
    }

    public void setCost(double c) {
        this.cost = c;
    }

    public void showCost() {
        if (!this.costShown) {
            this.setLabel(new Double(this.cost).toString());
            this.costShown = true;
        }
    }

    public void hideCost() {
        if (this.costShown) {
            this.setLabel("");
            this.costShown = false;
        }
    }

    public void updateProperties(double c) {
        this.setCost(c);
        if (((SearchGraph)this.graph).getDisplayCost()) {
            this.costShown = false;
            this.showCost();
        } else {
            this.costShown = true;
            this.hideCost();
        }
    }

    public void draw(Graphics offscreen, boolean moving) {
        if (((SearchGraph)this.graph).getDisplayCost()) {
            this.costShown = false;
            this.showCost();
        } else {
            this.hideCost();
        }
        super.draw(offscreen, moving);
    }

    public void updateLength() {
        this.b[0] = this.start.findBorder(this.end);
        this.b[1] = this.end.findBorder(this.start);
        this.length = this.distance(this.b[0], this.b[1]);
        if (((SearchGraph)this.graph).getUseEdgeLength()) {
            this.cost = (double)Math.round(this.distance(this.start.pos, this.end.pos) / this.graph.getScale()) / 10.0;
        }
    }
}

