/*
 * Decompiled with CFR 0.152.
 */
package CIspace.search;

import CIspace.XMLReader.Pair;
import CIspace.XMLReader.XMLBlock;
import CIspace.XMLReader.XMLTree;
import CIspace.graphToolKit.Graph;
import CIspace.graphToolKit.Node;
import CIspace.graphToolKit.Point;
import CIspace.search.AStar;
import CIspace.search.BestFirst;
import CIspace.search.BreadthFirst;
import CIspace.search.DepthFirst;
import CIspace.search.FrontierInfoFrame;
import CIspace.search.HeuristicDepthFirst;
import CIspace.search.LowestCostFirst;
import CIspace.search.Search;
import CIspace.search.SearchCanvas;
import CIspace.search.SearchEdge;
import CIspace.search.SearchNode;
import CIspace.search.UserDefinedSearch;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Vector;

public class SearchGraph
extends Graph {
    private Vector startNodes = new Vector(5, 2);
    private Vector goalNodes = new Vector(5, 2);
    private int searchRate = 102;
    private int pruning = 303;
    private Search search;
    private FrontierInfoFrame frontierInfoFrame;
    public boolean stepInit = false;
    private int maxNumSteps = 50;
    private boolean stopAtGoal = true;
    private boolean showNum = false;
    protected boolean askNodeProp = false;
    protected boolean displayHeuristics = false;
    protected boolean useNodeDistance = true;
    protected boolean displayCost = false;
    protected boolean askEdgeProp = false;
    protected boolean useEdgeLength = true;
    public static final int C_SET_START = 11;
    public static final int C_SET_GOAL = 15;
    public static final int C_SET_REGULAR = 16;

    public SearchGraph(SearchCanvas canvas) {
        super(canvas);
    }

    public Search getSearchObject() {
        return this.search;
    }

    public int getMaxNumSteps() {
        return this.maxNumSteps;
    }

    public void setMaxNumSteps(int num) {
        this.maxNumSteps = num;
    }

    public boolean getStopAtGoal() {
        return this.stopAtGoal;
    }

    public void setStopAtGoal(boolean bool) {
        this.stopAtGoal = bool;
    }

    public boolean getShowNum() {
        return this.showNum;
    }

    public void setShowNum(boolean bool) {
        this.showNum = bool;
    }

    public void setPathArea(String s) {
        ((SearchCanvas)this.canvas).setPathArea(s);
    }

    public void setPromptLabel(String s) {
        ((SearchCanvas)this.canvas).setPromptLabel(s);
    }

    public String getPromptLabel() {
        return ((SearchCanvas)this.canvas).getPromptLabel();
    }

    public void setAskNodeProp(boolean bool) {
        this.askNodeProp = bool;
    }

    public boolean getAskNodeProp() {
        return this.askNodeProp;
    }

    public void setDisplayHeuristics(boolean bool) {
        this.displayHeuristics = bool;
    }

    public boolean getDisplayHeuristics() {
        return this.displayHeuristics;
    }

    public void setUseNodeDistance(boolean bool) {
        this.useNodeDistance = bool;
    }

    public boolean getUseNodeDistance() {
        return this.useNodeDistance;
    }

    public void setAskEdgeProp(boolean bool) {
        this.askEdgeProp = bool;
    }

    public boolean getAskEdgeProp() {
        return this.askEdgeProp;
    }

    public void setDisplayCost(boolean bool) {
        this.displayCost = bool;
    }

    public boolean getDisplayCost() {
        return this.displayCost;
    }

    public void setUseEdgeLength(boolean bool) {
        this.useEdgeLength = bool;
    }

    public boolean getUseEdgeLength() {
        return this.useEdgeLength;
    }

    public void showFrontierInfoFrame() {
        if (this.frontierInfoFrame == null) {
            this.frontierInfoFrame = new FrontierInfoFrame(this);
        }
        if (this.stepInit) {
            this.frontierInfoFrame.clear();
            int i = 0;
            while (i < this.startNodes.size()) {
                SearchNode node = (SearchNode)this.nodeFromIndex((Integer)this.startNodes.elementAt(i));
                node.setNodeAppearance(4);
                node.setNodeSearchType(4);
                this.frontierInfoFrame.showInitFrontier(node);
                ++i;
            }
            this.stepInit = false;
        }
        ((Component)this.frontierInfoFrame).setVisible(true);
    }

    public FrontierInfoFrame getFrontierInfoFrame() {
        return this.frontierInfoFrame;
    }

    public Vector getStartNodeIndex() {
        return this.startNodes;
    }

    public Vector getGoalNodeIndex() {
        return this.goalNodes;
    }

    public int getSearchRate() {
        return this.searchRate;
    }

    public void setSearchRate(int rate) {
        this.searchRate = rate;
    }

    public int getPruning() {
        return this.pruning;
    }

    public void setPruning(int p) {
        this.pruning = p;
    }

    public void setNodeAs(int type) {
        int i = 0;
        while (i < this.selectedNodes.size()) {
            SearchNode tmpNode = (SearchNode)this.selectedNodes.elementAt(i);
            if (type == 11) {
                this.setAsStartNode(tmpNode);
            } else if (type == 15) {
                this.setAsGoalNode(tmpNode);
            } else if (type == 16) {
                this.setAsRegularNode(tmpNode);
            }
            ++i;
        }
        this.updateNodeSize();
        this.setHeuristicsFromDistance(((SearchCanvas)this.canvas).autoNH);
        this.repaint();
    }

    public void stopAutoSearch() {
        if (this.search != null) {
            this.search.stopAutoSearch();
        }
    }

    public void disableStopButton() {
        ((SearchCanvas)this.canvas).disableStopButton();
    }

    public void setHeuristicsFromDistance(boolean value) {
        if (value) {
            int i = 0;
            while (i < this.numNodes()) {
                SearchNode tmpNode = (SearchNode)this.nodeAt(i);
                Point tmpPosition = tmpNode.pos;
                double minDist = 99999.9;
                if (this.goalNodes.size() > 0) {
                    int j = 0;
                    while (j < this.goalNodes.size()) {
                        SearchNode currGoalNode = (SearchNode)this.nodeFromIndex((Integer)this.goalNodes.elementAt(j));
                        Point currGoalPosition = currGoalNode.pos;
                        double dx = currGoalPosition.x - tmpPosition.x;
                        double dy = currGoalPosition.y - tmpPosition.y;
                        double currDist = Math.sqrt(dx * dx + dy * dy);
                        if (currDist < minDist) {
                            minDist = currDist;
                        }
                        ++j;
                    }
                    tmpNode.setDistance(minDist);
                } else {
                    tmpNode.setDistance(0.0);
                }
                tmpNode.setHeuristics((double)Math.round(tmpNode.getDistance()) / 10.0);
                tmpNode.updateSize();
                ++i;
            }
        }
    }

    public void setNodes() {
        this.startNodes = new Vector(5, 2);
        this.goalNodes = new Vector(5, 2);
        int i = 0;
        while (i < this.numNodes()) {
            SearchNode tmpNode = (SearchNode)this.nodeAt(i);
            Integer tmpIndex = new Integer(tmpNode.index);
            if (tmpNode.getNodeType() == 1 && !this.startNodes.contains(tmpIndex)) {
                this.startNodes.addElement(tmpIndex);
            }
            if (tmpNode.getNodeType() == 2 && !this.goalNodes.contains(tmpIndex)) {
                this.goalNodes.addElement(tmpIndex);
            }
            ++i;
        }
    }

    public void doSearch(int searchAlgorithm, int rate) {
        this.stepInit = false;
        this.setSearchRate(rate);
        if (this.startNodes.size() > 0) {
            if (this.search == null) {
                switch (searchAlgorithm) {
                    case 201: {
                        this.search = new DepthFirst(this);
                        break;
                    }
                    case 202: {
                        this.search = new BreadthFirst(this);
                        break;
                    }
                    case 203: {
                        this.search = new LowestCostFirst(this);
                        break;
                    }
                    case 204: {
                        this.search = new BestFirst(this);
                        break;
                    }
                    case 205: {
                        this.search = new HeuristicDepthFirst(this);
                        break;
                    }
                    case 206: {
                        this.search = new AStar(this);
                        break;
                    }
                    case 209: {
                        this.search = new UserDefinedSearch(this);
                        break;
                    }
                }
            } else {
                if (this.search.getSearchRate() == 104) {
                    this.setPromptLabel("Click on the next node on the frontier.");
                }
                this.search.setSearchRate(rate);
                this.search.step();
            }
        } else {
            System.out.println("You must select a Start Node first");
        }
        if (this.frontierInfoFrame != null && this.frontierInfoFrame.isVisible()) {
            this.frontierInfoFrame.showMe();
        }
    }

    public void resetSearch() {
        if (this.search != null) {
            this.search.resetAutoSearch();
        }
        this.search = null;
        this.stepInit = false;
        Vector startNodeIndex = this.getStartNodeIndex();
        Vector goalNodeIndex = this.getGoalNodeIndex();
        int i = 0;
        while (i < this.numNodes()) {
            SearchNode curr = (SearchNode)this.nodeAt(i);
            if (curr != null) {
                Integer currIndex = new Integer(curr.getIndex());
                curr.setDrawOrdering(false);
                curr.resetSearchOrder();
                curr.setPathFound(false);
                curr.setNodeAppearance(6);
            }
            ++i;
        }
        Enumeration edges = this.getEdges();
        while (edges.hasMoreElements()) {
            SearchEdge edge = (SearchEdge)edges.nextElement();
            edge.color = Color.black;
            edge.xw = 0;
        }
        if (this.frontierInfoFrame != null) {
            this.frontierInfoFrame.clear();
        }
    }

    public String parse(String file) {
        String errorMessage = "";
        int p1 = -1;
        int p2 = file.indexOf("\n");
        int lineCount = 0;
        this.nodes = new Vector(10, 10);
        this.edges = new Vector(10, 10);
        this.selectedNodes = new Vector(10, 10);
        this.selectedEdges = new Vector(10, 10);
        this.scale = 1.0f;
        try {
            while (p2 != -1) {
                String inString = file.substring(p1 + 1, p2).trim();
                if (inString.length() > 0) {
                    if (inString.charAt(0) != '%' && inString.indexOf(";") == -1) {
                        errorMessage = new String("Missing semicolon");
                        throw new Exception();
                    }
                    errorMessage = this.parseLine(inString.trim());
                    if (errorMessage.length() > 0) {
                        throw new Exception();
                    }
                }
                p1 = p2;
                p2 = file.indexOf("\n", p1 + 1);
                ++lineCount;
            }
            this.setNodes();
            if (this.frontierInfoFrame != null) {
                this.frontierInfoFrame.setGraph(this);
            }
            return "OK";
        }
        catch (Exception e) {
            String message = "";
            message = errorMessage.length() > 0 ? "Error at line " + (lineCount + 1) + " -- " + errorMessage : "Error at line " + (lineCount + 1) + " -- " + e.toString();
            return message;
        }
    }

    public String parseLine(String inString) throws IOException {
        String errorMessage = "";
        if (inString.charAt(0) == 'N') {
            int p1 = inString.indexOf(",");
            int p2 = inString.indexOf(",", p1 + 1);
            String name = inString.substring(p1 + 1, p2).trim();
            p1 = p2;
            p2 = inString.indexOf(",", p1 + 1);
            Float x = new Float(inString.substring(p1 + 1, p2).trim());
            p1 = p2;
            p2 = inString.indexOf(",", p1 + 1);
            Float y = new Float(inString.substring(p1 + 1, p2).trim());
            Point pos = new Point(x.floatValue(), y.floatValue());
            p1 = p2;
            p2 = inString.indexOf(",", p1 + 1);
            String stringType = inString.substring(p1 + 1, p2).trim();
            int type = 0;
            if (stringType.equals("REGULAR")) {
                type = 0;
            } else if (stringType.equals("GOAL")) {
                type = 2;
            } else if (stringType.equals("START")) {
                type = 1;
            }
            p1 = p2;
            p2 = inString.indexOf(";");
            Double h = new Double(inString.substring(p1 + 1, p2).trim());
            p1 = inString.indexOf(":");
            p2 = inString.indexOf(",");
            Integer ind = new Integer(inString.substring(p1 + 1, p2).trim());
            int index = ind;
            SearchNode node = new SearchNode(this);
            node.setLabel(name);
            node.setJustLabel(name);
            node.setNodeType(type);
            node.setNodeAppearance(type);
            node.pos = pos;
            node.setHeuristics(h);
            node.updateSize();
            this.addNode(node);
            node.index = index;
        } else if (inString.charAt(0) == 'E') {
            int p1 = inString.indexOf(":");
            int p2 = inString.indexOf(",");
            Integer fromIndex = new Integer(inString.substring(p1 + 1, p2).trim());
            int from = fromIndex;
            p1 = p2;
            p2 = inString.indexOf(",", p1 + 1);
            Integer toIndex = new Integer(inString.substring(p1 + 1, p2).trim());
            int to = toIndex;
            p1 = p2;
            p2 = inString.indexOf(";", p1 + 1);
            Double cost = new Double(inString.substring(p1 + 1, p2).trim());
            if (!this.validNodeIndex(from)) {
                errorMessage = "Error: Node " + from + " does not exist!";
            } else if (!this.validNodeIndex(to)) {
                errorMessage = "Error: Node " + to + " does not exist!";
            } else {
                SearchEdge edge = new SearchEdge(this, this.nodeFromIndex(from), this.nodeFromIndex(to));
                edge.setCost(cost);
                this.addEdge(edge);
            }
        } else if (inString.charAt(0) == 'M') {
            int p1 = inString.indexOf(":");
            int p2 = inString.indexOf(",");
            String name = inString.substring(p1 + 1, p2).trim();
            p1 = p2;
            p2 = inString.indexOf(";", p1 + 1);
            String type = inString.substring(p1 + 1, p2).trim();
            if (name.equals("HEURISTICS")) {
                if (type.equals("AUTOMATIC")) {
                    this.setUseNodeDistance(true);
                    ((SearchCanvas)this.canvas).autoNH(true);
                } else if (type.equals("MANUAL")) {
                    this.setUseNodeDistance(false);
                    ((SearchCanvas)this.canvas).autoNH(false);
                } else {
                    errorMessage = new String("\"HEURISTICS\" must be set to either \"AUTOMATIC\" or \"MANUAL\"");
                }
            } else if (name.equals("COSTS")) {
                if (type.equals("AUTOMATIC")) {
                    this.setUseEdgeLength(true);
                    ((SearchCanvas)this.canvas).autoEC(true);
                } else if (type.equals("MANUAL")) {
                    this.setUseEdgeLength(false);
                    ((SearchCanvas)this.canvas).autoEC(false);
                } else {
                    errorMessage = new String("\"COSTS\" must be set to either \"AUTOMATIC\" or \"MANUAL\"");
                }
            } else {
                errorMessage = new String("miscellaneous items must be either \"HEURISTICS\" or \"COST\"");
            }
        } else if (inString.charAt(0) != '%' && inString.charAt(0) != ' ' && inString.charAt(0) != '\n') {
            errorMessage = new String("Invalid format");
        }
        return errorMessage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String parseXML(XMLTree tree) {
        String errorMessage = "";
        try {
            Pair h;
            Vector heuristicPair;
            Vector heuristic;
            XMLBlock graph;
            block35: {
                block34: {
                    Vector allEdges;
                    graph = tree.findNetworkTree("graph");
                    if (graph == null) {
                        errorMessage = "No graph defined in XML";
                        throw new Exception();
                    }
                    Vector allNodes = graph.searchChildTag("node");
                    if (allNodes == null) {
                        errorMessage = "No nodes defined";
                        throw new Exception();
                    }
                    int i = 0;
                    while (true) {
                        if (i >= allNodes.size()) {
                            allEdges = graph.searchChildTag("edge");
                            if (allEdges != null) break;
                            errorMessage = "No edges defined";
                            throw new Exception();
                        }
                        XMLBlock node = (XMLBlock)allNodes.elementAt(i);
                        Vector nameVect = node.searchChildTag("name");
                        if (nameVect == null) {
                            errorMessage = "Name not defined for a node";
                            throw new Exception();
                        }
                        String name = ((XMLBlock)nameVect.elementAt(0)).getText().trim();
                        Vector xpos = node.searchChildTag("xpos");
                        Vector ypos = node.searchChildTag("ypos");
                        if (xpos == null) {
                            errorMessage = "Node " + name + " has no x-position defined";
                            throw new Exception();
                        }
                        if (ypos == null) {
                            errorMessage = "Node " + name + " has no y-position defined";
                            throw new Exception();
                        }
                        float x = Float.valueOf(((XMLBlock)xpos.elementAt(0)).getText().trim()).floatValue();
                        float y = Float.valueOf(((XMLBlock)ypos.elementAt(0)).getText().trim()).floatValue();
                        Point pos = new Point(x, y);
                        Vector typeVect = node.searchChildTag("type");
                        if (typeVect == null) {
                            errorMessage = "Node " + name + " has no type defined";
                            throw new Exception();
                        }
                        String stringType = ((XMLBlock)typeVect.elementAt(0)).getText().trim();
                        int type = 0;
                        if (stringType.equals("REGULAR")) {
                            type = 0;
                        } else if (stringType.equals("GOAL")) {
                            type = 2;
                        } else if (stringType.equals("START")) {
                            type = 1;
                        }
                        Vector heuristicVect = node.searchChildTag("heuristicvalue");
                        if (heuristicVect == null) {
                            errorMessage = "Node " + name + " has no heuristic value defined";
                            throw new Exception();
                        }
                        double h2 = Double.valueOf(((XMLBlock)heuristicVect.elementAt(0)).getText().trim()).floatValue();
                        Vector indexVect = node.searchChildTag("index");
                        if (indexVect == null) {
                            errorMessage = "Node " + name + " has no index defined";
                            throw new Exception();
                        }
                        int index = Integer.valueOf(((XMLBlock)indexVect.elementAt(0)).getText().trim());
                        SearchNode snode = new SearchNode(this);
                        snode.setLabel(name);
                        snode.setJustLabel(name);
                        snode.setNodeType(type);
                        snode.setNodeAppearance(type);
                        snode.pos = pos;
                        snode.setHeuristics(h2);
                        snode.updateSize();
                        this.addNode(snode);
                        snode.index = index;
                        ++i;
                    }
                    int i2 = 0;
                    while (true) {
                        if (i2 >= allEdges.size()) {
                            heuristic = graph.searchChildTag("heuristic");
                            if (heuristic != null) {
                                heuristicPair = ((XMLBlock)heuristic.elementAt(0)).getProperties();
                                if (heuristicPair != null) break;
                                errorMessage = "Heuristic not set to either automatic or manual";
                                throw new Exception();
                            }
                            break block34;
                        }
                        XMLBlock thisEdge = (XMLBlock)allEdges.elementAt(i2);
                        String startNode = "";
                        String endNode = "";
                        Vector start = thisEdge.searchChildTag("startindex");
                        if (start == null) {
                            errorMessage = "Start node for an edge is not defined";
                            throw new Exception();
                        }
                        Vector end = thisEdge.searchChildTag("endindex");
                        if (end == null) {
                            errorMessage = "End node for an edge is not defined";
                            throw new Exception();
                        }
                        int startIndex = new Integer(((XMLBlock)start.elementAt(0)).getText().trim());
                        int endIndex = new Integer(((XMLBlock)end.elementAt(0)).getText().trim());
                        Vector costVal = thisEdge.searchChildTag("cost");
                        Double costValue = new Double(0.0);
                        if (costVal != null) {
                            costValue = new Double(((XMLBlock)costVal.elementAt(0)).getText().trim());
                        }
                        SearchNode fromNode = null;
                        SearchNode toNode = null;
                        fromNode = (SearchNode)this.nodeFromIndex(startIndex);
                        toNode = (SearchNode)this.nodeFromIndex(endIndex);
                        if (fromNode == null) {
                            errorMessage = "Node " + startIndex + " does not exist!";
                            throw new Exception();
                        }
                        if (toNode == null) {
                            errorMessage = "Node " + endIndex + " does not exist!";
                            throw new Exception();
                        }
                        SearchEdge edge = new SearchEdge(this, (Node)fromNode, (Node)toNode);
                        edge.setCost(costValue);
                        this.addEdge(edge);
                        ++i2;
                    }
                    h = (Pair)heuristicPair.elementAt(0);
                    if (!h.name.equalsIgnoreCase("value")) {
                        errorMessage = "Heuristic value not defined";
                        throw new Exception();
                    }
                    if (h.value.equalsIgnoreCase("manual")) {
                        this.setUseNodeDistance(false);
                        ((SearchCanvas)this.canvas).autoNH(false);
                        break block35;
                    } else {
                        this.setUseNodeDistance(true);
                        ((SearchCanvas)this.canvas).autoNH(true);
                    }
                    break block35;
                }
                this.setUseNodeDistance(true);
                ((SearchCanvas)this.canvas).autoNH(true);
            }
            heuristic = graph.searchChildTag("edgecosts");
            if (heuristic != null) {
                heuristicPair = ((XMLBlock)heuristic.elementAt(0)).getProperties();
                if (heuristicPair == null) {
                    errorMessage = "Edge costs not set to either automatic or manual";
                    throw new Exception();
                }
                h = (Pair)heuristicPair.elementAt(0);
                if (!h.name.equalsIgnoreCase("value")) {
                    errorMessage = "Edge cost value not defined";
                    throw new Exception();
                }
                if (h.value.equalsIgnoreCase("manual")) {
                    this.setUseEdgeLength(true);
                    ((SearchCanvas)this.canvas).autoEC(true);
                } else {
                    this.setUseEdgeLength(true);
                    ((SearchCanvas)this.canvas).autoEC(true);
                }
            } else {
                this.setUseEdgeLength(true);
                ((SearchCanvas)this.canvas).autoEC(true);
            }
            this.setNodes();
            if (this.frontierInfoFrame == null) return errorMessage;
            this.frontierInfoFrame.setGraph(this);
            return errorMessage;
        }
        catch (Exception e) {
            if (errorMessage.length() <= 0) return "Error: " + e.toString();
            return "Error: " + errorMessage;
        }
    }

    public String generateXMLTextRep() {
        String rep = "<?xml version=\"1.0\"\n";
        rep = String.valueOf(rep) + "\n<SEARCH>\n<GRAPH>\n\n";
        rep = String.valueOf(rep) + "<!-- Node Definitions -->\n\n";
        String tmpString1 = "";
        String tmpString2 = "";
        int i = 0;
        while (i < this.numNodes()) {
            SearchNode tmpNode = (SearchNode)this.nodeAt(i);
            tmpString1 = tmpNode.getJustLabel();
            if (tmpString1.equals("")) {
                tmpString1 = new String("Node " + tmpNode.index);
            }
            if (tmpNode.getNodeType() == 0) {
                tmpString2 = new String("REGULAR");
            } else if (tmpNode.getNodeType() == 1) {
                tmpString2 = new String("START");
            } else if (tmpNode.getNodeType() == 2) {
                tmpString2 = new String("GOAL");
            }
            rep = String.valueOf(rep) + "<NODE>\n";
            rep = String.valueOf(rep) + "   <NAME>" + tmpString1 + "</NAME>\n";
            rep = String.valueOf(rep) + "   <INDEX>" + tmpNode.index + "</INDEX>\n";
            rep = String.valueOf(rep) + "   <XPOS>" + tmpNode.pos.x + "</XPOS>\n";
            rep = String.valueOf(rep) + "   <YPOS>" + tmpNode.pos.y + "</YPOS>\n";
            rep = String.valueOf(rep) + "   <TYPE>" + tmpString2 + "</TYPE>\n";
            rep = String.valueOf(rep) + "   <HEURISTICVALUE>" + tmpNode.getHeuristics() + "</HEURISTICVALUE>\n";
            rep = String.valueOf(rep) + "</NODE>\n\n";
            ++i;
        }
        rep = String.valueOf(rep) + "<!-- Edge Definitions -->\n\n";
        int i2 = 0;
        while (i2 < this.numEdges()) {
            SearchEdge edge = (SearchEdge)this.edgeAt(i2);
            rep = String.valueOf(rep) + "<EDGE>\n";
            rep = String.valueOf(rep) + "   <STARTINDEX>" + edge.start.index + "</STARTINDEX>\n";
            rep = String.valueOf(rep) + "   <ENDINDEX>" + edge.end.index + "</ENDINDEX>\n";
            rep = String.valueOf(rep) + "   <COST>" + edge.getCost() + "</COST>\n";
            rep = String.valueOf(rep) + "</EDGE>\n\n";
            ++i2;
        }
        rep = String.valueOf(rep) + "<!-- Heuristic Settings -->\n\n";
        rep = this.getUseNodeDistance() ? String.valueOf(rep) + "<HEURISTIC value=\"AUTOMATIC\"></HEURISTIC>\n" : String.valueOf(rep) + "<HEURISTIC value=\"MANUAL\"></HEURISTIC>\n";
        rep = this.getUseEdgeLength() ? String.valueOf(rep) + "<EDGECOSTS value=\"AUTOMATIC\"></EDGECOSTS>\n" : String.valueOf(rep) + "<EDGECOSTS value=\"MANUAL\"></EDGECOSTS>\n";
        rep = String.valueOf(rep) + "\n\n</GRAPH>\n</SEARCH>\n";
        return rep;
    }

    public String generateTextRep() {
        String outString = new String("");
        String tmpString1 = new String("");
        String tmpString2 = new String("");
        Calendar now = Calendar.getInstance();
        outString = String.valueOf(outString) + "% Auto-generated on " + now.getTime() + "\n\n";
        outString = String.valueOf(outString) + "% Nodes\n";
        outString = String.valueOf(outString) + "% N: index, node_name, x_position, y_position, node_type, node_heuristics;\n";
        int i = 0;
        while (i < this.numNodes()) {
            SearchNode tmpNode = (SearchNode)this.nodeAt(i);
            tmpString1 = tmpNode.getJustLabel();
            if (tmpString1.equals("")) {
                tmpString1 = new String("Node " + tmpNode.index);
            }
            if (tmpNode.getNodeType() == 0) {
                tmpString2 = new String("REGULAR");
            } else if (tmpNode.getNodeType() == 1) {
                tmpString2 = new String("START");
            } else if (tmpNode.getNodeType() == 2) {
                tmpString2 = new String("GOAL");
            }
            outString = String.valueOf(outString) + "N: " + tmpNode.index + ", " + tmpString1 + ", " + tmpNode.pos.x + ", " + tmpNode.pos.y + ", " + tmpString2 + ", " + tmpNode.getHeuristics() + ";\n";
            ++i;
        }
        outString = String.valueOf(outString) + "\n% Edges\n";
        outString = String.valueOf(outString) + "% E: from_node_index, to_node_index, edge_cost;\n";
        int i2 = 0;
        while (i2 < this.numEdges()) {
            SearchEdge edge = (SearchEdge)this.edgeAt(i2);
            outString = String.valueOf(outString) + "E: " + edge.start.index + ", " + edge.end.index + ", " + edge.getCost() + ";\n";
            ++i2;
        }
        outString = String.valueOf(outString) + "\n% Miscellaneous\n";
        outString = String.valueOf(outString) + "% M: predicate, value;\n";
        outString = String.valueOf(outString) + "M: HEURISTICS, ";
        outString = this.getUseNodeDistance() ? String.valueOf(outString) + "AUTOMATIC;\n" : String.valueOf(outString) + "MANUAL;\n";
        outString = String.valueOf(outString) + "M: COSTS, ";
        outString = this.getUseEdgeLength() ? String.valueOf(outString) + "AUTOMATIC;\n" : String.valueOf(outString) + "MANUAL;\n";
        return outString;
    }

    public String updateGraphFromText(String allText) {
        String errorMessage = new String("");
        int p1 = -1;
        int p2 = allText.indexOf("\n");
        int lineCount = 0;
        try {
            while (p2 != -1) {
                String inString = allText.substring(p1 + 1, p2);
                if (inString.trim().length() > 0) {
                    if (inString.trim().charAt(0) != '%' && inString.indexOf(";") == -1) {
                        errorMessage = new String("Missing semicolon");
                        throw new Exception();
                    }
                    errorMessage = this.parseLine(inString.trim());
                    if (errorMessage.length() > 0) {
                        throw new Exception();
                    }
                }
                p1 = p2;
                p2 = allText.indexOf("\n", p1 + 1);
                ++lineCount;
            }
            if (this.frontierInfoFrame != null) {
                this.frontierInfoFrame.setGraph(this);
            }
            this.setNodes();
            ((SearchCanvas)this.canvas).greenify();
            return "OK";
        }
        catch (Exception e) {
            if (errorMessage.length() > 0) {
                return "Error at line " + (lineCount + 1) + " -- " + errorMessage;
            }
            return "Error at line " + (lineCount + 1) + " -- " + e;
        }
    }

    public String updateGraphFromXML(String allText) {
        this.nodes = new Vector(10, 10);
        this.edges = new Vector(10, 10);
        this.selectedNodes = new Vector(10, 10);
        this.selectedEdges = new Vector(10, 10);
        this.scale = 1.0f;
        String errorMessage = new String("");
        XMLTree newTree = new XMLTree();
        newTree.readString(allText);
        errorMessage = this.parseXML(newTree);
        if (errorMessage.length() > 0) {
            return errorMessage;
        }
        if (this.frontierInfoFrame != null) {
            this.frontierInfoFrame.setGraph(this);
        }
        this.setNodes();
        ((SearchCanvas)this.canvas).greenify();
        return "OK";
    }

    public void setAsStartNode(SearchNode node) {
        node.setNodeType(1);
        Integer selectedIndex = new Integer(node.getIndex());
        if (!this.startNodes.contains(selectedIndex)) {
            this.startNodes.addElement(selectedIndex);
            node.setNodeAppearance(1);
        }
        if (this.goalNodes.contains(selectedIndex)) {
            this.goalNodes.removeElement(selectedIndex);
        }
    }

    public void setAsGoalNode(SearchNode node) {
        node.setNodeType(2);
        Integer selectedIndex = new Integer(node.getIndex());
        if (!this.goalNodes.contains(selectedIndex)) {
            this.goalNodes.addElement(selectedIndex);
            node.setNodeAppearance(2);
        }
        if (this.startNodes.contains(selectedIndex)) {
            this.startNodes.removeElement(selectedIndex);
        }
    }

    public void setAsRegularNode(SearchNode node) {
        node.setNodeType(0);
        node.setNodeAppearance(0);
        Integer selectedIndex = new Integer(node.getIndex());
        if (this.goalNodes.contains(selectedIndex)) {
            this.goalNodes.removeElement(selectedIndex);
        }
        if (this.startNodes.contains(selectedIndex)) {
            this.startNodes.removeElement(selectedIndex);
        }
    }

    public void invert() {
        SearchNode child;
        int j;
        SearchNode node;
        int i = 0;
        while (i < this.numNodes()) {
            node = (SearchNode)this.nodeAt(i);
            node.oldNeighbours = new Vector(node.neighbours.size());
            j = 0;
            while (j < node.neighbours.size()) {
                child = (SearchNode)this.nodeAt((Integer)node.neighbours.elementAt(j));
                if (!child.neighbours.contains(new Integer(i))) {
                    node.oldNeighbours.addElement(new Integer(child.index));
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.numNodes()) {
            node = (SearchNode)this.nodeAt(i);
            j = 0;
            while (j < node.oldNeighbours.size()) {
                child = (SearchNode)this.nodeAt((Integer)node.oldNeighbours.elementAt(j));
                SearchEdge newEdge = new SearchEdge(this, (Node)child, (Node)node);
                SearchEdge oldEdge = (SearchEdge)this.getEdge(node.getIndex(), child.getIndex());
                if (oldEdge != null) {
                    newEdge.setCost(oldEdge.getCost());
                }
                this.addEdge(newEdge);
                int k = 0;
                while (k < this.numEdges()) {
                    SearchEdge e = (SearchEdge)this.edgeAt(k);
                    if (e.start == node && e.end == child) {
                        node.removeEdgesOut(e);
                        this.edges.removeElement(e);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        SearchNode[] oldStartNodes = new SearchNode[this.startNodes.size()];
        int i2 = 0;
        while (i2 < this.startNodes.size()) {
            oldStartNodes[i2] = (SearchNode)this.nodeAt((Integer)this.startNodes.elementAt(i2));
            ++i2;
        }
        Vector gNodes = (Vector)this.goalNodes.clone();
        int i3 = 0;
        while (i3 < gNodes.size()) {
            this.setAsStartNode((SearchNode)this.nodeAt((Integer)gNodes.elementAt(i3)));
            ++i3;
        }
        i3 = 0;
        while (i3 < oldStartNodes.length) {
            this.setAsGoalNode(oldStartNodes[i3]);
            ++i3;
        }
        this.updateNodeSize();
        this.setHeuristicsFromDistance(((SearchCanvas)this.canvas).autoNH);
        ((SearchCanvas)this.canvas).resetSearch();
        ((SearchCanvas)this.canvas).greenify();
        this.repaint();
    }
}

