/*
 * Decompiled with CFR 0.152.
 */
package CIspace.search;

import CIspace.graphToolKit.Edge;
import CIspace.graphToolKit.Node;
import CIspace.search.SearchGraph;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Vector;

public class SearchNode
extends Node {
    public static final int REGULAR_NODE = 0;
    public static final int START_NODE = 1;
    public static final int GOAL_NODE = 2;
    public static final int CURRENT_NODE = 3;
    public static final int FRONTIER_NODE = 4;
    public static final int CHILDREN_NODE = 5;
    public static final int NON_CURRENT_NODE = 6;
    protected Vector neighbours = new Vector(5, 2);
    protected Vector oldNeighbours;
    protected int nodeType = 0;
    protected int nodeSearchType = 6;
    protected int currNeighbour;
    protected double heuristics = 0.0;
    protected String searchOrder = "";
    protected boolean drawOrdering = false;
    protected String justLabel = this.getLabel();
    protected double distance = 0.0;
    protected boolean pathFound = false;
    protected boolean heavy;

    public SearchNode(SearchGraph graph) {
        super(graph);
        this.wPad = 5;
        this.hPad = 5;
        this.updateSize();
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(int type) {
        this.nodeType = type;
    }

    public int getNodeSearchType() {
        return this.nodeSearchType;
    }

    public void setNodeSearchType(int type) {
        this.nodeSearchType = type;
    }

    public boolean getPathFound() {
        return this.pathFound;
    }

    public void setPathFound(boolean value) {
        this.pathFound = value;
    }

    public int numNeighbours() {
        return this.neighbours.size();
    }

    public Vector getNeighbours() {
        return this.neighbours;
    }

    public int getFirstNeighbour() {
        if (this.neighbours.size() == 0) {
            return -1;
        }
        this.currNeighbour = 1;
        return (Integer)this.neighbours.firstElement();
    }

    public int getNextNeighbour() {
        if (this.currNeighbour >= this.neighbours.size()) {
            return -1;
        }
        ++this.currNeighbour;
        return (Integer)this.neighbours.elementAt(this.currNeighbour - 1);
    }

    public void setChild(int child) {
        Integer ch = new Integer(child);
        if (!this.neighbours.contains(ch)) {
            this.neighbours.addElement(ch);
        }
    }

    public void clearChild(int child) {
        this.neighbours.removeElement(new Integer(child));
    }

    public void removeEdgesOut(Edge e) {
        this.edgesOut.removeElement(e);
        this.clearChild(e.end.index);
    }

    public void setHeuristics(double h) {
        this.heuristics = h;
        this.label[1] = String.valueOf(this.heuristics) + "";
    }

    public double getHeuristics() {
        return this.heuristics;
    }

    public void setDistance(double d) {
        this.distance = d / (double)this.graph.getScale();
    }

    public double getDistance() {
        return this.distance;
    }

    public void setSearchOrder(int order) {
        this.searchOrder = this.searchOrder == "" ? String.valueOf(this.searchOrder) + order : String.valueOf(this.searchOrder) + ", " + order;
    }

    public void resetSearchOrder() {
        this.searchOrder = "";
    }

    public void setDrawOrdering(boolean value) {
        this.drawOrdering = value;
    }

    public boolean getDrawOrdering() {
        return this.drawOrdering;
    }

    public String getJustLabel() {
        return this.justLabel;
    }

    public void setJustLabel(String l) {
        if (l.equals("")) {
            l = new String("Node " + this.getIndex());
        }
        this.label[0] = this.justLabel = new String(l);
    }

    public void setNodeAppearance(int type) {
        switch (type) {
            case 1: {
                this.shape = 1110;
                this.setHeavy(false);
                break;
            }
            case 2: {
                this.shape = 1112;
                this.setHeavy(false);
                break;
            }
            case 0: {
                this.shape = 1111;
                this.setHeavy(false);
                break;
            }
            case 3: {
                this.setHeavy(true);
                this.color = Color.red;
                break;
            }
            case 4: {
                this.setHeavy(true);
                this.color = Color.green;
                break;
            }
            case 5: {
                this.setHeavy(true);
                this.color = Color.blue;
                break;
            }
            case 6: {
                this.setHeavy(false);
                this.color = Color.black;
                break;
            }
            default: {
                this.shape = 1111;
                this.color = Color.black;
                this.setHeavy(false);
            }
        }
    }

    public void draw(Graphics offscreen, boolean moving) {
        if (this.drawOrdering && this.color.equals(Color.black)) {
            this.xw = 2;
            this.color = Color.gray;
        }
        super.draw(offscreen, moving);
        if (this.drawOrdering && ((SearchGraph)this.graph).getShowNum()) {
            FontMetrics fm = offscreen.getFontMetrics();
            double lx = (double)this.pos.x + (double)this.width / 2.0;
            double ly = (double)this.pos.y - (double)this.height / 2.0 - 2.0;
            offscreen.setColor(Color.red);
            offscreen.drawString(new String(this.searchOrder), (int)lx, (int)(ly -= (double)fm.getDescent()));
        }
    }

    public void updateProperties(String label, double h) {
        if (((SearchGraph)this.graph).getDisplayHeuristics()) {
            this.setJustLabel(label);
            this.setHeuristics(h);
        } else {
            this.setJustLabel(label);
            this.setHeuristics(h);
        }
        this.updateSize();
    }

    public void setHeavy(boolean heavy) {
        this.heavy = heavy;
        this.xw = heavy ? 2 : 0;
    }

    protected int getWidth() {
        if (((SearchGraph)this.graph).getDisplayHeuristics()) {
            FontMetrics fm = this.graph.canvas.getFontMetrics();
            int width1 = fm.stringWidth(this.label[0]) + this.wPad;
            int width2 = fm.stringWidth(this.label[1]) + this.wPad;
            return Math.max(width1, width2);
        }
        return super.getWidth();
    }

    protected int getHeight() {
        if (((SearchGraph)this.graph).getDisplayHeuristics()) {
            return this.graph.canvas.getFontMetrics().getHeight() * 2 + this.hPad;
        }
        return super.getHeight();
    }

    protected void drawLabel(Graphics offscreen) {
        if (((SearchGraph)this.graph).getDisplayHeuristics()) {
            FontMetrics fm = this.graph.canvas.getFontMetrics();
            int width1 = fm.stringWidth(this.label[0]);
            int width2 = fm.stringWidth(this.label[1]);
            if (this.isBold && (this.color.equals(Color.red) || this.color.equals(Color.black))) {
                offscreen.setColor(Color.white);
            } else {
                offscreen.setColor(Color.black);
            }
            int h = fm.getAscent();
            offscreen.drawString(this.label[0], (int)this.pos.x - width1 / 2, (int)this.pos.y - this.height / 5 + h / 2);
            offscreen.drawString(this.label[1], (int)this.pos.x - width2 / 2, (int)this.pos.y + this.height / 5 + h / 2);
        } else {
            super.drawLabel(offscreen);
        }
    }

    public String toString() {
        return "index: " + this.index;
    }
}

