/*
 * Decompiled with CFR 0.152.
 */
package CIspace.search;

import CIspace.search.SearchEdge;
import CIspace.search.SearchGraph;
import java.util.Vector;

public class SearchObject
implements Cloneable {
    protected SearchGraph graph;
    protected Integer[] edgeNodes;
    protected Vector path;
    protected double pathCost;

    public SearchObject() {
        this.graph = null;
        this.edgeNodes = new Integer[2];
        this.edgeNodes[0] = new Integer(-1);
        this.edgeNodes[1] = new Integer(-1);
        this.path = new Vector(5, 2);
        this.pathCost = 0.0;
    }

    public SearchObject(int from, int to, Vector prev, SearchGraph g) {
        this.graph = g;
        this.edgeNodes = new Integer[2];
        this.edgeNodes[0] = new Integer(from);
        this.edgeNodes[1] = new Integer(to);
        SearchEdge currEdge = (SearchEdge)this.graph.getEdge(from, to);
        this.pathCost = currEdge != null ? currEdge.getCost() : 0.0;
        if (prev != null) {
            this.path = (Vector)prev.clone();
            this.path.addElement(this.edgeNodes);
            int i = 0;
            while (i < prev.size()) {
                currEdge = (SearchEdge)this.graph.getEdge(((Integer[])prev.elementAt(i))[0], ((Integer[])prev.elementAt(i))[1]);
                if (currEdge != null) {
                    this.pathCost += currEdge.getCost();
                }
                ++i;
            }
        } else {
            this.path = new Vector(5, 2);
            this.path.addElement(this.edgeNodes);
        }
    }

    public int getFromNode() {
        return this.edgeNodes[0];
    }

    public void setFromNode(int from) {
        this.edgeNodes[0] = new Integer(from);
    }

    public int getToNode() {
        return this.edgeNodes[1];
    }

    public void setToNode(int to) {
        this.edgeNodes[1] = new Integer(to);
    }

    public Vector getPath() {
        return this.path;
    }

    public double getPathCost() {
        return this.pathCost;
    }

    public boolean checkNodeOnPath(int next) {
        int tempIndex;
        int i = 0;
        while (i < this.path.size()) {
            tempIndex = ((Integer[])this.path.elementAt(i))[0];
            if (tempIndex == next) {
                return true;
            }
            ++i;
        }
        tempIndex = ((Integer[])this.path.lastElement())[1];
        return tempIndex == next;
    }

    public Object clone() {
        SearchObject copy = new SearchObject();
        copy.edgeNodes[0] = this.edgeNodes[0];
        copy.edgeNodes[1] = this.edgeNodes[1];
        copy.path = (Vector)this.path.clone();
        return copy;
    }
}

