/*
 * Decompiled with CFR 0.152.
 */
package CIspace.search;

import CIspace.graphToolKit.AboutBox;
import CIspace.graphToolKit.CanvasTab;
import CIspace.graphToolKit.GraphConsts;
import CIspace.graphToolKit.GrooveCanvas;
import CIspace.graphToolKit.GroovePanel;
import CIspace.graphToolKit.HelpMenu;
import CIspace.graphToolKit.LabelCanvas;
import CIspace.graphToolKit.OpenLocationDialog;
import CIspace.graphToolKit.Point;
import CIspace.search.HelpDialog;
import CIspace.search.HelpTextDialog;
import CIspace.search.ProblemDialog;
import CIspace.search.PrologFrame;
import CIspace.search.Search;
import CIspace.search.SearchCanvas;
import CIspace.search.SearchGraph;
import CIspace.search.ShowResultDialog;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;

public class SearchWindow
extends Frame
implements WindowListener,
ItemListener,
ActionListener,
AdjustmentListener {
    public SearchCanvas canvas;
    private CanvasTab tabs;
    private CheckboxGroup createModeGrp;
    private Checkbox[] createModes;
    private Button[] setNodeAs;
    private CheckboxGroup rightModeGrp;
    private Checkbox[] rightModes;
    public CardLayout cardManager;
    private Panel cards;
    private Panel left;
    private Panel right;
    private Panel bottom;
    private Scrollbar hbar;
    private Scrollbar vbar;
    public Applet applet;
    private CheckboxMenuItem largeFont;
    private CheckboxMenuItem mediumFont;
    private CheckboxMenuItem smallFont;
    private CheckboxMenuItem otherFont;
    private CheckboxMenuItem wideLine;
    private CheckboxMenuItem mediumLine;
    private CheckboxMenuItem narrowLine;
    private CheckboxMenuItem showCP;
    private CheckboxMenuItem showMP;
    private String extension;
    private GridBagLayout gbl;
    private GridBagConstraints gbc;
    private TextArea ta;
    private int searchAlgorithm;
    private Button step;
    private Button fineStep;
    private Button autoSearch;
    public Button stopSearch;
    private Button quiz;
    private Button resetSearch;
    private Button invertGraph;
    private CheckboxMenuItem xFast;
    private CheckboxMenuItem fast;
    private CheckboxMenuItem medium;
    private CheckboxMenuItem slow;
    private CheckboxMenuItem depthFirst;
    private CheckboxMenuItem breadthFirst;
    private CheckboxMenuItem lowestCostFirst;
    private CheckboxMenuItem bestFirst;
    private CheckboxMenuItem heuristicDepthFirst;
    private CheckboxMenuItem aStar;
    private CheckboxMenuItem userDefined;
    private CheckboxMenuItem showNodeH;
    private CheckboxMenuItem showEdgeC;
    private CheckboxMenuItem autoNH;
    private CheckboxMenuItem autoEC;
    private CheckboxMenuItem multPath;
    private CheckboxMenuItem loop;
    private CheckboxMenuItem none;
    private Menu algoMenu;
    private Menu pruneMenu;
    private MenuItem resetCosts;
    private Label algoLabel;
    private ShowResultDialog srd;
    private MenuItem mItemStep;
    private MenuItem mItemFineStep;
    private MenuItem mItemShowResult;
    private MenuItem mItemQuiz;
    private MenuItem mItemResetSearch;
    private CheckboxMenuItem showNum;
    private LabelCanvas lCanvas;
    private String filename;

    public SearchWindow(Applet parent) {
        this.applet = parent;
        this.setTitle("Search Applet Version 2.1 --- untitled.txt");
        ((Component)this).setSize(850, 730);
        Color bg = GraphConsts.bg;
        ((Component)this).setBackground(bg);
        this.setForeground(GraphConsts.fg);
        this.addWindowListener(this);
        this.menu();
        this.setLayout(new BorderLayout());
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        this.tabs = new CanvasTab();
        this.tabs.addActionListener(this);
        this.tabs.addTab("Create");
        this.tabs.addTab("Solve");
        this.tabs.selectTab("Create");
        Panel card1 = new Panel();
        card1.setBackground(bg);
        card1.setLayout(this.gbl);
        this.createModeGrp = new CheckboxGroup();
        this.createModes = new Checkbox[6];
        this.createModes[0] = new Checkbox("Create Node", this.createModeGrp, false);
        this.createModes[1] = new Checkbox("Create Edge", this.createModeGrp, false);
        this.createModes[2] = new Checkbox("Select Entity", this.createModeGrp, true);
        this.createModes[3] = new Checkbox("Move Entity", this.createModeGrp, false);
        this.createModes[4] = new Checkbox("Delete Entity", this.createModeGrp, false);
        this.createModes[5] = new Checkbox("Set Properties", this.createModeGrp, false);
        int i = 0;
        while (i < 6) {
            this.createModes[i].addItemListener(this);
            ++i;
        }
        Label setNodeAsL = new Label("Set Selected Node As:");
        this.setNodeAs = new Button[3];
        this.setNodeAs[0] = new Button("Start Node");
        this.setNodeAs[1] = new Button("Goal Node");
        this.setNodeAs[2] = new Button("Regular Node");
        int i2 = 0;
        while (i2 < 3) {
            this.setNodeAs[i2].addActionListener(this);
            ++i2;
        }
        Label blank1 = new Label("");
        this.addComponent(this.createModes[0], card1, 0, 0, 1, 1, 1.0, 0.0);
        this.addComponent(this.createModes[1], card1, 1, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.createModes[2], card1, 2, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.createModes[3], card1, 3, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.createModes[4], card1, 4, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.createModes[5], card1, 5, 0, 1, 1, 0.0, 0.0);
        this.addComponent(blank1, card1, 6, 0, 1, 1, 0.0, 0.0);
        this.addComponent(setNodeAsL, card1, 7, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.setNodeAs[0], card1, 8, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.setNodeAs[1], card1, 9, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.setNodeAs[2], card1, 10, 0, 1, 1, 0.0, 0.0);
        Panel card2 = new Panel();
        card2.setBackground(bg);
        card2.setLayout(this.gbl);
        this.step = new Button("Step");
        this.step.addActionListener(this);
        this.fineStep = new Button("Fine Step");
        this.fineStep.addActionListener(this);
        this.autoSearch = new Button("Auto Search");
        this.autoSearch.addActionListener(this);
        this.stopSearch = new Button("Stop Search");
        this.stopSearch.addActionListener(this);
        this.stopSearch.setEnabled(false);
        this.quiz = new Button("Quiz");
        this.quiz.addActionListener(this);
        this.resetSearch = new Button("Reset Search");
        this.resetSearch.addActionListener(this);
        this.invertGraph = new Button("Invert Graph");
        this.invertGraph.addActionListener(this);
        Panel blank = new Panel();
        Label blank2 = new Label();
        Label algo = new Label(" Algorithm Selected: ");
        this.algoLabel = new Label("     Depth First     ");
        Panel algoPanel = new Panel();
        algoPanel.setLayout(this.gbl);
        this.addComponent(algo, algoPanel, 0, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.algoLabel, algoPanel, 1, 0, 1, 1, 0.0, 0.0);
        this.addComponent(blank, card2, 0, 0, 1, 1, 0.0, 1.0);
        this.addComponent(this.step, card2, 1, 0, 1, 1, 1.0, 0.0);
        this.addComponent(this.fineStep, card2, 2, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.autoSearch, card2, 3, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.stopSearch, card2, 4, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.quiz, card2, 5, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.resetSearch, card2, 6, 0, 1, 1, 0.0, 0.0);
        this.addComponent(blank2, card2, 7, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.invertGraph, card2, 8, 0, 1, 1, 0.0, 0.0);
        this.addComponent(algoPanel, card2, 9, 0, 1, 1, 0.0, 1.0);
        this.cards = new Panel();
        this.cards.setBackground(bg);
        this.cardManager = new CardLayout();
        this.cards.setLayout(this.cardManager);
        this.cards.add("create", card1);
        this.cards.add("solve", card2);
        Panel leftCenter = new Panel();
        leftCenter.setLayout(this.gbl);
        GrooveCanvas west = new GrooveCanvas(4441, bg);
        GrooveCanvas south = new GrooveCanvas(4442, bg);
        GrooveCanvas east = new GrooveCanvas(4443, bg);
        this.addComponent(west, leftCenter, 0, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.cards, leftCenter, 0, 1, 1, 1, 1.0, 1.0);
        this.addComponent(east, leftCenter, 0, 2, 1, 1, 0.0, 0.0);
        this.addComponent(south, leftCenter, 1, 0, 3, 1, 0.0, 0.0);
        Panel leftBottom = new Panel();
        leftBottom.setLayout(this.gbl);
        Button resetLabel = new Button("Reset Edge Labels");
        resetLabel.addActionListener(this);
        Button autoscale = new Button("Autoscale");
        autoscale.addActionListener(this);
        this.rightModeGrp = new CheckboxGroup();
        this.rightModes = new Checkbox[2];
        this.rightModes[0] = new Checkbox("Pan", this.rightModeGrp, false);
        this.rightModes[1] = new Checkbox("Zoom", this.rightModeGrp, true);
        this.rightModes[0].addItemListener(this);
        this.rightModes[1].addItemListener(this);
        this.addComponent(resetLabel, leftBottom, 0, 0, 2, 1, 0.0, 0.0);
        this.addComponent(autoscale, leftBottom, 1, 0, 2, 1, 0.0, 0.0);
        this.addComponent(this.rightModes[0], leftBottom, 2, 0, 1, 1, 1.0, 0.0);
        this.addComponent(this.rightModes[1], leftBottom, 2, 1, 1, 1, 1.0, 0.0);
        GroovePanel groovy = new GroovePanel(bg, leftBottom);
        this.left = new Panel();
        this.left.setLayout(this.gbl);
        this.addComponent(this.tabs, this.left, 0, 0, 1, 1, 1.0, 0.0);
        this.addComponent(leftCenter, this.left, 1, 0, 1, 1, 0.0, 1.0);
        this.addComponent(groovy, this.left, 2, 0, 1, 1, 0.0, 0.0);
        this.right = new Panel();
        this.right.setBackground(bg);
        this.lCanvas = new LabelCanvas();
        this.canvas = new SearchCanvas(this, false);
        this.right.setLayout(this.gbl);
        this.hbar = new Scrollbar(0, 0, 10, 0, 110);
        this.hbar.setBackground(bg);
        this.hbar.setBlockIncrement(10);
        this.hbar.setValue(50);
        this.hbar.addAdjustmentListener(this);
        this.vbar = new Scrollbar(1, 0, 10, 0, 110);
        this.vbar.setBackground(bg);
        this.vbar.setBlockIncrement(10);
        this.vbar.setValue(50);
        this.vbar.addAdjustmentListener(this);
        Panel gray = new Panel();
        gray.setBackground(bg);
        this.addComponent(this.canvas, this.right, 0, 0, 1, 1, 1.0, 1.0);
        this.addComponent(this.vbar, this.right, 0, 1, 1, 2, 0.0, 0.0);
        this.addComponent(this.lCanvas, this.right, 1, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.hbar, this.right, 2, 0, 1, 1, 0.0, 0.0);
        this.addComponent(gray, this.right, 2, 1, 1, 1, 0.0, 0.0);
        this.bottom = new Panel();
        this.bottom.setBackground(bg);
        this.bottom.setLayout(new BorderLayout());
        this.ta = new TextArea("", 3, 100, 1);
        this.ta.setEditable(false);
        this.ta.setBackground(GraphConsts.bg);
        this.ta.setForeground(GraphConsts.fg);
        this.bottom.add("Center", this.ta);
        Panel main = new Panel();
        main.setBackground(bg.darker());
        main.setLayout(new BorderLayout());
        main.add("West", this.left);
        main.add("South", this.bottom);
        main.add("Center", this.right);
        this.setLayout(new BorderLayout());
        this.add("Center", main);
        this.show();
        this.canvas.setGraphics();
        this.canvas.setScrollbars(this.hbar, this.vbar);
        this.extension = ".txt";
        this.canvas.searchMethod = this.searchAlgorithm = 201;
    }

    private void addComponent(Component c, Container p, int row, int column, int width, int height, double wx, double wy) {
        this.gbc.gridx = column;
        this.gbc.gridy = row;
        this.gbc.gridwidth = width;
        this.gbc.gridheight = height;
        this.gbc.weightx = wx;
        this.gbc.weighty = wy;
        this.gbl.setConstraints(c, this.gbc);
        p.add(c);
    }

    private void menu() {
        MenuBar mBar = new MenuBar();
        Menu m = new Menu("File");
        MenuItem mItem = new MenuItem("Create New Graph");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        MenuShortcut shortcut = new MenuShortcut(78);
        mItem.setShortcut(shortcut);
        m.add(mItem);
        mItem = new MenuItem("Load Sample Graph");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        shortcut = new MenuShortcut(76);
        mItem.setShortcut(shortcut);
        m.add(mItem);
        if (this.applet == null) {
            mItem = new MenuItem("Open Graph");
            mItem.setActionCommand(mItem.getLabel());
            mItem.addActionListener(this);
            shortcut = new MenuShortcut(79);
            mItem.setShortcut(shortcut);
            m.add(mItem);
            mItem = new MenuItem("Save Graph");
            mItem.setActionCommand(mItem.getLabel());
            mItem.addActionListener(this);
            shortcut = new MenuShortcut(83);
            mItem.setShortcut(shortcut);
            m.add(mItem);
        }
        mItem = new MenuItem("Open Location");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        m.add(mItem);
        m.addSeparator();
        if (this.applet == null) {
            mItem = new MenuItem("Print");
            mItem.setActionCommand(mItem.getLabel());
            mItem.addActionListener(this);
            shortcut = new MenuShortcut(80);
            mItem.setShortcut(shortcut);
            m.add(mItem);
        }
        mItem = new MenuItem("Quit");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        shortcut = new MenuShortcut(81);
        mItem.setShortcut(shortcut);
        m.add(mItem);
        mBar.add(m);
        m = new Menu("Edit");
        mItem = new MenuItem("View Prolog Code");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        m.add(mItem);
        mItem = new MenuItem("View/Edit Text Representation");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        m.add(mItem);
        mItem = new MenuItem("View/Edit XML Representation");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        m.add(mItem);
        mBar.add(m);
        m = new Menu("Graph Options");
        Menu font = new Menu("Font Size");
        this.largeFont = new CheckboxMenuItem("Large (20 pt)", false);
        this.largeFont.addItemListener(this);
        font.add(this.largeFont);
        this.mediumFont = new CheckboxMenuItem("Medium (12 pt)", true);
        this.mediumFont.addItemListener(this);
        font.add(this.mediumFont);
        this.smallFont = new CheckboxMenuItem("Small (9 pt)", false);
        this.smallFont.addItemListener(this);
        font.add(this.smallFont);
        this.otherFont = new CheckboxMenuItem("others...", false);
        this.otherFont.addItemListener(this);
        font.add(this.otherFont);
        m.add(font);
        Menu line = new Menu("Line Width");
        this.wideLine = new CheckboxMenuItem("Wide (4 pixels)", false);
        this.wideLine.addItemListener(this);
        line.add(this.wideLine);
        this.mediumLine = new CheckboxMenuItem("Medium (2 pixels)", false);
        this.mediumLine.addItemListener(this);
        line.add(this.mediumLine);
        this.narrowLine = new CheckboxMenuItem("Narrow (1 pixels)", true);
        this.narrowLine.addItemListener(this);
        line.add(this.narrowLine);
        m.add(line);
        m.addSeparator();
        this.showCP = new CheckboxMenuItem("Show Control Panel", true);
        this.showCP.addItemListener(this);
        m.add(this.showCP);
        this.showMP = new CheckboxMenuItem("Show Message Panel", true);
        this.showMP.addItemListener(this);
        m.add(this.showMP);
        mBar.add(m);
        m = new Menu("Controls");
        this.mItemStep = new MenuItem("Step");
        this.mItemStep.setActionCommand(this.mItemStep.getLabel());
        this.mItemStep.addActionListener(this);
        shortcut = new MenuShortcut(83, true);
        this.mItemStep.setShortcut(shortcut);
        m.add(this.mItemStep);
        this.mItemFineStep = new MenuItem("Fine Step");
        this.mItemFineStep.setActionCommand(this.mItemFineStep.getLabel());
        this.mItemFineStep.addActionListener(this);
        shortcut = new MenuShortcut(70, true);
        this.mItemFineStep.setShortcut(shortcut);
        m.add(this.mItemFineStep);
        this.mItemShowResult = new MenuItem("Auto Search");
        this.mItemShowResult.setActionCommand(this.mItemShowResult.getLabel());
        this.mItemShowResult.addActionListener(this);
        shortcut = new MenuShortcut(84, true);
        this.mItemShowResult.setShortcut(shortcut);
        m.add(this.mItemShowResult);
        this.mItemQuiz = new MenuItem("Quiz");
        this.mItemQuiz.setActionCommand(this.mItemQuiz.getLabel());
        this.mItemQuiz.addActionListener(this);
        shortcut = new MenuShortcut(81, true);
        this.mItemQuiz.setShortcut(shortcut);
        m.add(this.mItemQuiz);
        this.mItemResetSearch = new MenuItem("Reset Search");
        this.mItemResetSearch.setActionCommand(this.mItemResetSearch.getLabel());
        this.mItemResetSearch.addActionListener(this);
        shortcut = new MenuShortcut(82, true);
        this.mItemResetSearch.setShortcut(shortcut);
        m.add(this.mItemResetSearch);
        this.enableCtrlMenu(false);
        mBar.add(m);
        this.algoMenu = new Menu("Search Algorithms");
        this.depthFirst = new CheckboxMenuItem("Depth First", true);
        this.depthFirst.addItemListener(this);
        this.algoMenu.add(this.depthFirst);
        this.breadthFirst = new CheckboxMenuItem("Breadth First");
        this.breadthFirst.addItemListener(this);
        this.algoMenu.add(this.breadthFirst);
        this.lowestCostFirst = new CheckboxMenuItem("Lowest Cost First");
        this.lowestCostFirst.addItemListener(this);
        this.algoMenu.add(this.lowestCostFirst);
        this.bestFirst = new CheckboxMenuItem("Best First");
        this.bestFirst.addItemListener(this);
        this.algoMenu.add(this.bestFirst);
        this.heuristicDepthFirst = new CheckboxMenuItem("Heuristic Depth First");
        this.heuristicDepthFirst.addItemListener(this);
        this.algoMenu.add(this.heuristicDepthFirst);
        this.aStar = new CheckboxMenuItem("A*");
        this.aStar.addItemListener(this);
        this.algoMenu.add(this.aStar);
        this.userDefined = new CheckboxMenuItem("User Defined");
        this.userDefined.addItemListener(this);
        this.algoMenu.add(this.userDefined);
        mBar.add(this.algoMenu);
        m = new Menu("Search Options");
        this.showNodeH = new CheckboxMenuItem("Show Node Heuristics");
        this.showNodeH.addItemListener(this);
        m.add(this.showNodeH);
        this.showEdgeC = new CheckboxMenuItem("Show Edge Costs");
        this.showEdgeC.addItemListener(this);
        m.add(this.showEdgeC);
        this.autoNH = new CheckboxMenuItem("Automatic Node Heuristics", true);
        this.autoNH.addItemListener(this);
        m.add(this.autoNH);
        this.autoEC = new CheckboxMenuItem("Automatic Edge Costs", true);
        this.autoEC.addItemListener(this);
        m.add(this.autoEC);
        this.resetCosts = new MenuItem("Reset Costs and Heuristics");
        this.resetCosts.setActionCommand(this.resetCosts.getLabel());
        this.resetCosts.addActionListener(this);
        m.add(this.resetCosts);
        mItem = new MenuItem("Show Frontier Info");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        m.add(mItem);
        this.showNum = new CheckboxMenuItem("Show Node Numbers");
        this.showNum.addItemListener(this);
        m.add(this.showNum);
        m.addSeparator();
        Menu speed = new Menu("Auto Search Speed");
        this.xFast = new CheckboxMenuItem("Very Fast (0 s)", false);
        this.xFast.addItemListener(this);
        speed.add(this.xFast);
        this.fast = new CheckboxMenuItem("Fast (0.1 s)", true);
        this.fast.addItemListener(this);
        speed.add(this.fast);
        this.medium = new CheckboxMenuItem("Medium (0.5 s)", false);
        this.medium.addItemListener(this);
        speed.add(this.medium);
        this.slow = new CheckboxMenuItem("Slow (1 s)", false);
        this.slow.addItemListener(this);
        speed.add(this.slow);
        m.add(speed);
        mItem = new MenuItem("Auto Search Options");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        m.add(mItem);
        mBar.add(m);
        this.pruneMenu = new Menu("Pruning");
        this.multPath = new CheckboxMenuItem("Multiple-Path Pruning");
        this.multPath.addItemListener(this);
        this.pruneMenu.add(this.multPath);
        this.loop = new CheckboxMenuItem("Loop Detection");
        this.loop.addItemListener(this);
        this.pruneMenu.add(this.loop);
        this.none = new CheckboxMenuItem("None", true);
        this.none.addItemListener(this);
        this.pruneMenu.add(this.none);
        mBar.add(this.pruneMenu);
        mBar.setHelpMenu(new HelpMenu(this.applet, "search", this));
        this.setMenuBar(mBar);
    }

    public void menuEnabled(boolean enable) {
        this.algoMenu.setEnabled(enable);
        this.autoNH.setEnabled(enable);
        this.autoEC.setEnabled(enable);
        this.pruneMenu.setEnabled(enable);
    }

    public void enableCtrlMenu(boolean enable) {
        this.mItemStep.setEnabled(enable);
        this.mItemFineStep.setEnabled(enable);
        this.mItemShowResult.setEnabled(enable);
        this.mItemQuiz.setEnabled(enable);
        this.mItemResetSearch.setEnabled(enable);
    }

    public void newTab(String str) {
        if (str == "Create") {
            this.cardManager.show(this.cards, "create");
            this.menuEnabled(true);
            this.resetCosts.setEnabled(true);
            this.step.setEnabled(true);
            this.fineStep.setEnabled(true);
            this.quiz.setEnabled(true);
            this.autoSearch.setEnabled(true);
            this.enableCtrlMenu(false);
            this.canvas.setMode(2220);
            this.setPromptLabel("");
        } else if (str == "Solve") {
            this.cardManager.show(this.cards, "solve");
            this.resetCosts.setEnabled(false);
            this.enableCtrlMenu(true);
            this.canvas.setMode(2221);
            this.canvas.greenify();
            if (this.userDefined.getState()) {
                this.startUserDefinedSearch();
            }
            this.setPromptLabel("");
        }
    }

    public void showMessage(String title, String msg) {
        this.canvas.showMessage(title, msg);
    }

    public void setPromptLabel(String str) {
        this.lCanvas.setText(str);
    }

    public String getPromptLabel() {
        return this.lCanvas.getText();
    }

    public void blinkLabel() {
        this.lCanvas.blink();
    }

    public void setPathArea(String p) {
        if (p.equals("")) {
            this.ta.setText("");
        } else {
            this.ta.setText(" Current Path: \n" + p);
        }
    }

    public void autoNH(boolean on) {
        this.autoNH.setState(on);
    }

    public void autoEC(boolean on) {
        this.autoEC.setState(on);
    }

    public void resetSearch() {
        this.menuEnabled(true);
        this.ta.setText("");
        this.step.setEnabled(true);
        this.fineStep.setEnabled(true);
        this.quiz.setEnabled(true);
        this.canvas.resetSearch();
        this.canvas.greenify();
        this.setPromptLabel("");
        if (this.userDefined.getState()) {
            this.step.setEnabled(false);
            this.fineStep.setEnabled(false);
            this.quiz.setEnabled(false);
            this.canvas.doSearch(209, 102);
        } else {
            this.autoSearch.setEnabled(true);
        }
    }

    private void startUserDefinedSearch() {
        this.step.setEnabled(false);
        this.fineStep.setEnabled(false);
        this.quiz.setEnabled(false);
        this.autoSearch.setEnabled(false);
        this.canvas.doSearch(this.getAlgorithm(), 102);
        this.setPromptLabel("Click on a node on the frontier");
    }

    public void userDefinedStep() {
        this.menuEnabled(false);
    }

    public void load(String dir, String filename) {
        try {
            this.filename = filename;
            if (this.applet != null) {
                URL url = new URL(this.applet.getCodeBase() + dir + filename);
                InputStream iStream = url.openStream();
                this.load(new BufferedReader(new InputStreamReader(iStream)));
            } else {
                this.load(new BufferedReader(new FileReader(String.valueOf(dir) + filename)));
            }
        }
        catch (Exception e) {
            filename = null;
            this.showMessage("Error", e.toString());
        }
    }

    public void load(BufferedReader in) {
        try {
            String all = "";
            String errMsg = "";
            String line = in.readLine();
            while (line != null) {
                all = String.valueOf(all) + line + "\n";
                line = in.readLine();
            }
            in.close();
            errMsg = this.filename.endsWith(".xml") ? this.canvas.parseXML(all) : this.canvas.parse(all);
            if (!errMsg.equals("OK")) {
                this.showMessage("Error", errMsg);
            }
            this.setTitle("Search Applet Version 2.1 --- " + this.filename);
            this.menuEnabled(true);
            this.ta.setText("");
            this.step.setEnabled(true);
            this.fineStep.setEnabled(true);
            this.quiz.setEnabled(true);
            this.autoSearch.setEnabled(true);
            this.tabs.selectTab("Solve");
            this.tabs.repaint();
            this.newTab("Solve");
        }
        catch (Exception e) {
            this.showMessage("Error", e.toString());
        }
    }

    public void save(String dir, String filename) {
        if (!filename.endsWith(".xml")) {
            filename = String.valueOf(filename) + ".xml";
        }
        try {
            FileOutputStream fos = new FileOutputStream(String.valueOf(dir) + filename);
            PrintWriter out = new PrintWriter(fos);
            out.println(((SearchGraph)this.canvas.graph).generateXMLTextRep());
            out.close();
            this.setTitle("Search Applet Version  --- " + filename);
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (this.canvas.pause) {
            return;
        }
        String arg = e.getItem().toString();
        if (arg.equals("Depth First") || arg.equals("Breadth First") || arg.equals("Lowest Cost First") || arg.equals("Best First") || arg.equals("Heuristic Depth First") || arg.equals("A*") || arg.equals("User Defined")) {
            this.chooseAlgorithm(arg);
        } else if (arg.equals("Create Node")) {
            this.canvas.setSubmode(3330);
            this.setPromptLabel("Click the canvas to create a node.");
        } else if (arg.equals("Create Edge")) {
            this.canvas.setSubmode(3331);
            this.setPromptLabel("Click on a node to start creating an edge.  Click on another node to finish.\nYou can cancel edge creation by clicking on the canvas.");
        } else if (arg.equals("Select Entity")) {
            this.canvas.setSubmode(3332);
            this.setPromptLabel("Click on an entity to select or drag the mouse to select multiple entities.");
        } else if (arg.equals("Move Entity")) {
            this.canvas.setSubmode(3332);
            this.setPromptLabel("Click and drag an entity to move it around.");
        } else if (arg.equals("Delete Entity")) {
            this.canvas.setSubmode(3333);
            this.setPromptLabel("Click on an entity to delete.");
        } else if (arg.equals("Set Properties")) {
            this.canvas.setSubmode(3334);
            this.setPromptLabel("Click on an entity to set its properties.");
        } else if (arg.equals("Pan")) {
            this.canvas.setRMode(4440);
            this.setPromptLabel("Drag the right mouse button to pan the graph.");
        } else if (arg.equals("Zoom")) {
            this.canvas.setRMode(4441);
            this.setPromptLabel("Drag the right mouse button up to zoom in and down to zoom out.");
        } else if (arg.equals("Very Fast (0 s)")) {
            Search.dt = 0;
            this.xFast.setState(true);
            this.fast.setState(false);
            this.medium.setState(false);
            this.slow.setState(false);
        } else if (arg.equals("Fast (0.1 s)")) {
            Search.dt = 100;
            this.xFast.setState(false);
            this.fast.setState(true);
            this.medium.setState(false);
            this.slow.setState(false);
        } else if (arg.equals("Medium (0.5 s)")) {
            Search.dt = 500;
            this.xFast.setState(false);
            this.fast.setState(false);
            this.medium.setState(true);
            this.slow.setState(false);
        } else if (arg.equals("Slow (1 s)")) {
            Search.dt = 1000;
            this.xFast.setState(false);
            this.fast.setState(false);
            this.medium.setState(false);
            this.slow.setState(true);
        } else if (arg.equals("Large (20 pt)")) {
            this.canvas.changeFont(20);
            this.largeFont.setState(true);
            this.mediumFont.setState(false);
            this.smallFont.setState(false);
            this.otherFont.setState(false);
        } else if (arg.equals("Medium (12 pt)")) {
            this.canvas.changeFont(12);
            this.largeFont.setState(false);
            this.mediumFont.setState(true);
            this.smallFont.setState(false);
            this.otherFont.setState(false);
        } else if (arg.equals("Small (9 pt)")) {
            this.canvas.changeFont(9);
            this.largeFont.setState(false);
            this.mediumFont.setState(false);
            this.smallFont.setState(true);
            this.otherFont.setState(false);
        } else if (arg.equals("others...")) {
            this.canvas.changeFont(-1);
            this.largeFont.setState(false);
            this.mediumFont.setState(false);
            this.smallFont.setState(false);
            this.otherFont.setState(true);
        } else if (arg.equals("Wide (4 pixels)")) {
            this.canvas.graph.setLineWidth(4);
            this.canvas.changeLineWidth();
            this.wideLine.setState(true);
            this.mediumLine.setState(false);
            this.narrowLine.setState(false);
        } else if (arg.equals("Medium (2 pixels)")) {
            this.canvas.graph.setLineWidth(2);
            this.canvas.changeLineWidth();
            this.wideLine.setState(false);
            this.mediumLine.setState(true);
            this.narrowLine.setState(false);
        } else if (arg.equals("Narrow (1 pixels)")) {
            this.canvas.graph.setLineWidth(1);
            this.canvas.changeLineWidth();
            this.wideLine.setState(false);
            this.mediumLine.setState(false);
            this.narrowLine.setState(true);
        } else if (arg.equals("Automatic Node Heuristics")) {
            ((SearchGraph)this.canvas.graph).setUseNodeDistance(this.autoNH.getState());
            this.canvas.autoNH = this.autoNH.getState();
            ((SearchGraph)this.canvas.graph).setHeuristicsFromDistance(this.autoNH.getState());
            this.canvas.repaint();
        } else if (arg.equals("Automatic Edge Costs")) {
            ((SearchGraph)this.canvas.graph).setUseEdgeLength(this.autoEC.getState());
            this.canvas.autoEC = this.autoEC.getState();
            ((SearchGraph)this.canvas.graph).updateNodeSize();
            this.canvas.repaint();
        } else if (arg.equals("Multiple-Path Pruning")) {
            ((SearchGraph)this.canvas.graph).setPruning(301);
            this.canvas.resetSearch();
            if (this.tabs.getSelectedTab().equals("Solve")) {
                this.canvas.greenify();
                if (this.userDefined.getState()) {
                    this.canvas.doSearch(209, 102);
                }
            }
            this.multPath.setState(true);
            this.loop.setState(false);
            this.none.setState(false);
        } else if (arg.equals("Loop Detection")) {
            ((SearchGraph)this.canvas.graph).setPruning(302);
            this.canvas.resetSearch();
            if (this.tabs.getSelectedTab().equals("Solve")) {
                this.canvas.greenify();
                if (this.userDefined.getState()) {
                    this.canvas.doSearch(209, 102);
                }
            }
            this.multPath.setState(false);
            this.loop.setState(true);
            this.none.setState(false);
        } else if (arg.equals("None")) {
            ((SearchGraph)this.canvas.graph).setPruning(303);
            this.canvas.resetSearch();
            if (this.tabs.getSelectedTab().equals("Solve")) {
                this.canvas.greenify();
                if (this.userDefined.getState()) {
                    this.canvas.doSearch(209, 102);
                }
            }
            this.multPath.setState(false);
            this.loop.setState(false);
            this.none.setState(true);
        } else if (arg.equals("Show Node Heuristics")) {
            ((SearchGraph)this.canvas.graph).setDisplayHeuristics(this.showNodeH.getState());
            this.canvas.updateGraph();
        } else if (arg.equals("Show Edge Costs")) {
            ((SearchGraph)this.canvas.graph).setDisplayCost(this.showEdgeC.getState());
        } else if (arg.equals("Show Node Numbers")) {
            ((SearchGraph)this.canvas.graph).setShowNum(this.showNum.getState());
        } else if (arg.equals("Show Control Panel")) {
            this.left.setVisible(this.showCP.getState());
            this.validate();
        } else if (arg.equals("Show Message Panel")) {
            this.bottom.setVisible(this.showMP.getState());
            this.lCanvas.setVisible(this.showMP.getState());
            this.validate();
        }
    }

    private void chooseAlgorithm(String arg) {
        this.depthFirst.setState(false);
        this.breadthFirst.setState(false);
        this.lowestCostFirst.setState(false);
        this.bestFirst.setState(false);
        this.heuristicDepthFirst.setState(false);
        this.aStar.setState(false);
        this.userDefined.setState(false);
        if (arg.equals("Depth First")) {
            this.algoLabel.setText("     Depth First     ");
            this.depthFirst.setState(true);
        } else if (arg.equals("Breadth First")) {
            this.algoLabel.setText("    Breadth First    ");
            this.breadthFirst.setState(true);
        } else if (arg.equals("Lowest Cost First")) {
            this.algoLabel.setText("  Lowest Cost First  ");
            this.lowestCostFirst.setState(true);
        } else if (arg.equals("Best First")) {
            this.algoLabel.setText("      Best First     ");
            this.bestFirst.setState(true);
        } else if (arg.equals("Heuristic Depth First")) {
            this.algoLabel.setText("Heuristic Depth First");
            this.heuristicDepthFirst.setState(true);
        } else if (arg.equals("A*")) {
            this.algoLabel.setText("          A*         ");
            this.aStar.setState(true);
        } else if (arg.equals("User Defined")) {
            this.algoLabel.setText("     User Defined    ");
            this.userDefined.setState(true);
        }
        this.canvas.resetSearch();
        if (this.tabs.getSelectedTab().equals("Solve")) {
            this.canvas.greenify();
        }
        if (!this.userDefined.getState()) {
            this.step.setEnabled(true);
            this.fineStep.setEnabled(true);
            this.autoSearch.setEnabled(true);
            this.quiz.setEnabled(true);
        } else if (this.tabs.getSelectedTab().equals("Solve")) {
            this.startUserDefinedSearch();
        }
        this.canvas.searchMethod = this.searchAlgorithm = this.getAlgorithm();
    }

    private int getAlgorithm() {
        if (this.depthFirst.getState()) {
            return 201;
        }
        if (this.breadthFirst.getState()) {
            return 202;
        }
        if (this.lowestCostFirst.getState()) {
            return 203;
        }
        if (this.bestFirst.getState()) {
            return 204;
        }
        if (this.heuristicDepthFirst.getState()) {
            return 205;
        }
        if (this.aStar.getState()) {
            return 206;
        }
        if (this.userDefined.getState()) {
            return 209;
        }
        return -1;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.canvas.pause) {
            return;
        }
        String arg = e.getActionCommand();
        if (arg.equals("canvasTab")) {
            this.newTab(this.tabs.getSelectedTab());
        } else if (arg.equals("Step")) {
            this.menuEnabled(false);
            this.quiz.setEnabled(false);
            this.canvas.doSearch(this.getAlgorithm(), 102);
        } else if (arg.equals("Fine Step")) {
            this.menuEnabled(false);
            this.quiz.setEnabled(false);
            this.canvas.doSearch(this.getAlgorithm(), 103);
        } else if (arg.equals("Auto Search")) {
            this.menuEnabled(false);
            this.quiz.setEnabled(false);
            this.canvas.doSearch(this.getAlgorithm(), 101);
            this.stopSearch.setEnabled(true);
        } else if (arg.equals("Stop Search")) {
            ((SearchGraph)this.canvas.graph).stopAutoSearch();
            this.stopSearch.setEnabled(false);
        } else if (arg.equals("Quiz")) {
            this.menuEnabled(false);
            this.step.setEnabled(false);
            this.fineStep.setEnabled(false);
            this.autoSearch.setEnabled(false);
            this.canvas.doSearch(this.getAlgorithm(), 104);
        } else if (arg.equals("Reset Search")) {
            this.resetSearch();
        } else if (arg.equals("Autoscale")) {
            this.canvas.autoscale();
        } else if (arg.equals("Reset Edge Labels")) {
            this.canvas.resetLabels();
        } else if (arg.equals("Start Node")) {
            ((SearchGraph)this.canvas.graph).setNodeAs(11);
        } else if (arg.equals("Goal Node")) {
            ((SearchGraph)this.canvas.graph).setNodeAs(15);
        } else if (arg.equals("Regular Node")) {
            ((SearchGraph)this.canvas.graph).setNodeAs(16);
        } else if (arg.equals("Create New Graph")) {
            this.setTitle("Search Applet Version 2.1 --- untitled.xml");
            this.menuEnabled(true);
            this.ta.setText("");
            this.step.setEnabled(true);
            this.fineStep.setEnabled(true);
            this.quiz.setEnabled(true);
            this.autoSearch.setEnabled(true);
            this.canvas.reset();
            this.tabs.selectTab("Create");
            this.tabs.repaint();
            this.newTab("Create");
        } else if (arg.equals("Open Graph")) {
            this.setCursor(GraphConsts.WAIT_CURSOR);
            FileDialog load = new FileDialog((Frame)this, "Open Search Graph", 0);
            load.setDirectory("saves");
            ((Component)load).setLocation(0, 0);
            load.show();
            this.setCursor(GraphConsts.DEFAULT_CURSOR);
            String filename = load.getFile();
            String dir = load.getDirectory();
            if (filename == null) {
                return;
            }
            this.load(dir, filename);
        } else if (arg.equals("Open Location")) {
            this.setCursor(GraphConsts.WAIT_CURSOR);
            OpenLocationDialog old = new OpenLocationDialog(this);
            this.setCursor(GraphConsts.DEFAULT_CURSOR);
            String urlString = old.url;
            if (urlString != null) {
                this.filename = urlString.substring(urlString.lastIndexOf("/") + 1);
                try {
                    URL url = new URL(urlString);
                    InputStream iStream = url.openStream();
                    this.load(new BufferedReader(new InputStreamReader(iStream)));
                }
                catch (Exception exc) {
                    this.showMessage("Error", exc.toString());
                }
            }
        } else if (arg.equals("Save Graph")) {
            this.setCursor(GraphConsts.WAIT_CURSOR);
            FileDialog save = new FileDialog((Frame)this, "Save Search Graph", 1);
            save.setDirectory("saves");
            String fname = this.getTitle().substring(this.getTitle().indexOf("--- ") + 4);
            if (fname.indexOf(".") > 0) {
                save.setFile(String.valueOf(fname.substring(0, fname.indexOf("."))) + ".xml");
            } else {
                save.setFile(String.valueOf(fname) + ".xml");
            }
            ((Component)save).setLocation(0, 0);
            save.show();
            this.setCursor(GraphConsts.DEFAULT_CURSOR);
            String filename = save.getFile();
            String dir = save.getDirectory();
            if (filename == null) {
                return;
            }
            this.save(dir, filename);
        } else if (arg.equals("Load Sample Graph")) {
            this.setCursor(GraphConsts.WAIT_CURSOR);
            ProblemDialog pDialog = new ProblemDialog(this);
            this.setCursor(GraphConsts.DEFAULT_CURSOR);
        } else if (arg.equals("Print")) {
            this.canvas.print(this.getTitle().substring(this.getTitle().indexOf("--- ") + 4));
        } else if (arg.equals("Quit")) {
            ((Component)this).setVisible(false);
            this.dispose();
        } else if (arg.equals("View Prolog Code")) {
            this.setCursor(GraphConsts.WAIT_CURSOR);
            PrologFrame pf = new PrologFrame((SearchGraph)this.canvas.graph);
        } else if (arg.equals("View/Edit Text Representation")) {
            this.setCursor(GraphConsts.WAIT_CURSOR);
            this.canvas.textRep();
            this.setCursor(GraphConsts.DEFAULT_CURSOR);
        } else if (arg.equals("View/Edit XML Representation")) {
            this.setCursor(GraphConsts.WAIT_CURSOR);
            this.canvas.XMLRep();
            this.setCursor(GraphConsts.DEFAULT_CURSOR);
        } else if (arg.equals("Show Frontier Info")) {
            this.setCursor(GraphConsts.WAIT_CURSOR);
            ((SearchGraph)this.canvas.graph).showFrontierInfoFrame();
            this.setCursor(GraphConsts.DEFAULT_CURSOR);
        } else if (arg.equals("Auto Search Options")) {
            this.setCursor(GraphConsts.WAIT_CURSOR);
            if (this.srd == null) {
                this.srd = new ShowResultDialog(this);
            }
            this.srd.open();
            this.setCursor(GraphConsts.DEFAULT_CURSOR);
        } else if (arg.equals("Reset Costs and Heuristics")) {
            this.canvas.resetCosts();
        } else if (arg.equals("Help")) {
            this.setCursor(GraphConsts.WAIT_CURSOR);
            HelpTextDialog dialog = new HelpTextDialog();
            this.setCursor(GraphConsts.DEFAULT_CURSOR);
        } else if (arg.equals("Key for Nodes/Edges")) {
            this.setCursor(GraphConsts.WAIT_CURSOR);
            HelpDialog dialog = new HelpDialog(this);
            this.setCursor(GraphConsts.DEFAULT_CURSOR);
        } else if (arg.equals("About CISpace")) {
            this.setCursor(GraphConsts.WAIT_CURSOR);
            if (this.applet != null) {
                AboutBox about = new AboutBox((Frame)this, "http://www.cs.ubc.ca/labs/lci/CIspace/project/CIspace/graphToolKit/about.txt");
            } else {
                AboutBox about = new AboutBox((Frame)this, "CIspace/graphToolKit/about.txt");
            }
            this.setCursor(GraphConsts.DEFAULT_CURSOR);
        } else if (arg.equals("About this Applet")) {
            this.setCursor(GraphConsts.WAIT_CURSOR);
            if (this.applet != null) {
                AboutBox about = new AboutBox((Frame)this, "http://www.cs.ubc.ca/labs/lci/CIspace/project/CIspace/search/about.txt");
            } else {
                AboutBox aboutBox = new AboutBox((Frame)this, "CIspace/search/about.txt");
            }
            this.setCursor(GraphConsts.DEFAULT_CURSOR);
        } else if (arg.equals("Invert Graph")) {
            ((SearchGraph)this.canvas.graph).invert();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        int width = this.canvas.getSize().width;
        int x0 = (int)((double)(width * (this.hbar.getValue() - 50)) / 100.0);
        int height = this.canvas.getSize().height;
        int y0 = (int)((double)(width * (this.vbar.getValue() - 50)) / 100.0);
        this.canvas.offset(-x0, -y0);
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        if (this.applet == null) {
            System.exit(0);
        }
    }

    public void windowClosing(WindowEvent e) {
        ((Component)this).setVisible(false);
        this.canvas.disposeWindows();
        this.dispose();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    private void centerWindow() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        Point centerPosition = new Point(screenSize.width / 2, screenSize.height / 2);
        Dimension windowSize = this.getSize();
        int widthOffset = windowSize.width / 2;
        int heightOffset = windowSize.height / 2;
        ((Component)this).setLocation((int)centerPosition.x - widthOffset, (int)centerPosition.y - heightOffset);
    }

    public static void main(String[] args) {
        SearchWindow window = new SearchWindow(null);
    }
}

