/*
 * Decompiled with CFR 0.152.
 */
package CIspace.search;

import CIspace.search.InlineApplet;
import CIspace.search.SearchGraph;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class ShowResultFrame
extends Frame
implements ActionListener,
WindowListener,
TextListener {
    private Button cancel_button;
    private Button ok_button;
    private InlineApplet window;
    private Label label1;
    private Label label2;
    private Choice choiceYesNo;
    private TextField textNumSteps;
    private Label labelError;
    public boolean cancelled;

    public ShowResultFrame(InlineApplet w) {
        super("Show Result Options");
        this.window = w;
        this.addWindowListener(this);
        this.label1 = new Label("Stop searching when goal node found?");
        this.label2 = new Label("Maximum number of steps:");
        this.choiceYesNo = new Choice();
        this.choiceYesNo.addItem("Yes");
        this.choiceYesNo.addItem("No");
        this.textNumSteps = new TextField("50");
        this.textNumSteps.addTextListener(this);
        Panel p1 = new Panel();
        p1.add(this.label1);
        p1.add(this.choiceYesNo);
        Panel p2 = new Panel();
        p2.add(this.label2);
        p2.add(this.textNumSteps);
        Panel top = new Panel();
        top.setLayout(new GridLayout(2, 1));
        top.add(p1);
        top.add(p2);
        Panel middle = new Panel();
        this.ok_button = new Button("OK");
        this.ok_button.addActionListener(this);
        this.cancel_button = new Button("Cancel");
        this.cancel_button.addActionListener(this);
        middle.add(this.ok_button);
        middle.add(this.cancel_button);
        this.labelError = new Label("");
        Panel bottom = new Panel();
        bottom.add(this.labelError);
        this.add("North", top);
        this.add("Center", middle);
        this.add("South", this.labelError);
        this.pack();
    }

    public void open() {
        this.cancelled = false;
        this.centerWindow();
        this.show();
    }

    private void centerWindow() {
        int parentX = this.window.getLocationOnScreen().x;
        int parentY = this.window.getLocationOnScreen().y;
        int parentW = this.window.getSize().width;
        int parentH = this.window.getSize().height;
        int w = this.getSize().width;
        int h = this.getSize().height;
        ((Component)this).setLocation(parentX + parentW / 2 - w / 2, parentY + parentH / 2 - h / 2);
    }

    public boolean setValues() {
        try {
            Integer num = Integer.valueOf(this.textNumSteps.getText());
            ((SearchGraph)this.window.canvas.graph).setMaxNumSteps(num);
            if (this.choiceYesNo.getSelectedItem().equals("Yes")) {
                ((SearchGraph)this.window.canvas.graph).setStopAtGoal(true);
            } else {
                ((SearchGraph)this.window.canvas.graph).setStopAtGoal(false);
            }
            return true;
        }
        catch (NumberFormatException e) {
            this.labelError.setText("Error: Number of Steps must be a positive integer!");
            return false;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Cancel")) {
            this.cancelled = true;
            ((Component)this).setVisible(false);
        } else if (e.getActionCommand().equals("OK") && this.setValues()) {
            ((Component)this).setVisible(false);
        }
    }

    public void textValueChanged(TextEvent e) {
        if (e.getSource().equals(this.textNumSteps)) {
            this.labelError.setText("");
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

