/*
 * Decompiled with CFR 0.152.
 */
package CIspace.search;

import CIspace.search.SearchCanvas;
import java.awt.Button;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

class TextFrame
extends Frame
implements ActionListener,
WindowListener {
    private Button cancelButton;
    private Button updateGraphButton;
    private TextArea display;
    private SearchCanvas canvas;
    private boolean isXML;

    public TextFrame(SearchCanvas canvas, String textRep, boolean isXML) {
        super("Text Representation of the graph");
        this.addWindowListener(this);
        this.canvas = canvas;
        this.isXML = isXML;
        Panel p = new Panel();
        this.updateGraphButton = new Button("Update Graph");
        this.updateGraphButton.addActionListener(this);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        p.add(this.updateGraphButton);
        p.add(this.cancelButton);
        this.display = new TextArea(40, 80);
        this.display.setFont(new Font("Monospaced", 0, 12));
        this.display.setText(textRep);
        this.add("Center", this.display);
        this.add("South", p);
        this.pack();
        this.show();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        } else if (e.getActionCommand().equals("Update Graph")) {
            if (this.isXML) {
                if (this.canvas.updateGraphFromXML(this.display.getText())) {
                    this.dispose();
                }
            } else if (this.canvas.updateGraphFromText(this.display.getText())) {
                this.dispose();
            }
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

