/*
 * Decompiled with CFR 0.152.
 */
package CIspace.search;

import CIspace.search.Search;
import CIspace.search.SearchGraph;
import CIspace.search.SearchNode;
import CIspace.search.SearchObject;
import java.util.Vector;

public class UserDefinedSearch
extends Search {
    protected int counter;
    protected int currIndex;
    protected boolean done;

    public UserDefinedSearch() {
        this.counter = 0;
        this.done = false;
    }

    public UserDefinedSearch(SearchGraph sg) {
        this.graph = sg;
        this.startNodeIndex = (Vector)sg.getStartNodeIndex().clone();
        this.goalNodeIndex = (Vector)sg.getGoalNodeIndex().clone();
        this.searchRate = sg.getSearchRate();
        this.pruning = sg.getPruning();
        this.frontier = new Vector(5, 2);
        if (this.startNodeIndex.size() > 0) {
            Vector<SearchObject> startNodes = new Vector<SearchObject>(5, 2);
            int i = 0;
            while (i < this.startNodeIndex.size()) {
                int nextStart = (Integer)this.startNodeIndex.elementAt(i);
                startNodes.addElement(new SearchObject(-1, nextStart, null, this.graph));
                ++i;
            }
            this.mergeWithFrontier(startNodes);
        }
        this.pruneNodes();
        this.paintNodes(this.frontier, 4);
        this.counter = 0;
        this.done = false;
        this.currIndex = -1;
        this.nodesVisited = new Vector(5, 2);
    }

    public void step() {
        if (this.done) {
            this.graph.setPromptLabel("Search Completed");
            this.completed();
            return;
        }
        SearchNode currNode = this.selectedNode;
        if (currNode == null) {
            return;
        }
        boolean found = false;
        int foundIndex = 0;
        while (!found && foundIndex < this.frontier.size()) {
            SearchObject so = (SearchObject)this.frontier.elementAt(foundIndex);
            if (so.getToNode() == currNode.getIndex()) {
                found = true;
            }
            ++foundIndex;
        }
        if (!found) {
            this.graph.setPromptLabel("Select a node from the frontier");
            return;
        }
        this.resetPrevious(this.currObject);
        if (this.currIndex != -1) {
            ((SearchNode)this.graph.nodeFromIndex(this.currIndex)).setNodeAppearance(6);
            if (this.currObject != null) {
                this.paintPath(this.currObject, false);
            }
        }
        --foundIndex;
        if (this.currIndex != -1) {
            this.currObject = (SearchObject)((SearchObject)this.frontier.elementAt(foundIndex)).clone();
        }
        this.currIndex = currNode.getIndex();
        ++this.counter;
        currNode.setSearchOrder(this.counter);
        currNode.setDrawOrdering(true);
        currNode.setPathFound(true);
        this.nodesVisited.addElement(new Integer(this.currIndex));
        Vector children = (Vector)((SearchNode)this.graph.nodeFromIndex(this.currIndex)).getNeighbours().clone();
        int numNeigh = children != null ? children.size() : 0;
        this.neighbours = new Vector(5, 2);
        int i = 0;
        while (i < numNeigh) {
            int nextNeigh = (Integer)children.firstElement();
            SearchNode tmpNode = (SearchNode)this.graph.nodeFromIndex(nextNeigh);
            tmpNode.setNodeAppearance(5);
            boolean condition = false;
            if (this.pruning == 303) {
                condition = true;
            } else if (this.pruning == 301) {
                condition = true;
            } else if (!(this.pruning != 302 || this.currObject != null && this.currObject.checkNodeOnPath(nextNeigh))) {
                condition = true;
            }
            if (condition) {
                if (this.currObject != null) {
                    this.neighbours.addElement(new SearchObject(this.currIndex, nextNeigh, this.currObject.getPath(), this.graph));
                } else {
                    this.neighbours.addElement(new SearchObject(this.currIndex, nextNeigh, null, this.graph));
                }
            } else {
                tmpNode.setNodeAppearance(6);
            }
            children.removeElementAt(0);
            ++i;
        }
        if (found && foundIndex >= 0 && foundIndex < this.frontier.size()) {
            this.frontier.removeElementAt(foundIndex);
        }
        this.paintNodes(this.frontier, 4);
        if (this.neighbours.size() > 0) {
            this.mergeWithFrontier(this.neighbours);
        }
        this.pruneNodes();
        currNode.setNodeAppearance(3);
        if (this.currObject != null) {
            this.paintPath(this.currObject, true);
        }
        this.checkGoal(this.currIndex);
        if (this.frontier.size() == 0) {
            this.done = true;
        }
    }

    protected void mergeWithFrontier(Vector ch) {
        int i = ch.size() - 1;
        while (i >= 0) {
            SearchObject next = (SearchObject)ch.lastElement();
            this.frontier.insertElementAt(next, 0);
            ch.removeElementAt(i);
            --i;
        }
    }
}

