/*
 * Decompiled with CFR 0.152.
 */
package AIspace.search;

import AIspace.XMLReader.Pair;
import AIspace.XMLReader.XMLBlock;
import AIspace.XMLReader.XMLParseException;
import AIspace.XMLReader.XMLTree;
import AIspace.graphToolKit.Graph;
import AIspace.graphToolKit.elements.Edge;
import AIspace.graphToolKit.elements.Entity;
import AIspace.graphToolKit.elements.Node;
import AIspace.graphToolKit.elements.Point;
import AIspace.search.FrontierInfo;
import AIspace.search.InlineSearchApplet;
import AIspace.search.SearchCanvas;
import AIspace.search.SearchWindow;
import AIspace.search.elements.SearchEdge;
import AIspace.search.elements.SearchNode;
import AIspace.search.searchTypes.AStar;
import AIspace.search.searchTypes.BestFirst;
import AIspace.search.searchTypes.BranchAndBound;
import AIspace.search.searchTypes.BreadthFirst;
import AIspace.search.searchTypes.DepthFirst;
import AIspace.search.searchTypes.HeuristicDepthFirst;
import AIspace.search.searchTypes.LowestCostFirst;
import AIspace.search.searchTypes.Search;
import AIspace.search.searchTypes.UserDefinedSearch;
import java.awt.Container;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;

public class SearchGraph
extends Graph {
    public ArrayList<SearchNode> startNodes = new ArrayList(5);
    public ArrayList<SearchNode> goalNodes = new ArrayList(5);
    private int searchRate = 102;
    private int pruning = 303;
    public Search search;
    private Container window;
    private FrontierInfo frontierInfo;
    public boolean stepInit = false;
    private int maxNumSteps = 500;
    private boolean stopAtGoal = true;
    private boolean showNum = false;
    protected boolean useNodeDistance = false;
    protected boolean useEdgeLength = false;
    public static final int C_SET_START = 11;
    public static final int C_SET_GOAL = 15;
    public static final int C_SET_REGULAR = 16;
    protected int sortType = 400;
    private String shortDescription;
    private String detailedDescription;

    public SearchGraph(SearchCanvas canvas, Container w) {
        super(canvas);
        this.window = w;
    }

    public Search getSearchObject() {
        return this.search;
    }

    public int getMaxNumSteps() {
        return this.maxNumSteps;
    }

    public void setMaxNumSteps(int num) {
        this.maxNumSteps = num;
    }

    public boolean getStopAtGoal() {
        return this.stopAtGoal;
    }

    public void setStopAtGoal(boolean bool) {
        this.stopAtGoal = bool;
    }

    public boolean getShowNum() {
        return this.showNum;
    }

    public void setShowNum(boolean bool) {
        this.showNum = bool;
    }

    public void setPathArea(String s) {
        ((SearchCanvas)this.canvas).setPathArea(s);
    }

    public void setUseNodeDistance(boolean bool) {
        this.useNodeDistance = bool;
    }

    public boolean getUseNodeDistance() {
        return this.useNodeDistance;
    }

    public void setUseEdgeLength(boolean bool) {
        this.useEdgeLength = bool;
    }

    public boolean getUseEdgeLength() {
        return this.useEdgeLength;
    }

    public String getShortDesc() {
        return this.shortDescription;
    }

    public void setShortDesc(String description) {
        this.shortDescription = description;
        if (description.trim().equals("") || description == null) {
            this.shortDescription = "";
        }
    }

    public String getDetailedDesc() {
        return this.detailedDescription;
    }

    public void setDetailedDesc(String description) {
        this.detailedDescription = description;
        if (description.trim().equals("") || description == null) {
            this.detailedDescription = "";
        }
    }

    public void sendToBack(Edge edge) {
        this.edges.remove(edge);
        this.edges.add(0, edge);
    }

    public void createFrontierInfo() {
        if (this.frontierInfo == null) {
            this.frontierInfo = new FrontierInfo(this.window);
        }
        if (this.stepInit) {
            this.frontierInfo.clear();
            int i = 0;
            while (i < this.startNodes.size()) {
                SearchNode node = this.startNodes.get(i);
                node.setNodeAppearance(4);
                node.setNodeSearchType(4);
                ++i;
            }
            this.frontierInfo.showInitFrontier();
            this.stepInit = false;
        }
    }

    public FrontierInfo getFrontierInfo() {
        return this.frontierInfo;
    }

    public ArrayList<SearchNode> getStartNodes() {
        return this.startNodes;
    }

    public ArrayList<SearchNode> getGoalNodes() {
        return this.goalNodes;
    }

    public int getSearchRate() {
        return this.searchRate;
    }

    public void setSearchRate(int rate) {
        this.searchRate = rate;
    }

    public int getPruning() {
        return this.pruning;
    }

    public void setPruning(int p) {
        this.pruning = p;
    }

    public void stopAutoSearch() {
        if (this.search != null) {
            this.search.stopAutoSearch();
        }
    }

    public void updateEdgeLabels(boolean isShown) {
        int i = 0;
        while (i < this.numEdges()) {
            SearchEdge e = (SearchEdge)this.edges.get(i);
            e.setDisplayCost(isShown);
            ++i;
        }
    }

    public void setHeuristicsFromDistance() {
        for (SearchNode tmpNode : this.nodes) {
            double minDist = 99999.9;
            if (this.goalNodes.size() > 0) {
                int j = 0;
                while (j < this.goalNodes.size()) {
                    SearchNode currGoalNode = this.goalNodes.get(j);
                    double dx = currGoalNode.pos.x - tmpNode.pos.x;
                    double dy = currGoalNode.pos.y - tmpNode.pos.y;
                    double currDist = Math.sqrt(dx * dx + dy * dy);
                    if (currDist < minDist) {
                        minDist = currDist;
                    }
                    ++j;
                }
                tmpNode.setDistance(minDist);
            } else {
                tmpNode.setDistance(0.0);
            }
            tmpNode.setHeuristics((double)Math.round(tmpNode.getDistance()) / 10.0);
            tmpNode.updateSize();
        }
    }

    public void setNodes() {
        this.startNodes = new ArrayList(5);
        this.goalNodes = new ArrayList(5);
        for (SearchNode curNode : this.nodes) {
            if (curNode.getNodeType() == 1 && !this.startNodes.contains(curNode)) {
                this.startNodes.add(curNode);
                continue;
            }
            if (curNode.getNodeType() != 2 || this.goalNodes.contains(curNode)) continue;
            this.goalNodes.add(curNode);
        }
    }

    public void doSearch(int searchAlgorithm, int rate) {
        this.stepInit = false;
        this.setSearchRate(rate);
        if (searchAlgorithm != 209) {
            this.setPromptLabel("Click on 'Reset Search' to start search over or step again.");
        }
        if (this.startNodes.size() > 0) {
            if (this.search == null) {
                switch (searchAlgorithm) {
                    case 201: {
                        this.search = new DepthFirst(this, this.sortType);
                        break;
                    }
                    case 202: {
                        this.search = new BreadthFirst(this, this.sortType);
                        break;
                    }
                    case 203: {
                        this.search = new LowestCostFirst(this, this.sortType);
                        break;
                    }
                    case 204: {
                        this.search = new BestFirst(this, this.sortType);
                        break;
                    }
                    case 205: {
                        this.search = new HeuristicDepthFirst(this, this.sortType);
                        break;
                    }
                    case 206: {
                        this.search = new AStar(this, this.sortType);
                        break;
                    }
                    case 207: {
                        this.search = new BranchAndBound(this, this.sortType);
                        break;
                    }
                    case 209: {
                        this.search = new UserDefinedSearch(this, this.sortType);
                        break;
                    }
                    default: {
                        this.setPromptLabel("Error in search algorithm");
                    }
                }
                if (this.canvas.inline) {
                    this.search.setShowAnswers(((InlineSearchApplet)this.window).isShowingAnswers());
                } else {
                    this.search.setShowAnswers(((SearchWindow)this.window).isShowingAnswers());
                }
                if (this.search.getSearchRate() == 101) {
                    this.search.step();
                }
            } else {
                if (this.search.getSearchRate() == 104) {
                    this.setPromptLabel("Click on a node on the frontier. The frontier nodes are green.");
                }
                this.search.setSearchRate(rate);
                this.search.step();
            }
            if ((this.search.getSearchRate() != 104 || this.search.getShowAnswers()) && this.frontierInfo != null) {
                this.frontierInfo.setFrontier(false);
            }
        } else {
            this.setPromptLabel("You must select a Start Node first");
            ((SearchCanvas)this.canvas).setIsAutoSearchingOptions(false);
        }
    }

    public void resetSearch() {
        if (this.search != null) {
            this.search.reset();
        }
        this.search = null;
        this.stepInit = false;
        for (SearchNode curNode : this.nodes) {
            curNode.setSearchOrderDisplayed(false);
            curNode.resetSearchOrder();
            curNode.setPathFound(false);
            curNode.setNodeAppearance(6);
        }
        Iterator<Edge> edgeItr = this.getEdges();
        while (edgeItr.hasNext()) {
            ((SearchEdge)edgeItr.next()).setAppearance(0);
        }
        if (this.frontierInfo != null) {
            this.frontierInfo.clear();
        }
    }

    public String parse(String file) {
        int p1 = -1;
        int p2 = file.indexOf("\n");
        int lineCount = 0;
        this.clearGraph();
        this.setScale(1.0f);
        try {
            while (p2 != -1) {
                String inString = file.substring(p1 + 1, p2).trim();
                if (inString.length() > 0) {
                    if (inString.charAt(0) != '%' && inString.indexOf(";") == -1) {
                        throw new Exception("Missing semicolon");
                    }
                    String parseMessage = this.parseLine(inString.trim());
                    if (parseMessage.length() > 0) {
                        throw new Exception(parseMessage);
                    }
                }
                p1 = p2;
                p2 = file.indexOf("\n", p1 + 1);
                ++lineCount;
            }
            this.setNodes();
            if (this.frontierInfo != null) {
                this.frontierInfo.setGraph(this);
            }
            return "OK";
        }
        catch (IOException ie) {
            return "Error at line " + (lineCount + 1) + " -- " + ie.toString();
        }
        catch (Exception e) {
            return "Error at line " + (lineCount + 1) + " -- " + e.getMessage();
        }
    }

    public String parseLine(String inString) {
        String errorMessage = "";
        if ((inString = inString.trim()).charAt(0) == 'N') {
            int p1 = inString.indexOf(",");
            int p2 = inString.indexOf(",", p1 + 1);
            String name = inString.substring(p1 + 1, p2).trim();
            p1 = p2;
            p2 = inString.indexOf(",", p1 + 1);
            Point pos = new Point();
            pos.x = Float.parseFloat(inString.substring(p1 + 1, p2).trim());
            p1 = p2;
            p2 = inString.indexOf(",", p1 + 1);
            pos.y = Float.parseFloat(inString.substring(p1 + 1, p2).trim());
            p1 = p2;
            p2 = inString.indexOf(",", p1 + 1);
            String stringType = inString.substring(p1 + 1, p2).trim();
            int type = 0;
            if (stringType.equals("GOAL")) {
                type = 2;
            } else if (stringType.equals("START")) {
                type = 1;
            }
            p1 = p2;
            p2 = inString.indexOf(";");
            Double h = new Double(inString.substring(p1 + 1, p2).trim());
            p1 = inString.indexOf(":");
            p2 = inString.indexOf(",");
            int index = Integer.parseInt(inString.substring(p1 + 1, p2).trim());
            SearchNode node = new SearchNode(this);
            node.setLabel(name);
            node.setPredicateLabel(name);
            node.setNodeType(type);
            node.setNodeAppearance(type);
            node.pos = pos;
            node.setHeuristics(h);
            node.updateSize();
            this.addNode(node);
            node.index = index;
        } else if (inString.charAt(0) == 'E') {
            int p1 = inString.indexOf(":");
            int p2 = inString.indexOf(",");
            int from = Integer.parseInt(inString.substring(p1 + 1, p2).trim());
            p1 = p2;
            p2 = inString.indexOf(",", p1 + 1);
            int to = Integer.parseInt(inString.substring(p1 + 1, p2).trim());
            p1 = p2;
            p2 = inString.indexOf(";", p1 + 1);
            double cost = Double.parseDouble(inString.substring(p1 + 1, p2).trim());
            if (!this.validNodeIndex(from)) {
                errorMessage = "Error: Node " + from + " does not exist!";
            } else if (!this.validNodeIndex(to)) {
                errorMessage = "Error: Node " + to + " does not exist!";
            } else {
                SearchEdge edge = new SearchEdge(this, this.nodeFromIndex(from), this.nodeFromIndex(to));
                edge.setCost(cost);
                this.addEdge(edge);
            }
        } else if (inString.charAt(0) == 'M') {
            int p1 = inString.indexOf(":");
            int p2 = inString.indexOf(",");
            String name = inString.substring(p1 + 1, p2).trim();
            p1 = p2;
            p2 = inString.indexOf(";", p1 + 1);
            String type = inString.substring(p1 + 1, p2).trim();
            if (name.equals("HEURISTICS")) {
                if (type.equals("AUTOMATIC")) {
                    this.setUseNodeDistance(true);
                } else if (type.equals("MANUAL")) {
                    this.setUseNodeDistance(false);
                } else {
                    errorMessage = new String("\"HEURISTICS\" must be set to either \"AUTOMATIC\" or \"MANUAL\"");
                }
            } else if (name.equals("COSTS")) {
                if (!type.equals("AUTOMATIC")) {
                    if (type.equals("MANUAL")) {
                        this.setUseEdgeLength(false);
                    } else {
                        errorMessage = new String("\"COSTS\" must be set to either \"AUTOMATIC\" or \"MANUAL\"");
                    }
                }
            } else {
                errorMessage = new String("miscellaneous items must be either \"HEURISTICS\" or \"COST\"");
            }
        } else if (inString.charAt(0) != '%' && inString.charAt(0) != '\n') {
            errorMessage = new String("Invalid format");
        }
        return errorMessage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String parseXML(XMLTree tree) {
        String errorMessage = "";
        try {
            Pair h;
            ArrayList<Pair> heuristicPair;
            XMLBlock graph = tree.findNetworkTree("graph");
            if (graph == null) {
                errorMessage = "No graph defined in XML";
                throw new Exception();
            }
            XMLBlock desc = tree.findNetworkTree("description");
            ArrayList<Object> sdescs = new ArrayList();
            ArrayList<Object> ldescs = new ArrayList();
            if (desc == null) {
                this.setShortDesc("");
                this.setDetailedDesc("");
            } else {
                sdescs = desc.searchChildTag("short");
                ldescs = desc.searchChildTag("detailed");
                if (sdescs == null || sdescs.size() == 0) {
                    this.setShortDesc("");
                } else {
                    this.setShortDesc(((XMLBlock)sdescs.get(0)).getText());
                }
                if (ldescs == null || ldescs.size() == 0) {
                    this.setDetailedDesc("");
                } else {
                    this.setDetailedDesc(((XMLBlock)ldescs.get(0)).getText());
                }
            }
            ArrayList<XMLBlock> allNodes = graph.searchChildTag("node");
            if (allNodes == null) {
                errorMessage = "No nodes defined";
                throw new Exception();
            }
            int i = 0;
            while (i < allNodes.size()) {
                XMLBlock node = allNodes.get(i);
                ArrayList<XMLBlock> nameVect = node.searchChildTag("name");
                if (nameVect == null) {
                    errorMessage = "Name not defined for a node";
                    throw new Exception();
                }
                String name = nameVect.get(0).getText().trim();
                ArrayList<XMLBlock> xpos = node.searchChildTag("xpos");
                ArrayList<XMLBlock> ypos = node.searchChildTag("ypos");
                if (xpos == null) {
                    errorMessage = "Node " + name + " has no x-position defined";
                    throw new Exception();
                }
                if (ypos == null) {
                    errorMessage = "Node " + name + " has no y-position defined";
                    throw new Exception();
                }
                Point pos = new Point(Float.parseFloat(xpos.get(0).getText().trim()), Float.parseFloat(ypos.get(0).getText().trim()));
                ArrayList<XMLBlock> typeVect = node.searchChildTag("type");
                if (typeVect == null) {
                    errorMessage = "Node " + name + " has no type defined";
                    throw new Exception();
                }
                String stringType = typeVect.get(0).getText().trim();
                int type = 0;
                if (stringType.equals("GOAL")) {
                    type = 2;
                } else if (stringType.equals("START")) {
                    type = 1;
                }
                ArrayList<XMLBlock> heuristicVect = node.searchChildTag("heuristicvalue");
                if (heuristicVect == null) {
                    errorMessage = "Node " + name + " has no heuristic value defined";
                    throw new Exception();
                }
                double heuristicVal = Double.parseDouble(heuristicVect.get(0).getText().trim());
                ArrayList<XMLBlock> indexVect = node.searchChildTag("index");
                if (indexVect == null) {
                    errorMessage = "Node " + name + " has no index defined";
                    throw new Exception();
                }
                int index = Integer.parseInt(indexVect.get(0).getText().trim());
                SearchNode snode = new SearchNode(this);
                snode.setLabel(name);
                snode.setPredicateLabel(name);
                snode.setNodeType(type);
                snode.setNodeAppearance(type);
                snode.pos = pos;
                snode.setHeuristics(heuristicVal);
                snode.updateSize();
                this.addNode(snode);
                snode.index = index;
                ++i;
            }
            ArrayList<XMLBlock> allEdges = graph.searchChildTag("edge");
            if (allEdges == null) {
                allEdges = new ArrayList();
            }
            int i2 = 0;
            while (i2 < allEdges.size()) {
                XMLBlock thisEdge = allEdges.get(i2);
                ArrayList<XMLBlock> start = thisEdge.searchChildTag("startindex");
                if (start == null) {
                    errorMessage = "Start node for an edge is not defined";
                    throw new Exception();
                }
                ArrayList<XMLBlock> end = thisEdge.searchChildTag("endindex");
                if (end == null) {
                    errorMessage = "End node for an edge is not defined";
                    throw new Exception();
                }
                int startIndex = new Integer(start.get(0).getText().trim());
                int endIndex = new Integer(end.get(0).getText().trim());
                ArrayList<XMLBlock> costVal = thisEdge.searchChildTag("cost");
                double costValue = 0.0;
                if (costVal != null) {
                    costValue = Double.parseDouble(costVal.get(0).getText().trim());
                }
                SearchNode fromNode = (SearchNode)this.nodeFromIndex(startIndex);
                SearchNode toNode = (SearchNode)this.nodeFromIndex(endIndex);
                if (fromNode == null) {
                    errorMessage = "Node " + startIndex + " does not exist!";
                    throw new Exception();
                }
                if (toNode == null) {
                    errorMessage = "Node " + endIndex + " does not exist!";
                    throw new Exception();
                }
                SearchEdge edge = new SearchEdge(this, (Node)fromNode, (Node)toNode);
                edge.setCost(costValue);
                this.addEdge(edge);
                ++i2;
            }
            ArrayList<XMLBlock> heuristic = graph.searchChildTag("heuristic");
            if (heuristic != null) {
                heuristicPair = heuristic.get(0).getProperties();
                if (heuristicPair == null) {
                    errorMessage = "Heuristic not set to either automatic or manual";
                    throw new Exception();
                }
                h = heuristicPair.get(0);
                if (!h.name.equalsIgnoreCase("value")) {
                    errorMessage = "Heuristic value not defined";
                    throw new Exception();
                }
                this.setUseNodeDistance(!h.value.equalsIgnoreCase("manual"));
            } else {
                this.setUseNodeDistance(true);
            }
            heuristic = graph.searchChildTag("edgecosts");
            if (heuristic != null) {
                heuristicPair = heuristic.get(0).getProperties();
                if (heuristicPair == null) {
                    errorMessage = "Edge costs not set to either automatic or manual";
                    throw new Exception();
                }
                h = heuristicPair.get(0);
                if (!h.name.equalsIgnoreCase("value")) {
                    errorMessage = "Edge cost value not defined";
                    throw new Exception();
                }
                this.setUseEdgeLength(!h.value.equalsIgnoreCase("manual"));
            } else {
                this.setUseEdgeLength(false);
            }
            this.setNodes();
            if (this.frontierInfo == null) return errorMessage;
            this.frontierInfo.setGraph(this);
            return errorMessage;
        }
        catch (Exception e) {
            if (errorMessage.length() <= 0) return "Error: " + e.toString();
            return "Error: " + errorMessage;
        }
    }

    public String generateXMLTextRep() {
        StringBuffer text = new StringBuffer();
        text.append("<?xml version=\"1.0\" ?>\n\n<SEARCH>\n\t<GRAPH>");
        text.append("\n\t\t<DESCRIPTION>\n\t\t\t<SHORT>").append(this.getShortDesc()).append("</SHORT>");
        text.append("\n\t\t\t<DETAILED>").append(this.getDetailedDesc()).append("</DETAILED>\n\t\t</DESCRIPTION>\n");
        for (SearchNode curNode : this.nodes) {
            text.append("\n\t\t<!-- Node Definitions -->\n\n");
            text.append("\t\t<NODE>\n\t\t\t<NAME>");
            text.append(curNode.getPredicateLabel());
            text.append("</NAME>\n\t\t\t<INDEX>").append(curNode.getIndex());
            text.append("</INDEX>\n\t\t\t<XPOS>").append(curNode.pos.x);
            text.append("</XPOS>\n\t\t\t<YPOS>").append(curNode.pos.y);
            text.append("</YPOS>\n\t\t\t<TYPE>");
            switch (curNode.getNodeType()) {
                case 1: {
                    text.append("START");
                    break;
                }
                case 2: {
                    text.append("GOAL");
                    break;
                }
                default: {
                    text.append("REGULAR");
                }
            }
            text.append("</TYPE>\n\t\t\t<HEURISTICVALUE>").append(curNode.getHeuristics());
            text.append("</HEURISTICVALUE>\n\t\t</NODE>\n");
        }
        text.append("\n\t\t<!-- Edge Definitions -->\n\n");
        for (SearchEdge curEdge : this.edges) {
            text.append("\t\t<EDGE>\n\t\t\t<STARTINDEX>").append(curEdge.getStartNode().getIndex());
            text.append("</STARTINDEX>\n\t\t\t<ENDINDEX>").append(curEdge.getEndNode().getIndex());
            text.append("</ENDINDEX>\n\t\t\t<COST>").append(curEdge.getCost());
            text.append("</COST>\n\t\t</EDGE>\n");
        }
        text.append("\n\t\t<!-- Heuristic Settings -->\n\n");
        text.append("\t\t<HEURISTIC value=\"");
        if (this.getUseNodeDistance()) {
            text.append("AUTOMATIC");
        } else {
            text.append("MANUAL");
        }
        text.append("\"></HEURISTIC>\n");
        text.append("\t\t<EDGECOSTS value=\"");
        if (this.getUseEdgeLength()) {
            text.append("AUTOMATIC");
        } else {
            text.append("MANUAL");
        }
        text.append("\"></EDGECOSTS>\n");
        text.append("\n\t</GRAPH>\n</SEARCH>");
        return text.toString();
    }

    public String generateTextRep() {
        Calendar now = Calendar.getInstance();
        StringBuffer text = new StringBuffer("% Auto-generated on " + now.getTime() + "\n\n");
        text.append("% Nodes\n% N: index, node_name, x_position, y_position, node_type, node_heuristics;\n");
        for (SearchNode curNode : this.nodes) {
            text.append("N: ").append(curNode.getIndex()).append(", ");
            text.append(curNode.getPredicateLabel());
            text.append(", ").append(curNode.pos.x).append(", ").append(curNode.pos.y).append(", ");
            switch (curNode.getNodeType()) {
                case 1: {
                    text.append("START");
                    break;
                }
                case 2: {
                    text.append("GOAL");
                    break;
                }
                default: {
                    text.append("REGULAR");
                }
            }
            text.append(", ").append(curNode.getHeuristics()).append(";\n");
        }
        text.append("\n% Edges\n% E: from_node_index, to_node_index, edge_cost;\n");
        for (SearchEdge curEdge : this.edges) {
            text.append("E: ").append(curEdge.getStartNode().getIndex()).append(", ");
            text.append(curEdge.getEndNode().getIndex()).append(", ").append(curEdge.getCost()).append(";\n");
        }
        text.append("\n% Miscellaneous\n% M: predicate, value;\nM: HEURISTICS, ");
        if (this.getUseNodeDistance()) {
            text.append("AUTOMATIC;\n");
        } else {
            text.append("MANUAL;\n");
        }
        text.append("M: COSTS, ");
        if (this.getUseEdgeLength()) {
            text.append("AUTOMATIC;\n");
        } else {
            text.append("MANUAL;\n");
        }
        return text.toString();
    }

    public String generatePrologTextRep() {
        Calendar now = Calendar.getInstance();
        StringBuffer text = new StringBuffer("% Auto-generated on ").append(now.getTime()).append("\n \n");
        text.append("% is_start(N) is true if N is a start node.\n");
        for (SearchNode curNode : this.nodes) {
            if (curNode.getNodeType() != 1) continue;
            text.append("is_start(");
            if (curNode.getPredicateLabel().equals("")) {
                text.append("'Anonymous ").append(curNode.getIndex()).append("'");
            } else {
                text.append("'").append(curNode.getPredicateLabel()).append("'");
            }
            text.append(").\n");
        }
        text.append("\n% is_goal(N) is true if N is a goal node.\n");
        for (SearchNode curNode : this.nodes) {
            if (curNode.getNodeType() != 2) continue;
            text.append("is_goal(");
            if (curNode.getPredicateLabel().equals("")) {
                text.append("'Anonymous ").append(curNode.getIndex()).append("'");
            } else {
                text.append("'").append(curNode.getPredicateLabel()).append("'");
            }
            text.append(").\n");
        }
        text.append("\n% neighbors(N1, [arc(N2, C2), arc(N3, C3), ...]) is true if there \n% is a directed edge from N1 to N2, N3, ... with cost C2, C3, ..., respectively.\n");
        for (SearchNode curNode : this.nodes) {
            text.append("neighbours('");
            if (curNode.getPredicateLabel().equals("")) {
                text.append("Anonymous ").append(curNode.getIndex());
            } else {
                text.append(curNode.getPredicateLabel());
            }
            text.append("', [");
            int nextNeigh = curNode.getFirstNeighbour();
            while (nextNeigh != -1) {
                SearchNode curNeigh = (SearchNode)this.nodeFromIndex(nextNeigh);
                SearchEdge edge = (SearchEdge)this.getEdge(curNode.getIndex(), curNeigh.getIndex());
                text.append("arc('");
                if (curNeigh.getPredicateLabel().equals("")) {
                    text.append("Anonymous ").append(curNeigh.getIndex());
                } else {
                    text.append(curNeigh.getPredicateLabel());
                }
                text.append("', ").append(edge.getCost()).append(")");
                nextNeigh = curNode.getNextNeighbour();
                if (nextNeigh == -1) continue;
                text.append(", ");
            }
            text.append("]).\n");
        }
        text.append("\n% heuristics(N, H) is true is node N has heuristics value H.\n");
        for (SearchNode curNode : this.nodes) {
            text.append("heuristics('");
            if (curNode.getPredicateLabel().equals("")) {
                text.append("Anonymous ").append(curNode.getIndex());
            } else {
                text.append(curNode.getPredicateLabel());
            }
            text.append("', ").append(curNode.getHeuristics()).append(").\n");
        }
        return text.toString();
    }

    public Container getWindow() {
        return this.window;
    }

    public String updateGraphFromText(String allText) {
        this.clearGraph();
        this.setScale(1.0f);
        int p1 = -1;
        int p2 = allText.indexOf("\n");
        int lineCount = 0;
        try {
            while (p2 != -1) {
                String inString = allText.substring(p1 + 1, p2).trim();
                if (inString.length() > 0) {
                    if (inString.trim().charAt(0) != '%' && inString.indexOf(";") == -1) {
                        throw new Exception("Missing semicolon");
                    }
                    String parseMessage = this.parseLine(inString);
                    if (parseMessage.length() > 0) {
                        throw new Exception(parseMessage);
                    }
                }
                p1 = p2;
                p2 = allText.indexOf("\n", p1 + 1);
                ++lineCount;
            }
            if (this.frontierInfo != null) {
                this.frontierInfo.setGraph(this);
            }
            this.setNodes();
            if (this.canvas.getMode() == 2221) {
                ((SearchCanvas)this.canvas).greenify();
            }
            return "OK";
        }
        catch (IOException ie) {
            return "Error at line " + (lineCount + 1) + " -- " + ie.toString();
        }
        catch (Exception e) {
            return "Error at line " + (lineCount + 1) + " -- " + e.getMessage();
        }
    }

    public String updateGraphFromXML(String allText) {
        this.clearGraph();
        this.setScale(1.0f);
        XMLTree newTree = new XMLTree();
        try {
            newTree.readString(allText);
        }
        catch (XMLParseException e) {
            return e.getLocalizedMessage();
        }
        String errorMessage = this.parseXML(newTree);
        if (errorMessage.length() > 0) {
            return errorMessage;
        }
        if (this.frontierInfo != null) {
            this.frontierInfo.setGraph(this);
        }
        this.setNodes();
        if (this.canvas.getMode() == 2221) {
            ((SearchCanvas)this.canvas).greenify();
        }
        return "OK";
    }

    public void setAsStartNode(SearchNode node) {
        if (!this.startNodes.contains(node)) {
            node.setNodeType(1);
            this.startNodes.add(node);
            node.setNodeAppearance(1);
        }
        if (this.goalNodes.contains(node)) {
            this.goalNodes.remove(node);
        }
    }

    public void setAsGoalNode(SearchNode node) {
        if (!this.goalNodes.contains(node)) {
            node.setNodeType(2);
            this.goalNodes.add(node);
            node.setNodeAppearance(2);
        }
        if (this.startNodes.contains(node)) {
            this.startNodes.remove(node);
        }
    }

    public void setAsRegularNode(SearchNode node) {
        node.setNodeType(0);
        node.setNodeAppearance(0);
        if (this.goalNodes.contains(node)) {
            this.goalNodes.remove(node);
        }
        if (this.startNodes.contains(node)) {
            this.startNodes.remove(node);
        }
    }

    public void invert() {
        SearchNode child;
        int j;
        SearchNode node;
        int i = 0;
        while (i < this.numNodes()) {
            node = (SearchNode)this.nodeAt(i);
            node.setOldNeighbours(new ArrayList<SearchNode>(node.getChildren().size()));
            j = 0;
            while (j < node.getChildren().size()) {
                child = node.getChildren().get(j);
                if (!child.getChildren().contains(node)) {
                    node.addOldNeighbour(child);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.numNodes()) {
            node = (SearchNode)this.nodeAt(i);
            j = 0;
            while (j < node.getOldNeighbours().size()) {
                child = (SearchNode)node.getOldNeighbours().get(j);
                SearchEdge newEdge = new SearchEdge(this, (Node)child, (Node)node);
                SearchEdge oldEdge = (SearchEdge)this.getEdge(node.getIndex(), child.getIndex());
                if (oldEdge != null) {
                    newEdge.setCost(oldEdge.getCost());
                }
                this.addEdge(newEdge);
                int k = 0;
                while (k < this.numEdges()) {
                    SearchEdge e = (SearchEdge)this.edgeAt(k);
                    if (e.start == node && e.end == child) {
                        node.removeEdgesOut(e);
                        this.edges.remove(e);
                        child.removeEdgesIn(e);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        SearchNode[] oldStartNodes = new SearchNode[this.startNodes.size()];
        int i2 = 0;
        while (i2 < this.startNodes.size()) {
            oldStartNodes[i2] = this.startNodes.get(i2);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.goalNodes.size()) {
            this.setAsStartNode(this.goalNodes.get(i2));
            ++i2;
        }
        i2 = 0;
        while (i2 < oldStartNodes.length) {
            this.setAsGoalNode(oldStartNodes[i2]);
            ++i2;
        }
        this.updateNodeSize();
        this.updateEdgeSize();
        ((SearchCanvas)this.canvas).resetSearch();
        ((SearchCanvas)this.canvas).greenify();
        this.repaint();
    }

    public void deleteSelectedEntities() {
        Iterator nodeItr = this.selectedNodes.iterator();
        ArrayList<Node> nodes = new ArrayList<Node>();
        while (nodeItr.hasNext()) {
            nodes.add((Node)nodeItr.next());
        }
        Iterator edgeItr = this.selectedEdges.iterator();
        ArrayList<Edge> edges = new ArrayList<Edge>();
        while (edgeItr.hasNext()) {
            edges.add((Edge)edgeItr.next());
        }
        this.deselectAll();
        nodeItr = nodes.iterator();
        while (nodeItr.hasNext()) {
            ((SearchCanvas)this.canvas).deleteEnt((Entity)nodeItr.next());
        }
        edgeItr = edges.iterator();
        while (edgeItr.hasNext()) {
            ((SearchCanvas)this.canvas).deleteEnt((Entity)edgeItr.next());
        }
        ((SearchCanvas)this.canvas).repaint();
    }

    public void setSortType(int sortType) {
        this.sortType = sortType;
    }
}

